<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class AddOrderColumnToCategoriesTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'categories';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {
        Capsule::schema()->table($this->table, function (Blueprint $table) {
            $table->integer('order')->after('icon')->nullable();
        });
    }

    public function rollback()
    {
        Capsule::schema()->table($this->table, function (Blueprint $table) {
            $table->dropColumn('order');
        });
    }
}
