<?php

set_time_limit(1000);

use Webuccino\Install\Core\Seeder;
use Webuccino\Install\Core\Session;
use Webuccino\Install\Core\Migration;

try {

    (new Migration())->runMigrations();
    writeImportLog("Seeding started");
    (new Seeder())->runSeeders();
    writeImportLog("Seeding finished");

    Session::put('database-imported', true);

    echo json_encode([
        "msg" => "DB imported successfully"
    ]);
} catch (\Exception $e) {
    writeImportLog("Seeding error " . $e->getMessage());

    Session::put('database-imported', false);
    echo json_encode([
        "msg" => $e->getMessage()
    ]);
}