<?php

namespace Webuccino\Install\Core;

use PHPMailer\PHPMailer\PHPMailer;

class SMTP
{
    public $mail;
    public function __construct($host, $port, $username, $password, $encryption, $auth_type)
    {
        $this->mail                               = new PHPMailer(true);
        $this->mail->SMTPAuth                     = true;
        $this->mail->Host                         = $host;
        $this->mail->Port                         = $port;
        $this->mail->Username                     = $username;
        $this->mail->Password                     = $password;
        $this->mail->SMTPSecure                   = $encryption;
        $this->mail->AuthType                     = $auth_type;
        $this->mail->Timeout                      = 30;
        $this->mail->getSMTPInstance()->Timelimit = 30;

    }

    public function checkConnection()
    {
        try {
            $this->mail->SmtpConnect();
            return ["success" => true, "msg" => "Connection to SMTP is successful"];
        } catch (\Exception $e) {
            $error = str_replace("SMTP Error:", "SMTP Connection Error", $e->getMessage());
            return ["success" => false, "msg" => $error];
        }
    }
}
