<?php

/**
 * Smart Reporting Package
 * Version 9.0.0
 * Author : Webuccino
 * All copyrights are preserved to Webuccino
 * URL : https://mysqlreports.com/
 */
ini_set('display_errors', 0);

class srm_dashboard implements dashboard_interface
{
    private $dashboard_connection;

    public function __construct($dashboard_connection)
    {
        $this->dashboard_connection = $dashboard_connection;
    }

/*
 * ===============================================================================
 *               Security methods to ptotect reports and wizard
 * ===============================================================================
 */

    /*
    Parent parameters
     */

    public function get_resource_configuration($resource_id)
    {

        if (!is_int($resource_id)) {
            return false;
        }

        $reader        = new Reader(tables_prefix . table_resource_configurations, $this->dashboard_connection);
        $configuration = $reader->get_properties_by_condition("*", 'Resource_id', $resource_id);

        if ($configuration) {
            return $configuration[0]; // Return first configuration found
        } else {
            srm_dashboard::log("No configuration found for resource", __FILE__ . "  LINE NO:" . __LINE__, __METHOD__, "", "info", "report_builder_common", "", json_encode(array("resource_id" => $resource_id)));
            return false;
        }

    }

// NEW METHOD: Get multiple resource configurations by resource IDs
    public function get_resource_configurations_by_ids($resource_ids)
    {

        if (!is_array($resource_ids) || empty($resource_ids)) {
            return array();
        }

        $configurations = array();
        $reader         = new Reader(tables_prefix . table_resource_configurations, $this->dashboard_connection);

        foreach ($resource_ids as $resource_id) {

            if (!is_int($resource_id)) {
                continue;
            }

            $config = $reader->get_properties_by_condition("*", 'Resource_id', $resource_id);

            if ($config) {
                $configurations[$resource_id] = $config[0]; // Use resource_id as key
            }

        }

        return $configurations;
    }

    public function get_user_group_id()
    {

        if (isset($_SESSION[Session_security_key][srm_access_group])) {
            return $_SESSION[Session_security_key][srm_access_group];
        } else {
            srm_dashboard::log("User group not found in session", __FILE__ . "  LINE NO:" . __LINE__, __METHOD__, "", "error", "report_builder_common", "", "");
            return false;
        }

    }

    public function get_user_role()
    {

        if (isset($_SESSION[Session_security_key][srm_access_role])) {
            return $_SESSION[Session_security_key][srm_access_role];
        } else {
            srm_dashboard::log("User role not found in session", __FILE__ . "  LINE NO:" . __LINE__, __METHOD__, "", "error", "report_builder_common", "", "");
            return false;
        }

    }

    public function get_all_reports()
    {
        $report_module_id = $this->get_blank_report_module_id();

        if (!$report_module_id) {
            return false;
        }

        $reader      = new Reader(tables_prefix . table_resources, $this->dashboard_connection);
        $all_reports = $reader->get_properties_by_condition("*", column_resources_module_id, $report_module_id, "`deleted_at` IS NULL");

        if ($all_reports) {
            // Extract report IDs and get configurations
            $report_ids = array_map(function ($report) {
                return $report[column_resources_id];
            }, $all_reports);

            $configurations = $this->get_resource_configurations_by_ids($report_ids);

            // MODIFICATION: Filter reports to only include those with relation = 'linked'
            $filtered_reports = array();

            foreach ($all_reports as $report) {
                $report_id = $report[column_resources_id];

                if (isset($configurations[$report_id]) && in_array($configurations[$report_id]['relation'],["intermediate","linked"])) {
                    $report['configuration'] = array(
                        'json_configurations' => $configurations[$report_id]['Json_configurations'],
                        'relation'            => $configurations[$report_id]['relation'],
                        'parameters'          => $configurations[$report_id]['parameters']
                    );
                    $filtered_reports[] = $report;
                }

            }

            return $filtered_reports;
        } else {
            srm_dashboard::log("No reports found in Report module", __FILE__ . "  LINE NO:" . __LINE__, __METHOD__, "", "info", "report_builder_common", "", json_encode(array("module_id" => $report_module_id)));
            return array();
        }

    }

    public function get_public_reports()
    {
        $report_module_id = $this->get_blank_report_module_id();

        if (!$report_module_id) {
            return false;
        }

        $reader         = new Reader(tables_prefix . table_resources, $this->dashboard_connection);
        $public_reports = $reader->get_properties_by_condition("*", column_resources_module_id, $report_module_id, "`" . column_resources_access_level . "` = 'Public' AND `deleted_at` IS NULL");

        if ($public_reports) {
            // Extract report IDs and get configurations
            $report_ids = array_map(function ($report) {
                return $report[column_resources_id];
            }, $public_reports);

            $configurations = $this->get_resource_configurations_by_ids($report_ids);

            // MODIFICATION: Filter reports to only include those with relation = 'linked'
            $filtered_reports = array();

            foreach ($public_reports as $report) {
                $report_id = $report[column_resources_id];

                if (isset($configurations[$report_id]) && in_array($configurations[$report_id]['relation'],["intermediate","linked"])) {
                    $report['configuration'] = array(
                        'json_configurations' => $configurations[$report_id]['Json_configurations'],
                        'relation'            => $configurations[$report_id]['relation'],
                        'parameters'          => $configurations[$report_id]['parameters']
                    );
                    $filtered_reports[] = $report;
                }

            }

            return $filtered_reports;
        } else {
            srm_dashboard::log("No public reports found", __FILE__ . "  LINE NO:" . __LINE__, __METHOD__, "", "info", "report_builder_common", "", json_encode(array("module_id" => $report_module_id)));
            return array();
        }

    }

    public function get_reports_by_creator($user_id)
    {

        if (!is_int($user_id)) {
            return false;
        }

        $report_module_id = $this->get_blank_report_module_id();

        if (!$report_module_id) {
            return false;
        }

        $reader          = new Reader(tables_prefix . table_resources, $this->dashboard_connection);
        $created_reports = $reader->get_properties_by_condition("*", column_resources_creator, $user_id, "`" . column_resources_module_id . "` = " . $report_module_id . " AND `deleted_at` IS NULL");

        if ($created_reports) {
            // Extract report IDs and get configurations
            $report_ids = array_map(function ($report) {
                return $report[column_resources_id];
            }, $created_reports);

            $configurations = $this->get_resource_configurations_by_ids($report_ids);

            // MODIFICATION: Filter reports to only include those with relation = 'linked'
            $filtered_reports = array();

            foreach ($created_reports as $report) {
                $report_id = $report[column_resources_id];

                if (isset($configurations[$report_id]) && in_array($configurations[$report_id]['relation'],["intermediate","linked"])) {
                    $report['configuration'] = array(
                        'json_configurations' => $configurations[$report_id]['Json_configurations'],
                        'relation'            => $configurations[$report_id]['relation'],
                        'parameters'          => $configurations[$report_id]['parameters']
                    );
                    $filtered_reports[] = $report;
                }

            }

            return $filtered_reports;
        } else {
            srm_dashboard::log("No reports found created by user", __FILE__ . "  LINE NO:" . __LINE__, __METHOD__, "", "info", "report_builder_common", "", json_encode(array("user_id" => $user_id, "module_id" => $report_module_id)));
            return array();
        }

    }

    public function get_reports_by_group_permission($group_id)
    {

        if (!is_int($group_id)) {
            return false;
        }

        $report_module_id = $this->get_blank_report_module_id();

        if (!$report_module_id) {
            return false;
        }

        $reader               = new Reader(tables_prefix . table_resources_permissions, $this->dashboard_connection);
        $permitted_report_ids = $reader->get_properties_by_multiple_conditions(
            column_resources_permissions_resource_id,
            array(
                column_resources_permissions_group_id => $group_id,
                column_resources_permissions_can_view => 1
            )
        );

        if ($permitted_report_ids) {
            // Filter to only get reports (not other resources)
            $report_ids = array();
            $reader     = new Reader(tables_prefix . table_resources, $this->dashboard_connection);

            foreach ($permitted_report_ids as $resource_id) {
                $module_id = $reader->get_property_by_id(column_resources_module_id, $resource_id["resource_id"], column_resources_id);

                if ($module_id == $report_module_id) {
                    $report_ids[] = $resource_id["resource_id"];
                }

            }

            return $report_ids;
        } else {
            srm_dashboard::log("No reports found with group permissions", __FILE__ . "  LINE NO:" . __LINE__, __METHOD__, "", "info", "report_builder_common", "", json_encode(array("group_id" => $group_id, "module_id" => $report_module_id)));
            return array();
        }

    }

    public function get_report_details_by_ids($report_ids)
    {

        if (!is_array($report_ids) || empty($report_ids)) {
            return array();
        }

        $reports_details = array();
        $reader          = new Reader(tables_prefix . table_resources, $this->dashboard_connection);

        // Get all configurations at once for efficiency
        $configurations = $this->get_resource_configurations_by_ids($report_ids);

        foreach ($report_ids as $report_id) {

            if (!is_int($report_id)) {
                continue;
            }

            $report_details = $reader->get_properties_by_id("*", $report_id, column_resources_id);

            if ($report_details) {

                if (isset($configurations[$report_id]) && in_array($configurations[$report_id]['relation'],["intermediate","linked"])) {
                    $report_details['configuration'] = array(
                        'json_configurations' => $configurations[$report_id]['Json_configurations'],
                        'relation'            => $configurations[$report_id]['relation'],
                        'parameters'          => $configurations[$report_id]['parameters']
                    );
                    $reports_details[] = $report_details;
                }

            }

        }

        return $reports_details;
    }

    public function get_user_accessible_reports($user_id)
    {

        if (!is_int($user_id)) {
            return false;
        }

        $user_role = $this->get_user_role();

// If user is admin, return all reports
        if ($user_role && strtolower($user_role) == 'admin') {
            $all_reports = $this->get_all_reports();

            if ($all_reports) {
                return $all_reports;
            } else {
                srm_dashboard::log("No reports found for admin user", __FILE__ . "  LINE NO:" . __LINE__, __METHOD__, "", "info", "report_builder_common", "", json_encode(array("user_id" => $user_id, "role" => $user_role)));
                return array();
            }

        }

        // For non-admin users, check permissions
        $accessible_report_ids = array();

        // 1. Get public reports
        $public_reports = $this->get_public_reports();

        if ($public_reports) {

            foreach ($public_reports as $report) {

                if (isset($report[column_resources_id])) {
                    $accessible_report_ids[] = $report[column_resources_id];
                }

            }

        }

        // 2. Get reports created by user
        $created_reports = $this->get_reports_by_creator($user_id);

        if ($created_reports) {

            foreach ($created_reports as $report) {

                if (isset($report[column_resources_id]) && !in_array($report[column_resources_id], $accessible_report_ids)) {
                    $accessible_report_ids[] = $report[column_resources_id];
                }

            }

        }

        // 3. Get reports accessible through group permission

        $user_group_id = $this->get_user_group_id();

        if ($user_group_id) {
            $permitted_report_ids = $this->get_reports_by_group_permission($user_group_id);

            if ($permitted_report_ids) {

                foreach ($permitted_report_ids as $report_id) {

                    if (!in_array($report_id, $accessible_report_ids)) {
                        $accessible_report_ids[] = $report_id;
                    }

                }

            }

        }

// 4. Get full report details for accessible reports
        if (!empty($accessible_report_ids)) {
            $accessible_reports = $this->get_report_details_by_ids($accessible_report_ids);
            return $accessible_reports;
        } else {
            srm_dashboard::log("No accessible reports found for user", __FILE__ . "  LINE NO:" . __LINE__, __METHOD__, "", "info", "report_builder_common", "", json_encode(array("user_id" => $user_id, "role" => $user_role)));
            return array();
        }

    }

    /*
     * @param $report_id report id
     * return public_report , private_report const or False if report dosn't exist
     */

    public function get_report_access_type($report_id)
    {

        if (!is_int($report_id)) {
            return false;
        }

        $reader       = new Reader(tables_prefix . table_resources, $this->dashboard_connection);
        $access_level = $reader->get_property_by_id(column_resources_access_level, $report_id, column_resources_id);

        if ($access_level) {
            return $access_level;
        } else {
            srm_dashboard::log("Report dosn't exist or its access level in Null", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", "error", "report_builder_common", "", json_encode(array("report_id" => $report_id)));
            return false;
        }

    }

    /*
     * @param $report_id report id
     * return public_report , private_report const or False if report dosn't exist
     */

    public function get_report_access_creator($report_id)
    {

        if (!is_int($report_id)) {
            return false;
        }

        $reader           = new Reader(tables_prefix . table_resources, $this->dashboard_connection);
        $resource_creator = $reader->get_property_by_id(column_resources_creator, $report_id, column_resources_id);

        if ($resource_creator) {
            return $resource_creator;
        } else {
            srm_dashboard::log("Report doesn't exist or its access level in Null", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", "error", "report_builder_common", "", json_encode(array("report_id" => $report_id)));
            return false;
        }

    }

    /*
     * @param $report_id report id
     * return array of group IDs who has access to the report
     */

    public function get_private_report_permissions($report_id)
    {

        if (!is_int($report_id)) {
            return false;
        }

        $reader = new Reader(tables_prefix . table_resources_permissions, $this->dashboard_connection);
        return $reader->get_filtered_ids(column_resources_permissions_resource_id, $report_id, column_resources_permissions_group_id, "`" . column_resources_permissions_can_view . "` = 1");
    }

    /*
     *
     * return array of group Ids who has access to the wizard
     */

    public function get_wizard_permissions()
    {
        $reader                 = new Reader(tables_prefix . table_modules_permissions, $this->dashboard_connection);
        $blank_report_module_id = $this->get_blank_report_module_id('Reports');
        return $reader->get_filtered_ids(column_modules_permissions_module_id, $blank_report_module_id, column_modules_permissions_group_id, "`" . column_modules_permissions_can_add_new . "` = 1");
    }

/*
 * ===============================================================================
 *               Connection step in wizard
 * ===============================================================================
 */

    /*
     * @param $connection_string_name a valid connection name saved in DB
     * return Assoc array of connection properties or false if connection dosn't exist.
     */

    public function get_connection_details($connection_string_name)
    {
        $reader                = new Reader(tables_prefix . table_connection_strings, $this->dashboard_connection);
        $connection_db_details = $reader->filter_by_column(column_connection_name, trim($connection_string_name));

        if (is_array($connection_db_details) && !empty($connection_db_details) && count($connection_db_details) == 1) {
            $credentials = srm_decrept_connectionstring($connection_db_details[0][column_connection_string]);
            return array(
                column_connection_name      => $connection_db_details[0][column_connection_name],
                column_connection_db_type   => $connection_db_details[0][column_connection_db_type],
                column_connection_server    => $connection_db_details[0][column_connection_server],
                column_connection_user      => $credentials[column_connection_user],
                column_connection_pass      => $credentials[column_connection_pass],
                column_connection_db        => $connection_db_details[0][column_connection_db],
                column_connection_charset   => $credentials[column_connection_charset],
                column_connection_collation => $credentials[column_connection_collation],
                column_connection_port      => $credentials[column_connection_port]
            );
        } else {
            srm_dashboard::log("Can't get connection details", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", "error", "report_builder_common", "", "");
            return false;
        }

    }

    /*
     * return array Assoc array of properties of default connection
     */

    public function get_default_connection_details()
    {
        return array(
            column_connection_name      => default_connection_name,
            column_connection_db_type   => "MYSQL",
            column_connection_server    => DEFAULT_HOST,
            column_connection_user      => DEFAULT_DBUSER,
            column_connection_pass      => DEFAULT_DBPASS,
            column_connection_db        => DEFAULT_DBNAME,
            column_connection_charset   => "",
            column_connection_collation => "",
            column_connection_port      => ""
        );
    }

    /*
     * return array of saved connection names including the default connection name.
     */

    public function get_all_connection_names()
    {
        $result      = array();
        $reader      = new Reader(tables_prefix . table_connection_strings, $this->dashboard_connection);
        $result["0"] = default_connection_name;
        return array_merge($result, $reader->select_all_names_and_Ids(column_connection_name, column_connection_id, true));
    }

/*
 * ===============================================================================
 *               Groups and Categories steps in wizard
 * ===============================================================================
 */

    /*
     * return array of categories names or empty array if no categories.
     */

    public function get_all_categories_names()
    {
        $reader = new Reader(tables_prefix . table_categories, $this->dashboard_connection);
        return $reader->select_all_names_and_Ids_by_order(column_category_name, column_category_id, true);
    }

    /*
     * return array of group names or empty array if no groups.
     */

    public function get_all_groups_names()
    {
        $reader = new Reader(tables_prefix . table_groups, $this->dashboard_connection);
        return $reader->select_all_names_and_Ids(column_group_name, column_group_id, true);
    }

    /*
     * @param $report_id report id
     *
     * return string saved report name
     */

    public function get_existed_name($report_id)
    {

        if (!is_int($report_id)) {
            return false;
        }

        $reader = new Reader(tables_prefix . table_resources, $this->dashboard_connection);
        return $reader->get_property_by_id(column_resources_name, $report_id, column_resources_id);
    }

    public function get_last_report_id()
    {

        $reader = new Reader(tables_prefix . table_resources, $this->dashboard_connection);
        return $reader->get_last_report_id(
            $this->get_blank_report_module_id()
        );
    }

/*
 * ===============================================================================
 *              Creating a new report in Engine
 * ===============================================================================
 */

    /*
     * @param $name report name
     * @param $category_id valid forign key from categories table
     * @param $connection_name saved connection name
     * @param $creator valid forign key from users table
     * @param $access_level either private_report or public_report constant
     * return if success: the inserted record ID or: false if insert failed
     */

    public function save_new_blank_report($name, $category_id, $connection_name, $creator, $access_level = private_report)
    {
        $edited_name   = str_replace(" ", "", trim($name));
        $report_url    = report_base_path . "$edited_name/$edited_name.php";
        $connection_id = (strtolower($connection_name) != strtolower(default_connection_name)) ? $this->get_connection_id(trim($connection_name)) : 0;

        if (!$this->is_report_existed_by_url($report_url)) {

            if (
                $this->is_entity_exist_by_value(table_categories, column_category_id, $category_id) &&
                $this->is_entity_exist_by_value(table_users, column_users_id, $creator)
            ) {

                if (strtolower($connection_name) != strtolower(default_connection_name)) {
                    $resource_details = array(
                        column_resources_name          => $name,
                        column_resources_module_id     => $this->get_blank_report_module_id(),
                        column_resources_category_id   => $category_id,
                        column_resources_creator       => $creator,
                        column_resources_connection_id => $connection_id,
                        column_resources_url           => $report_url,
                        column_resources_access_level  => $access_level,
                        column_resources_created_at    => date('Y-m-d H:i:s')

                    );
                } else {
                    $resource_details = array(
                        column_resources_name         => $name,
                        column_resources_module_id    => $this->get_blank_report_module_id(),
                        column_resources_category_id  => $category_id,
                        column_resources_creator      => $creator,
                        column_resources_url          => $report_url,
                        column_resources_access_level => $access_level,
                        column_resources_created_at   => date('Y-m-d H:i:s')

                    );
                }

                $writer = new Writer(tables_prefix . table_resources, $resource_details, $this->dashboard_connection);
                return $writer->insert();
            } else {
                self::log("Error creating report", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_common_common", "", json_encode($resource_details));
                throw new Exception('Error creating report.', 10000);
                return false;
            }

        } else {
            self::log("Error creating report, a report with same name already existed", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_common_common", "", "report_name: " . $name);
            throw new Exception('Error creating report, a report with same name already existed', 10007);
            return false;
        }

    }

    /*
     * @param $blank_report_id report id
     * @param $group_ids array of the group IDs to get Access to the report
     * return int number of added records
     */

    public function save_private_report_permissions($blank_report_id, $group_ids, $rollback = false)
    {

// $group_ids = json_decode($group_ids)->access_groups;

        if ($this->is_entity_exist_by_value(table_groups, column_group_id, $group_ids)) {
            $added_records = array();
            if (empty($group_ids)) {
                return true;
            }

            if ($_SESSION[Session_security_key][srm_access_role] == "admin") {
                foreach ($group_ids as $group_id) {
                    $resource_permission_details = array(
                        column_resources_permissions_resource_id => $blank_report_id,
                        column_resources_permissions_group_id    => $group_id,
                        column_resources_permissions_can_view    => 1
                    );
                    $writer          = new Writer(tables_prefix . table_resources_permissions, $resource_permission_details, $this->dashboard_connection);
                    $added_records[] = $writer->insert();
                }

            } else {
                $resource_permission_details = array(
                    column_resources_permissions_resource_id => $blank_report_id,
                    column_resources_permissions_group_id    => $_SESSION[Session_security_key][srm_access_group],
                    column_resources_permissions_can_view    => 1
                );
                $writer          = new Writer(tables_prefix . table_resources_permissions, $resource_permission_details, $this->dashboard_connection);
                $added_records[] = $writer->insert();
            }

            return count($added_records);
        } else {
            if ($rollback) {
                $this->safely_delete_report($blank_report_id);
            }

            self::log("Report or Groups dosn't exist", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_common_common", "", json_encode($group_ids));
            throw new Exception("Report or Groups dosn't exist", 10004);
            return false;
        }

    }

    /*
     * @param $report_name report name
     * return bool
     */

    public function is_report_existed_by_name($report_name)
    {
        $edited_name = str_replace(" ", "", trim($report_name));
        $report_url  = report_base_path . "$edited_name/$edited_name.php";
        return $this->is_report_existed_by_url($report_url);
    }

    /*
     * @param $url report URL
     * return bool
     */

    public function is_report_existed_by_url($url)
    {
        $reader = new Reader(tables_prefix . table_resources, $this->dashboard_connection);
        $record = $reader->filter_by_column(column_resources_url, $url, true, column_resources_id);

        if (empty($record) || $record == false) {
            self::log("Report  dosn't exist", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_common_common", "", json_encode(array("url" => $url)));
            return false;
        } else {
            return $record;
        }

    }

    /*
     * @param $report_id report id
     * return bool
     */

    public function is_report_existed_by_id($report_id)
    {
        $reader = new Reader(tables_prefix . table_resources, $this->dashboard_connection);
        $record = $reader->filter_by_column(column_resources_id, $report_id, true, column_resources_id);

        if (empty($record) || $record == false) {
            self::log("Report dosn't exist", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_common_common", "", json_encode(array("report_id" => $report_id)));
            return false;
        } else {
            return $record;
        }

    }

    /*
     * @param $blank_report_id report id
     * @param $configuration_session_object Json object of A report configurations
     * return bool
     */

    public function save_resource_configurations($blank_report_id, $configuration_session_object, $parameters, $relation, $rollback = false)
    {
        $resource_config_details = array(
            column_configuration_resource_id => $blank_report_id,
            column_configuration_json        => $configuration_session_object,
            column_configuration_parameters  => $parameters,
            column_configuration_relation    => $relation

        );
        $writer = new Writer(tables_prefix . table_resource_configurations, $resource_config_details, $this->dashboard_connection);
        $id     = $writer->insert();

        if ($id) {
            return $id;
        } else {

            if ($rollback) {
                $this->safely_delete_report($blank_report_id);
            }

            self::log("can't save report configurations", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_common_common", "", $configuration_session_object);
            throw new Exception("Can't save report configurations", 10006);
            return false;
        }

    }

    /*
     * ===============================================================================
     *              Editing an existing report
     * ===============================================================================
     */

    public function edit_blank_report($report_id, $name, $category_id, $connection_name, $creator, $access_level = private_report)
    {
        $edited_name = str_replace(" ", "", trim($name));
        $report_url  = report_base_path . "$edited_name/$edited_name.php";

        if ($connection_name != default_connection_name) {
            $connection_id = $this->get_connection_id(trim($connection_name));
        }

        if (
            is_int($report_id) && $this->is_entity_exist_by_value(table_categories, column_category_id, $category_id) &&
            $this->is_entity_exist_by_value(table_users, column_users_id, $creator) &&
            ($connection_id || $connection_name == default_connection_name)
        ) {

            $resource_details = array(
                column_resources_name         => $name,
                column_resources_module_id    => $this->get_blank_report_module_id(),
                column_resources_category_id  => $category_id,
                // column_resources_creator => $creator,

                column_resources_url          => $report_url,
                column_resources_access_level => $access_level
            );

            if ($connection_name != default_connection_name) {
                $resource_details = array_merge($resource_details, [column_resources_connection_id => $connection_id]);
            }

            $writer = new Writer(tables_prefix . table_resources, $resource_details, $this->dashboard_connection);
            return $writer->update($report_id, column_resources_id);
        } else {

            self::log("Error editing report.", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_common_common", "", json_encode($resource_details));
            throw new Exception('Error editing report.', 10001);
            return false;
        }

    }

    public function change_private_report_permissions($report_id, $group_ids)
    {

//make sure report exists and groups exists in parent table.

//make sure no prior permissions exists.
        // delete existing permissions

        $writer = new Writer(tables_prefix . table_resources_permissions, array(), $this->dashboard_connection);
        $writer->delete_by_id($report_id, column_resources_permissions_resource_id);

        if (empty($group_ids)) {
            return true;
        } else {
            return $this->save_private_report_permissions($report_id, $group_ids);
        }

    }

    public function edit_resource_configurations($blank_report_id, $new_configuration_session_object, $parameters, $relation)
    {
        $resource_config_details = array(
            column_configuration_resource_id => $blank_report_id,
            column_configuration_json        => $new_configuration_session_object,
            column_configuration_parameters  => $parameters,
            column_configuration_relation    => $relation


        );
        $writer = new Writer(tables_prefix . table_resource_configurations, $resource_config_details, $this->dashboard_connection);
        return $writer->update($blank_report_id, column_configuration_resource_id);
    }

    public function load_report_configurations($report_id)
    {
        $reader     = new Reader(tables_prefix . table_resource_configurations, $this->dashboard_connection);
        $record     = $reader->filter_by_column(column_configuration_resource_id, $report_id, true, column_configuration_json);
        $parameters = $reader->filter_by_column(column_configuration_resource_id, $report_id, true, column_configuration_parameters);

        $barcodes = $reader->select_all_by_columns(
            [column_barcodes_definitions_id, column_barcodes_definitions_label],
            tables_prefix . table_barcode_definitions
        );

        if (empty($record) || $record == false) {
            srm_dashboard::log("Can't load report configuration", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", "error", "report_builder_common", "", json_encode(array("report_id" => $report_id)));
            return false;
        } else {
            // var_dump(json_decode($parameters[0][column_configuration_parameters],true));
            $parameters = json_decode($parameters[0][column_configuration_parameters], true);
            $_SESSION[Session_report_Settings_key]       = json_decode($record[0][column_configuration_json], true);
            $_SESSION[Session_report_Parameters]         = isset($parameters["linked"]) ? $parameters["linked"] : $parameters;

            // convert $barcodes into 1d array
            foreach ($barcodes as $row) {
                $_SESSION[Session_report_Barcodes_definitions][$row[0]] = $row[1];
            }
            $_SESSION[Session_report_Parameters_Mapping] = isset($parameters["parent"])
            ? $this->prepare_parameters_mapping($parameters["parent"])
            : $this->prepare_parameters_mapping($parameters);

            if ($_SESSION[Session_report_Settings_key]["connection_name"] != default_connection_name) {
                $parameters = $this->get_connection_details(trim($_SESSION[Session_report_Settings_key]["connection_name"]));
            } else {
                $parameters = $this->get_default_connection_details();
            }

            $DB_HOST      = isset($parameters["server"]) ? $parameters["server"] : "";
            $DB_USER      = isset($parameters["user"]) ? $parameters["user"] : "";
            $DB_PASSWORD  = isset($parameters["password"]) ? $parameters["password"] : "";
            $DB_NAME      = isset($parameters["db"]) ? $parameters["db"] : "";
            $DB_CHARSET   = isset($parameters["charset"]) ? $parameters["charset"] : "";
            $DB_COLLATION = isset($parameters["collation"]) ? $parameters["collation"] : "";
            $DB_PORT      = isset($parameters["port"]) ? $parameters["port"] : "";

            if (strpos($DB_HOST, ":") === false && !empty($DB_PORT) && $DB_PORT != 3306) {
                $DB_HOST = $DB_HOST . ":" . $DB_PORT;
            }

            $dbHandler = new DatabaseHandler($DB_HOST, $DB_USER, $DB_PASSWORD, $DB_NAME);

            if ($dbHandler) {

                if (Session_Save_Parameters == 1) {
                    $_SESSION[Session_report_Settings_key]["host"]      = $DB_HOST;
                    $_SESSION[Session_report_Settings_key]["user"]      = $DB_USER;
                    $_SESSION[Session_report_Settings_key]["pass"]      = $DB_PASSWORD;
                    $_SESSION[Session_report_Settings_key]["collation"] = $DB_COLLATION;
                    $_SESSION[Session_report_Settings_key]["charset"]   = $DB_CHARSET;
                    $_SESSION[Session_report_Settings_key]["port"]      = $DB_PORT;
                }

                $_SESSION[Session_wizard_key]["validate_key"] = md5("srm_f92024_report_settings_valid_1010");
                $_SESSION[Session_wizard_key]["page_key"]     = 'step_2';
                $_SESSION[Session_wizard_key]["active_pages"] = array(
                    'step_5_1',
                    'step_6'
                );
                $_SESSION[Session_wizard_key]["loaded_config_id"] = $report_id;
            } else {
                srm_dashboard::log("Can't connect to DB to load report configurations", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", "error", "report_builder_common", "", "");
                return false;
            }
            return true;
        }

    }

    public function prepare_parameters_mapping($parameters)
    {
        $ids     = $this->extractReportIds($parameters);
        $details = $this->get_report_details_by_ids($ids);
        return $this->mergeReportDetails($parameters, $details);
    }

    public function extractReportIds($originalArray)
    {
        $ids = array();

        foreach ($originalArray as $key => $report) {
            $ids[] = intval($report['id']); // Convert to int to match database format
        }

        return $ids;
    }

    public function mergeReportDetails($originalArray, $reportDetails)
    {
        // Create a lookup array from report details for faster access
        $detailsLookup = array();

        foreach ($reportDetails as $details) {
            $detailsLookup[$details['id']] = $details;
        }

// Merge details into original array
        foreach ($originalArray as $key => &$report) {
            $reportId = intval($report['id']);
// Convert to int to match

            if (isset($detailsLookup[$reportId])) {
                $report['name'] = $detailsLookup[$reportId]['name'];
                $report['url']  = $detailsLookup[$reportId]['url'];
            }

        }

        return $originalArray;
    }

    public function unload_report_configurations()
    {
        unset($_SESSION[Session_report_Settings_key]);
    }

/*
 * ===============================================================================
 *              Deleting a report and all its permissions
 * ===============================================================================
 */

    /*
     * @param $report_id report id
     *
     */

    public function delete_report_with_permissions($report_id)
    {

        if ($this->is_entity_exist_by_value(table_resources, column_resources_id, $report_id)) {
            $writer = new Writer(tables_prefix . table_resources_permissions, array(), $this->dashboard_connection);
            $writer->delete_by_id($report_id, column_resources_permissions_resource_id);
            $writer = new Writer(tables_prefix . table_resources, array(), $this->dashboard_connection);
            $writer->delete_by_id($report_id, column_resources_id);
        }

    }

    public function safely_delete_report($report_id)
    {

        $writer = new Writer(tables_prefix . table_resources_permissions, array(), $this->dashboard_connection);
        $writer->delete_by_id($report_id, column_resources_permissions_resource_id);
        $writer = new Writer(tables_prefix . table_resource_configurations, array(), $this->dashboard_connection);
        $writer->delete_by_id($report_id, column_configuration_resource_id);
        $writer = new Writer(tables_prefix . table_resources, array(), $this->dashboard_connection);
        $writer->delete_by_id($report_id, column_resources_id);
    }

/*
 * ===============================================================================
 *              Infrastructure internal methods
 * ===============================================================================
 */

    /*
     *
     * return id of blank report in Modules table
     */

    private function get_blank_report_module_id($report = 'Blank Reports')
    {
        $reader = new Reader(tables_prefix . table_modules, $this->dashboard_connection);
        $record = $reader->filter_by_column(column_module_name, $report, true, column_module_id);
        return $record[0][column_module_id];
    }

    private function get_connection_id($searched_connection_name)
    {
        $reader = new Reader(tables_prefix . table_connection_strings, $this->dashboard_connection);
        $record = $reader->filter_by_column(column_connection_name, $searched_connection_name, true, column_connection_id);

        if (isset($record[0][column_connection_id])) {
            return $record[0][column_connection_id];
        } else {
            srm_dashboard::log("Connection name dosn't exist", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", "error", "report_builder_common", "", json_encode(array("searched_connection_name" => $searched_connection_name)));
            return false;
        }

    }

    private function is_entity_exist_by_value($table, $column, $values)
    {
        $reader = new Reader(tables_prefix . $table, $this->dashboard_connection);

        if (!is_array($values)) {
            return $reader->is_entity_exist_by_value($column, $values);
        } else {

            foreach ($values as $value) {

                if (!$reader->is_entity_exist_by_value($column, $value)) {
                    srm_dashboard::log("entity in $table dosn't exist", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", "error", "report_builder_common", "", json_encode(array("table" => $table, "column" => $column, "searched_value" => $value)));
                    return false;
                }

            }

            return true;
        }

    }

    public static function log($message, $file = "", $method = "", $trace = "", $severity = log_default_severity, $module = "report_builder_common", $query = "", $config = "", $levels = log_file_default_levels)
    {

        $edited_trace = (log_stack_trace === 1) ? $trace : "";

        $log_details = array(
            column_created_at      => date('Y-m-d H:i:s'),
            column_log_message     => $message,
            column_log_file        => $file,
            column_log_method      => $method,
            column_log_module      => $module,
            column_log_severity    => $severity,
            column_log_stack_trace => $edited_trace,
            column_log_query       => $query,
            column_log_config      => $config,
            column_log_php         => phpversion(),
            column_log_os          => PHP_OS
        );

//if (in_array("db",log_drivers)) {

//  writer::log($log_details);

//  }
        if (in_array("file", log_drivers)) {
            // Convert JSON data from an array to a string
            $jsonString = json_encode($log_details, JSON_PRETTY_PRINT);
            $path       = str_repeat("../", $levels);
            $path       = (substr(log_file_path, -1) == "/") ? $path . log_file_path : $path . log_file_path . "/";

            if (is_dir($path)) {
                $path .= "builder.log";
            } elseif (is_dir(substr($path, 3))) {
                $path = substr($path, 3) . "builder.log";
            } elseif (is_dir("../" . $path)) {
                $path = "../" . $path . "builder.log";
            } else {
                return false;
            }

            $fp = fopen($path, 'a+');
            fwrite($fp, $jsonString);
            fclose($fp);
        }

    }

}
