<?php

/**
 * Smart Report Maker
 * Version 9.0.0
 * Author : Webuccino
 * All copyrights are preserved to Webuccino
 * URL : http://mysqlreports.com/
 */
defined('DIRECTACESS') or die("Error 301: Access denied!");

abstract class Engine
{
    private $_report_id;
    private $_file_name   = '';
    private $_report_path = "";
    private $_category_id;
    protected $_reports_directory;
    private $_date_created               = '';
    private $_maintainance_email         = '';
    private $_images_path                = 'images/';
    private $_headers_output_escaping    = "Yes";
    private $_default_page_size          = "A3";
    private $_output_escaping            = "Yes";
    private $_thumnail_max_width         = '120';
    private $_thumnail_max_height        = '120';
    private $_show_real_size_image       = '';
    private $_show_realsize_in_popup     = '1';
    private $_chkSearch                  = 'yes';
    private $_language                   = "en";
    private $_db_extension               = 'pdo';
    private $_datasource                 = 'table';
    private $_table                      = array();
    private $_tables_filters             = array();
    private $_tables_parameters          = array();
    private $_tables_parameters_mapping  = array();
    private $_fields                     = array();
    private $_report_relation                     = array();
    private $_relationships              = array();
    private $_sql                        = '';
    private $_fields2                    = array();
    private $_records_per_page           = '10';
    private $_layout                     = "AlignLeft";
    private $_style_name                 = 'blue';
    private $_title                      = '';
    private $_header                     = '';
    private $_footer                     = '';
    private $_is_mobile                  = '';
    private $_cells                      = array();
    private $_field_settings                      = array();
    private $_conditional_formating      = array();
    private $_labels                     = "";
    private $_group_by                   = array();
    private $_sort_by                    = array();
    private $statestical_affected_column = "";
    private $statestical_function        = "";
    private $statestical__groupby_column = "";
    private $connection_name             = "";
    private $connection_db_user          = "";
    private $connection_db_pass          = "";
    private $connection_db_host          = "";
    private $connection_db_name          = "";
    private $_filters_grouping           = '';
    private $_sub_totals                 = array();
    private $_sub_totals_enabled         = "";
    private $_access_rule;
    private $_access_groups;
    private $path_to_engine = "../engine/";

    abstract protected function validate_request($srm_dashboard);

    /*
     * RecursiveMkdir
     *
     * Creates the report folder
     *
     * @param (path) path of the report directory
     */

    protected function RecursiveMkdir($path)
    {

        if (!file_exists($path)) {
            $this->RecursiveMkdir(dirname($path));

            if (mkdir($path, 0755)) {
                return true;
            } else {
                srm_dashboard::log("Could not create directory $path, permission denied.", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_engine", "", json_encode($_SESSION[Session_report_Settings_key]));
                throw new Exception("Error 603: Could not create directory $path, permission denied");
            }

        }

    }

    /**
     * create_report_structure()
     * This function copy necessary files to create the report
     *    *
     */
    protected function create_report_structure()
    {
        //  copy("Core/images", $this->_report_path . "/images/");
        copy($this->path_to_engine . "Core/auto_load.php", $this->_report_path . "/auto_load.php");
        copy($this->path_to_engine . "Core/calculated_columns.php", $this->_report_path . "/calculated_columns.php");
        copy($this->path_to_engine . "Core/ChangeLayout.php", $this->_report_path . "/ChangeLayout.php");
        copy($this->path_to_engine . "Core/ChangeStyle.php", $this->_report_path . "/ChangeStyle.php");
        //  copy("Core/Detailed-view.php", $this->_report_path . "/Detailed-view.php");
        copy($this->path_to_engine . "Core/email_report.php", $this->_report_path . "/email_report.php");

        copy($this->path_to_engine . "Core/index.html", $this->_report_path . "/index.html");

        copy($this->path_to_engine . "Core/Mobile.php", $this->_report_path . "/Mobile.php");
        copy($this->path_to_engine . "Core/Mobile_Detect.php", $this->_report_path . "/Mobile_Detect.php");
        copy($this->path_to_engine . "Core/report_index.php", $this->_report_path . "/" . $this->_file_name . ".php");
        copy($this->path_to_engine . "Core/request.php", $this->_report_path . "/request.php");
        copy($this->path_to_engine . "Core/Tablet.php", $this->_report_path . "/Tablet.php");
        copy($this->path_to_engine . "Core/filter.php", $this->_report_path . "/filter.php");
        copy($this->path_to_engine . "Core/redirect_edit.php", $this->_report_path . "/redirect_edit.php");
        copy($this->path_to_engine . "Core/redirect_add.php", $this->_report_path . "/redirect_add.php");
    }

    /**
     * create_init_file
     * This function creates the init file which stores the connection to the database
     *
     */
    protected function create_init_file()
    {
        $fp = fopen($this->_report_path . "/init.php", "w+");

        if ($fp) {

            if (fwrite($fp, '<?php' . PHP_EOL)) {
                fwrite($fp, 'if (! defined("DIRECTACESS")) exit("No direct script access allowed"); ' . PHP_EOL);

                fwrite($fp, '$connection_name = "' . trim($this->connection_name) . '";' . PHP_EOL);

                fclose($fp);
            } else {
                srm_dashboard::log("Can not write in the init configuration file of the generated report, permission denied. Please make sure to give 755 permissions to the following directory", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_engine", "", json_encode($_SESSION[Session_report_Settings_key]));
                throw new Exception('Error 606: Can not write in the init configuration file of the generated report, permission denied. Please make sure to give 755 permissions to the following directory' . PHP_EOL);
            }

        } else {
            srm_dashboard::log("Can not write in the init configuration file of the generated report, permission denied. Please make sure to give 755 permissions to the following directory", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_engine", "", json_encode($_SESSION[Session_report_Settings_key]));
            throw new Exception('Error 607: can not create the init configuration file of the generated report, permission denied. Please make sure to give 755 permissions to the following directory' . PHP_EOL);
        }

    }

    /**
     * create_report_config
     *
     * This function creates the config file of the report
     *
     */
    protected function create_report_config()
    {
        $fp = fopen($this->_report_path . "/config.php", "w+");

        if ($fp) {

            if (fwrite($fp, '<?php' . PHP_EOL)) {

                if ($this->_title == "") {
                    fwrite($fp, "//Untitled Report," . $this->_date_created . PHP_EOL);
                } else {
                    fwrite($fp, "//" . $this->_title . "," . $this->_date_created . PHP_EOL);
                }

                fwrite($fp, 'if (! defined("DIRECTACESS")) exit("No direct script access allowed"); ' . PHP_EOL);

                fwrite($fp, '$file_name = "' . $this->_file_name . '";' . PHP_EOL);
                //actual report id should replace this line  $report_id = 1;
                fwrite($fp, '$report_id = ' . $this->_report_id . ';' . PHP_EOL);
                $this->write_customization_settings($fp);
                $this->write_wizard_settings($fp);
                fclose($fp);
            } else {
                srm_dashboard::log("Can not write in the config configuration file of the generated report, permission denied. Please make sure to give 755 permissions to the following directory", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_engine", "", json_encode($_SESSION[Session_report_Settings_key]));
                throw new Exception('Error 604: can write in the configuration file of the generated report, permission denied! Please make sure to give 755 permissions to the following directory' . PHP_EOL);
            }

        } else {
            srm_dashboard::log("Can not write in the config configuration file of the generated report, permission denied. Please make sure to give 755 permissions to the following directory", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_engine", "", json_encode($_SESSION[Session_report_Settings_key]));
            throw new Exception('Error 605: can not create the configuration file of the generated report, permission denied! Please make sure to give 755 permissions to the following directory' . PHP_EOL);
        }

    }

    /**
     * rename_dir
     * rename report directory when edit
     *
     */

    private function rename_report_dir($existed_report_name, $new_report_name)
    {
        $existed_report_name = trim(str_replace(" ", "", $existed_report_name));
        $existed_report_path = $this->_reports_directory . $existed_report_name;

        $new_report_path = $this->_reports_directory . $this->_file_name;

        if ($existed_report_name != $new_report_name) {
            rename($existed_report_path, $new_report_path);
            rename($new_report_path . '/' . $existed_report_name . '.php', $new_report_path . '/' . $new_report_name . '.php');
        }

    }

    /**
     * write_customization_settings
     * This private function is called by the create_report_config() and write the customization settings
     * @param type $fp is a refrence to the config file
     */
    private function write_customization_settings($fp)
    {
        fwrite($fp, '//  customization settings' . PHP_EOL);

        fwrite($fp, '$category_id = ' . $this->_category_id . ';' . PHP_EOL);
        fwrite($fp, '$date_created = "' . $this->_date_created . '";' . PHP_EOL);
        fwrite($fp, '$maintainance_email = "";' . PHP_EOL);
        fwrite($fp, '$maintainance_mode = false;' . PHP_EOL);
        fwrite($fp, '$images_path = "' . $this->_images_path . '";' . PHP_EOL);
        fwrite($fp, '$headers_output_escaping = "' . $this->_headers_output_escaping . '";' . PHP_EOL);
        fwrite($fp, '$default_page_size = "' . $this->_default_page_size . '";' . PHP_EOL);
        fwrite($fp, '$output_escaping = "' . $this->_output_escaping . '";' . PHP_EOL);
        fwrite($fp, '$thumnail_max_width = "' . $this->_thumnail_max_width . '";' . PHP_EOL);
        fwrite($fp, '$thumnail_max_height = "' . $this->_thumnail_max_height . '";' . PHP_EOL);
        fwrite($fp, '$show_real_size_image = "' . $this->_show_real_size_image . '";' . PHP_EOL);
        fwrite($fp, '$show_realsize_in_popup = "' . $this->_show_realsize_in_popup . '";' . PHP_EOL);
        fwrite($fp, '$chkSearch = "' . $this->_chkSearch . '";' . PHP_EOL);
    }

    /**
     * process_filter_array
     * This function remove any redunduncies from the filter array, it's called only when the filter array is not empty
     */
    protected function process_filter_array()
    {
        $params = array();
        $sql    = array();
        $types  = array();

        foreach ($this->_tables_filters as $key => $filter) {

            if (in_array($filter["sql"], $sql) && in_array($filter["param"], $params) && in_array($filter["type"], $types)) {
                //remove this element from the array
                unset($this->_tables_filters[$key]);
            } else {
                $sql[]    = $filter["sql"];
                $params[] = $filter["param"];
                $types[]  = $filter["type"];
            }

        }

    }

    /**
     * This function is called by the create_report_config() to write the apperance and wizard settings
     * @param type $fp : refrence to the config file
     */
    private function write_wizard_settings($fp)
    {
        // var_dump($this->_tables_parameters_mapping);
        fwrite($fp, '//  wizard settings' . PHP_EOL);
        fwrite($fp, '$language = "' . $this->_language . '";' . PHP_EOL);
        fwrite($fp, '$db_extension = "' . strtolower($this->_db_extension) . '";' . PHP_EOL);
        fwrite($fp, '$datasource = "' . $this->_datasource . '";' . PHP_EOL);
        fwrite($fp, '$tables_parameters = ' . $this->serialize_array($this->_tables_parameters) . ';' . PHP_EOL);
        fwrite($fp, '$tables_parameters_mapping = ' . $this->serialize_array($this->_tables_parameters_mapping) . ';' . PHP_EOL);
        fwrite($fp, '$report_relation = "' . $this->_report_relation . '";' . PHP_EOL);

        if ($this->_datasource == "sql") {
            fwrite($fp, '$sql = "' . str_replace('"', "'", $this->_sql) . '";' . PHP_EOL);
            fwrite($fp, '$table = array();' . PHP_EOL);
            fwrite($fp, '$tables_filters = array();' . PHP_EOL);
            fwrite($fp, '$relationships = array();' . PHP_EOL);
        } else {
            fwrite($fp, '$sql = "";' . PHP_EOL);
            fwrite($fp, '$table = ' . $this->serialize_array($this->_table) . ';' . PHP_EOL);
            fwrite($fp, '$tables_filters = ' . $this->serialize_array($this->_tables_filters) . ';' . PHP_EOL);
            fwrite($fp, '$relationships = ' . $this->serialize_array($this->_relationships) . ';' . PHP_EOL);

            fwrite($fp, '$affected_column = "' . $this->statestical_affected_column . '";' . PHP_EOL);
            fwrite($fp, '$function = "' . $this->statestical_function . '";' . PHP_EOL);
            fwrite($fp, '$groupby_column = "' . $this->statestical__groupby_column . '";' . PHP_EOL);
        }

        fwrite($fp, '$labels = ' . $this->serialize_array($this->_labels) . ';' . PHP_EOL);
        fwrite($fp, '$cells = ' . $this->serialize_array($this->_cells) . ';' . PHP_EOL);
        fwrite($fp, '$field_settings = ' . $this->serialize_array($this->_field_settings) . ';' . PHP_EOL);
        fwrite($fp, '$conditional_formating = ' . $this->serialize_array($this->_conditional_formating) . ';' . PHP_EOL);
        fwrite($fp, '$fields = ' . $this->serialize_array($this->_fields) . ';' . PHP_EOL);
        fwrite($fp, '$fields2 = ' . $this->serialize_array($this->_fields) . ';' . PHP_EOL);
        fwrite($fp, '$group_by = ' . $this->serialize_array($this->_group_by) . ';' . PHP_EOL);
        fwrite($fp, '$sort_by = ' . $this->serialize_array($this->_sort_by) . ';' . PHP_EOL);
        // apperance and security
        fwrite($fp, '$records_per_page = "' . $this->_records_per_page . '";' . PHP_EOL);
        fwrite($fp, '$layout = "' . $this->_layout . '";' . PHP_EOL);
        fwrite($fp, '$style_name = "' . $this->_style_name . '";' . PHP_EOL);
        fwrite($fp, '$title = "' . $this->_title . '";' . PHP_EOL);
        fwrite($fp, '$header = "' . $this->_header . '";' . PHP_EOL);
        fwrite($fp, '$footer = "' . $this->_footer . '";' . PHP_EOL);

        fwrite($fp, '$is_mobile = "' . $this->_is_mobile . '";' . PHP_EOL);
        fwrite($fp, '$sub_totals_enabled = "' . $this->_sub_totals_enabled . '";' . PHP_EOL);
        fwrite($fp, '$filters_grouping = "' . $this->_filters_grouping . '";' . PHP_EOL);
        fwrite($fp, '$sub_totals = ' . $this->serialize_array($this->_sub_totals) . ';' . PHP_EOL);
    }

    /**
     * This function converts the cells array from the session formats to the report config formats
     * @param type $cells is the cells array as stored in the session
     * @return type the $cells array as it should be stored in the config
     */
    private function process_cells_settings($cells)
    {

        $arr = array();

        if (!is_array($cells) || empty($cells)) {
            return array();
        }

        foreach ($cells as $cell) {

            foreach ($cell as $k => $v) {

                if ($k == "column") {

                    if ($cell["cellType"] == "qr") {
                        $arr[$v] = $cell["cellType"] . "-" . $cell["qrWidth"];
                    }else if($cell["cellType"] == "barcode"){
                        $arr[$v] = $cell["cellType"] . "-" . $cell["barcode"];
                    }else if (strstr($cell["cellType"], "append")) {
                        $arr[$v] = $cell["cellType"] . "-" . $cell["appendedText"];
                    } else {
                        $arr[$v] = $cell["cellType"];
                    }

                }

            }

        }

        return $arr;
    }

    /**
     * This function is called if aggregation functions are used . it affects the fields, sort by and group by arrays
     */
    protected function handle_aggregation_functions()
    {

        if (isset($this->statestical_affected_column) && $this->statestical_affected_column != "") {

            $new_flds = array();

            foreach ($this->_fields as $f) {

// if function is not already set
                if ($f === $this->statestical_affected_column && !strstr($f, $this->statestical_function)) {
                    $new_flds[] = $this->statestical_function . "(`$f`)";
                } else {
                    $new_flds[] = $f;
                }

            }

            $this->_fields = $new_flds;

            $new_group = array();
            foreach ($this->_group_by as $g) {
                if ($g !== $this->statestical_affected_column) {
                    $new_group[] = $g;
                }

            }

            $this->_group_by = $new_group;

            $new_sort = array();
            foreach ($this->_sort_by as $arr) {
                if ($arr[0] !== $this->statestical_affected_column) {
                    $new_sort[] = $arr;
                }

            }

            $this->_sort_by = $new_sort;
        }

    }

    /**
     * This function create a way to write array variables in the cnfig file of reports
     * @param teh array in a session variable
     * @return type string to be written in the config file
     */
    private function serialize_array($arr)
    {

        $str = "array(";

        foreach ($arr as $k => $v) {

//case two dimensional array where 2nd level is not associative

//case second dimension where 2nd level is associative
            if (is_array($v)) {
                $str .= PHP_EOL . '      "' . $k . '" => ' . $this->serialize_array($v) . ",";
            }

            //case one dimensional associative array
            else {
                $str .= PHP_EOL . '"' . $k . '" => "' . str_replace('"', "'", $v) . '",';
            }

        }

        $str .= ")";
        $str = str_replace(",)", ")", $str);

        return $str;
    }

    /**
     *
     * @return typecheck if an array is associative or not
     */
    private function is_associative_array()
    {
        return count(array_filter(array_keys($array), 'is_string')) > 0;
    }

    /**
     * This is the template method that creates the report if called by an object of a subclass
     */
    final public function run($srm_dashboard)
    {

        if (online_demo_mode === 1) {

            if ($_SESSION[Session_wizard_key]["edit_mode"]) {
                $_SESSION[Session_wizard_key]["redirect"] = $this->_report_path . "/" . "redirect_add.php";
                $_SESSION["report_id"]                    = $_SESSION[Session_wizard_key]["report_id"];
                return true;

            } else {
                $_SESSION[Session_wizard_key]["redirect"] = $this->_report_path . "/" . "redirect_add.php";
                $_SESSION["report_id"]                    = $srm_dashboard->get_last_report_id()[0]["id"];
                return true;

            }

        }

        $this->validate_request($srm_dashboard);

//done
        if ($_SESSION[Session_wizard_key]["edit_mode"] && isset($_SESSION[Session_wizard_key]["report_id"])) {
            $existed_report_name = $srm_dashboard->get_existed_name($_SESSION[Session_wizard_key]["report_id"]);
            $this->_report_id    = intval($_SESSION[Session_wizard_key]["report_id"]);
            $this->dashboard_edit_report_with_permission($srm_dashboard, intval($_SESSION[Session_wizard_key]["report_id"]));
            $this->_file_name;
            $this->rename_report_dir($existed_report_name, $this->_file_name);
            // $this->deleteDir($this->_reports_directory . str_replace(" ", "", trim($existed_report_name)));
        } else {
            $this->dashboard_save_report_with_permission($srm_dashboard);
            $this->RecursiveMkdir($this->_report_path); //done
            $this->create_report_structure();
        }

//done
        if ($this->_datasource == "table" && $this->statestical_affected_column != "") {
            $this->handle_aggregation_functions();
        }

//done
        if ($this->_datasource == "table" && $this->_tables_filters != array()) {
            $this->process_filter_array();
        }

        $this->create_init_file(); //done
        $this->create_report_config();

//done

//Save resource
        if ($_SESSION[Session_wizard_key]["edit_mode"] && isset($_SESSION[Session_wizard_key]["report_id"])) {

            $_SESSION[Session_wizard_key]["redirect"] = $this->_report_path . "/" . "redirect_edit.php";

        } else {
            $_SESSION[Session_wizard_key]["redirect"] = $this->_report_path . "/" . "redirect_add.php";

        }
        unset($_SESSION[Session_report_Parameters_Mapping]);
        return true;
    }

    public function set_file_name($_file_name)
    {
        $_file_name         = trim($_file_name);
        $_file_name         = str_replace(" ", "", $_file_name);
        $this->_file_name   = str_replace(".php", "", $_file_name);
        $this->_report_path = $this->_reports_directory . $this->_file_name;
    }

    public function set_filters_grouping($_filters_grouping)
    {
        $this->_filters_grouping = $_filters_grouping;
    }

    public function set_sub_totals($_sub_totals)
    {
        $this->_sub_totals = $_sub_totals;
    }

    public function set_security_rules($access_rule = private_report, $access_groups = array())
    {
        if ($access_rule === public_report) {
            $this->_access_rule   = public_report;
            $this->_access_groups = array();
        } else {
            $this->_access_rule   = private_report;
            $this->_access_groups = $access_groups;
        }

    }

    public function set_sub_totals_enabled($_sub_totals_enabled)
    {
        $this->_sub_totals_enabled = $_sub_totals_enabled;
    }

    public function set_category($_category_id)
    {
        $this->_category_id = intval($_category_id);
    }

    public function set_date_created($_date_created)
    {
        $this->_date_created = $_date_created;
    }

    public function set_maintainance_email($_maintainance_email)
    {
        $this->_maintainance_email = $_maintainance_email;
    }

    public function set_images_path($_images_path)
    {
        $this->_images_path = $_images_path;
    }

    public function set_headers_output_escaping($_headers_output_escaping)
    {
        $this->_headers_output_escaping = $_headers_output_escaping;
    }

    public function set_default_page_size($_default_page_size)
    {
        $this->_default_page_size = $_default_page_size;
    }

    public function set_output_escaping($_output_escaping)
    {
        $this->_output_escaping = $_output_escaping;
    }

    public function set_thumnail_max_width($_thumnail_max_width)
    {
        $this->_thumnail_max_width = $_thumnail_max_width;
    }

    public function set_thumnail_max_height($_thumnail_max_height)
    {
        $this->_thumnail_max_height = $_thumnail_max_height;
    }

    public function set_show_real_size_image($_show_real_size_image)
    {
        $this->_show_real_size_image = $_show_real_size_image;
    }

    public function set_show_realsize_in_popup($_show_realsize_in_popup)
    {
        $this->_show_realsize_in_popup = $_show_realsize_in_popup;
    }

    public function set_chkSearch($_chkSearch)
    {
        $this->_chkSearch = $_chkSearch;
    }

    public function set_language($_language)
    {
        $this->_language = $_language;
    }

    public function set_db_extension($_db_extension)
    {
        $this->_db_extension = $_db_extension;
    }

    public function set_datasource($_datasource)
    {
        $this->_datasource = $_datasource;
    }

    public function set_table($_table)
    {
        $this->_table = $_table;
    }

    public function set_tables_filters($_tables_filters)
    {
        $this->_tables_filters = $_tables_filters;
    }

    public function set_tables_parameters($_tables_parameters)
    {
        $this->_tables_parameters = $_tables_parameters;
    }

    public function set_tables_parameters_mapping($_tables_parameters_mapping)
    {
        $this->_tables_parameters_mapping = $_tables_parameters_mapping;
    }

    public function set_fields($_fields)
    {
        $this->_fields = $_fields;
    }

    public function set_relationships($_relationships)
    {
        $this->_relationships = $_relationships;
    }

        public function set_report_relationship($_report_relation)
    {
        $this->_report_relation = $_report_relation;
    }

    public function set_sql($_sql)
    {
        $this->_sql = $_sql;
    }

    public function set_fields2($_fields2)
    {
        $this->_fields2 = $_fields2;
    }

    public function set_records_per_page($_records_per_page)
    {
        if (!is_int($_records_per_page) || $_records_per_page < 1) {
            $_records_per_page = 10;
        }

        $this->_records_per_page = (int) $_records_per_page;
    }

    public function set_layout($_layout)
    {

        if (strtolower($_layout) == "alignleft" || $_layout == "AlignLeft") {
            $this->_layout = "AlignLeft";
        } elseif (strtolower($_layout) == "block" || $_layout == "Block") {
            $this->_layout = "Block";
        } elseif (strtolower($_layout) == "stepped" || $_layout == "Stepped") {
            $this->_layout = "Stepped";
        } elseif (strtolower($_layout) == "outline" || $_layout == "Outline") {
            $this->_layout = "Outline";
        }  elseif (strtolower($_layout) == "onecolumnhorizontal" || $_layout == "OneColumnHorizontal") {
            $this->_layout = "OneColumnHorizontal";
        } elseif (strtolower($_layout) == "twocolumnhorizontal" || $_layout == "TwoColumnHorizontal") {
            $this->_layout = "TwoColumnHorizontal";
        } elseif (strtolower($_layout) == "threecolumnhorizontal" || $_layout == "ThreeColumnHorizontal") {
            $this->_layout = "ThreeColumnHorizontal";
        } elseif (strtolower($_layout) == "tworecordshorizontal") {
            $this->_layout = "TwoRecordsHorizontal";
        } elseif (strtolower($_layout) == "threerecordshorizontal") {
            $this->_layout = "ThreeRecordsHorizontal";
        } elseif (strtolower($_layout) == "imagerighthorizontal") {
            $this->_layout = "ImageRightHorizontal";
        } elseif (strtolower($_layout) == "imagelefthorizontal") {
            $this->_layout = "ImageLeftHorizontal";
        } elseif (strtolower($_layout) == "mobile" || $_layout == "Mobile") {
            $this->_layout = "mobile";
        } else {
            $this->_layout = "AlignLeft";
        }

    }

    public function set_style_name($_style_name)
    {
        $all_styles = array(
            "blue",
            "grey",
            "default",
            "mobile"
        );
        if (in_array($_style_name, $all_styles)) {
            $this->_style_name = $_style_name;
        } elseif (strtolower($this->_layout) == "mobile") {
            $this->_style_name = "mobile";
        } else {
            $this->_style_name = "blue";
        }

    }

    public function set_title($_title)
    {
        $this->_title = $_title;
    }

    public function set_header($_header)
    {
        $this->_header = $_header;
    }

    public function set_footer($_footer)
    {
        $this->_footer = $_footer;
    }

    public function set_is_mobile($_is_mobile)
    {
        $this->_is_mobile = $_is_mobile;
    }

    public function set_field_settings($_field_settings)
    {
        $this->_field_settings = $_field_settings;
    }

    public function set_cells($_cells)
    {

        $this->_cells = $this->process_cells_settings($_cells);
    }

    public function set_conditional_formating($_conditional_formating)
    {
        $this->_conditional_formating = $_conditional_formating;
    }

    public function set_labels($_labels)
    {
        $this->_labels = $_labels;
    }

    public function set_group_by($_group_by)
    {
        $this->_group_by = $_group_by;
    }

    public function set_sort_by($_sort_by)
    {
        $this->_sort_by = $_sort_by;
    }

    public function set_connection_name($_connection_name)
    {
        $this->connection_name = $_connection_name;
    }

    public function set_connection_user($_db_user)
    {
        $this->connection_db_user = $_db_user;
    }

    public function set_connection_pass($_db_pass)
    {
        $this->connection_db_pass = $_db_pass;
    }

    public function set_connection_db_name($_db_name)
    {
        $this->connection_db_name = $_db_name;
    }

    public function set_connection_host($_db_host)
    {
        $this->connection_db_host = $_db_host;
    }

    public function set_Statestical_affected_column($statestical_affected_column)
    {

        $this->statestical_affected_column = $statestical_affected_column;
    }

    public function set_Statestical_function($statestical_function)
    {
        $this->statestical_function = $statestical_function;
    }

    public function set_Statestical__groupby_column($statestical__groupby_column)
    {
        $this->statestical__groupby_column = $statestical__groupby_column;
    }

    private function dashboard_save_report_with_permission($srm_dashboard)
    {

        $new_report_id = $srm_dashboard->save_new_blank_report($_SESSION[Session_report_Settings_key]["file_name"], $this->_category_id, $this->connection_name, intval($_SESSION[Session_security_key][srm_access_userid]), $this->_access_rule);
        if ($new_report_id) {
            //save permissions
            $_SESSION['report_id'] = $new_report_id;

            $this->_report_id = $new_report_id;

            if ($this->_access_rule == private_report && !empty($this->_access_groups)) {
                $permissions = $srm_dashboard->save_private_report_permissions($new_report_id, $this->_access_groups, true);
            } else {
                $permissions = true;
            }

            $isStandalone = $_SESSION[Session_report_Settings_key]["report_relationship"] === "standalone";
            $isLinked = $_SESSION[Session_report_Settings_key]["report_relationship"] === "linked";
            $isParent = $_SESSION[Session_report_Settings_key]["report_relationship"] === "parent";
            $isIntermediate = $_SESSION[Session_report_Settings_key]["report_relationship"] === "intermediate";

            $_SESSION[Session_report_Settings_key]["embed"] = true;
            
            if($isStandalone){
                $configuration_id = $srm_dashboard->save_resource_configurations(
                    $new_report_id,
                    json_encode($this->filter_session($_SESSION[Session_report_Settings_key])),
                    json_encode([]),
                    $_SESSION[Session_report_Settings_key]['report_relationship'],
                    true
                );

            }
            elseif ($isParent) {
                $configuration_id = $srm_dashboard->save_resource_configurations(
                    $new_report_id,
                    json_encode($this->filter_session($_SESSION[Session_report_Settings_key])),
                    json_encode($this->filter_session($_SESSION[Session_report_Parameters_Mapping])),
                    $_SESSION[Session_report_Settings_key]['report_relationship'],
                    true
                );

            } elseif($isLinked) {
                $configuration_id = $srm_dashboard->save_resource_configurations(
                    $new_report_id,
                    json_encode($this->filter_session($_SESSION[Session_report_Settings_key])),
                    json_encode($this->filter_session($_SESSION[Session_report_Parameters])),
                    $_SESSION[Session_report_Settings_key]['report_relationship'],
                    true
                );
            }elseif($isIntermediate){
                $intermediateParameters = [
                    "linked" => $this->filter_session($_SESSION[Session_report_Parameters]),
                    "parent" => $this->filter_session($_SESSION[Session_report_Parameters_Mapping])
                ];
                $configuration_id = $srm_dashboard->save_resource_configurations(
                    $new_report_id,
                    json_encode($this->filter_session($_SESSION[Session_report_Settings_key])),
                    json_encode($intermediateParameters),
                    $_SESSION[Session_report_Settings_key]['report_relationship'],
                    true
                );

            }

            if ($configuration_id && $permissions) {
                return array("id" => $new_report_id, "permissions" => $permissions, "configuration" => $configuration_id);
            } else {
                srm_dashboard::log("Error adding report configurations or permissions.", __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_engine", "", json_encode($_SESSION[Session_report_Settings_key]));
                throw new Exception("Error adding report configurations or permissions.", 100013);
                return false;
            }

        } else {
            srm_dashboard::log('A resource with this name already exists, please choose another name for your report', __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_engine", "", json_encode($_SESSION[Session_report_Settings_key]));
            throw new Exception("A resource with this name already exists, please choose another name for your report.", 100014);

            return false;
        }

    }

    private function dashboard_edit_report_with_permission($srm_dashboard, $report_id)
    {

        if ($srm_dashboard->edit_blank_report($report_id, $_SESSION[Session_report_Settings_key]["file_name"], $this->_category_id, $this->connection_name, intval($_SESSION[Session_security_key][srm_access_userid]), $this->_access_rule)) {
            $relation = $_SESSION[Session_report_Settings_key]["report_relationship"];
            $isStandalone = $relation === "standalone";
            $isParent = $relation === "parent";
            $isIntermediate = $relation === "intermediate";
            $isLinked = $relation === "linked";

            if($isStandalone){
                $configurations = $srm_dashboard->edit_resource_configurations(
                    $report_id,
                    json_encode($this->filter_session($_SESSION[Session_report_Settings_key])),
                    json_encode($this->filter_session([])),
                    $relation
                );

            }elseif ($isParent) {

                $configurations = $srm_dashboard->edit_resource_configurations(
                    $report_id,
                    json_encode($this->filter_session($_SESSION[Session_report_Settings_key])),
                    json_encode($this->filter_session($_SESSION[Session_report_Parameters_Mapping])),
                    $relation

                );
            } elseif($isLinked) {
                $configurations = $srm_dashboard->edit_resource_configurations(
                    $report_id,
                    json_encode($this->filter_session($_SESSION[Session_report_Settings_key])),
                    json_encode($this->filter_session($_SESSION[Session_report_Parameters])),
                    $relation

                );

            }elseif($isIntermediate) {

                $intermediateParameters = [
                    "linked" => $this->filter_session($_SESSION[Session_report_Parameters]),
                    "parent" => $this->filter_session($_SESSION[Session_report_Parameters_Mapping]),
                    $relation
                ];

                $configurations = $srm_dashboard->edit_resource_configurations(
                    $report_id,
                    json_encode($this->filter_session($_SESSION[Session_report_Settings_key])),
                    json_encode($intermediateParameters),
                    $relation
                );
            }

            $permissions = $srm_dashboard->change_private_report_permissions($report_id, $this->_access_groups);

            if ($configurations && $permissions) {
                return true;
            } else {
                srm_dashboard::log('could not edit report configurations or permissions', __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_engine", "", json_encode($_SESSION[Session_report_Settings_key]));
                throw new Exception("Couldn't edit report configurations or permissions.", 100012);
                return false;
            }

        } else {
            srm_dashboard::log('Error editing report.', __FILE__ . "  lINE NO:" . __LINE__, __METHOD__, "", log_error, "report_builder_engine", "", json_encode($_SESSION[Session_report_Settings_key]));
            throw new Exception('Error editing report.', 100011);
            return false;
        }

    }

    private function filter_session($session_array)
    {
        $new_array      = array();
        $keys_to_remove = array("host", "user", "pass", "collation", "charset", "port");

        foreach ($session_array as $key => $value) {

            if (!in_array($key, $keys_to_remove)) {
                $new_array[$key] = $value;
            }

        }

        return $new_array;
    }

    public function deleteDir($dir)
    {
        $it    = new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS);
        $files = new RecursiveIteratorIterator($it,
            RecursiveIteratorIterator::CHILD_FIRST);

        foreach ($files as $file) {

            if ($file->isDir()) {
                rmdir($file->getPathname());
            } else {
                unlink($file->getPathname());
            }

        }

        rmdir($dir);
    }

}
