<?php

    /**
     * Smart Report Engine
     * Version 2.0.0
     * Author : Webuccino
     * All copyrights are preserved to Webuccino
     * URL : https://mysqlreports.com/
     *
     */

    if (!defined("DIRECTACESS")) {
        exit("No direct script access allowed");
    }

    if (isset($calculated_columns) && is_array($calculated_columns)) {

        foreach ($calculated_columns as $key => $value) {
            $fields[]     = $key;
            $labels[$key] = $key;
            $cells[$key]  = "value";
        }

    }

    $actual_fields = array_diff($fields, $group_by);

    $actual_columns_count = count($actual_fields);

    $group_by_count  = count($group_by);
    $group_by_source = $group_by;

    $fields_source        = $fields;
    $actual_fields_source = array_values(array_diff($fields, $group_by));
?>
<!DOCTYPE HTML>

<html           <?php

               if ($language == "he" || $language == "ar") {
                   echo "dir = 'rtl'";
               }

           ?>>

<head>

  <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="../shared/Js/lightbox/css/lightbox.min.css" />
  <link rel="stylesheet" href="../shared/Js/bootstrap/css/dropdown.css" />

  <script type="text/javascript" src="../shared/Js/jquery-2.2.3.min.js"></script>
  <script type="text/javascript" src="../shared/Js/jquery-2.2.3.min.js"></script>
  <script type="text/javascript" src="../shared/Js/bootstrap/js/bootstrap.min.js"></script>
  <script type="text/javascript" src="../shared/Js/qrcode.min.js"></script>
  <script type="text/javascript" src="../shared/Js/JsBarcode.min.js"></script>


  <title><?php echo escape(strtoupper($title)) ?></title>
  <link href="<?php echo "../shared/styles/common.css"; ?>" rel="stylesheet" type="text/css" />
  <link href="<?php echo "../shared/styles/" . $style_name . ".css"; ?>" rel="stylesheet" type="text/css" />
  <?php

      if ($_print_option != 0) {
          echo "<link href='../shared/styles/print.css'  rel='stylesheet' type='text/css' />";
      }

  ?>


</head>



<body class="MainPage">
  <?php
      require_once 'menu.php';
      echo ' <div class="container" ';
      echo_width($_print_option);
      echo ">";
  ?>
      <div  class="logo-img" style="display:none">
        <div style="float: right;">
          <?php

          if (get_settings_value('enable_qr') == '1'): ?>
          <div class="qrcode-header"  style="width: 100px;height:100px;margin-bottom:10px"></div>

          <?php else: ?>
          <div  style="width: 100px;height:100px"></div>

          <?php endif; ?>
          <div style="font-size:small;margin-left: -7px;" class="created-at"><?php echo(new DateTime())->format('Y-m-d H:i:s') ?></div>
        </div>

        <div style="display:flex" >

          <div class="logo-container" style="margin-top:25px;text-align:left">
            <?php
            if (is_null(get_settings_value('system_logo'))): ?>
            <img src="<?php echo get_asset_native('dist/images/srm-logo.jpg') ?>" alt="company-name" />
            <?php else: ?>
            <img src="<?php echo get_system_logo() ?>" alt="company-name" />
            <?php endif; ?>
            <div class="Title" style="margin-bottom: 0.3rem;"><?php echo "<b>$title</b>"; ?></div>
          </div>

          <div class="right-header"  style="margin-top:25px;">
            <div class="org-info">
                <div class="organization-name fw-bold">
                    <?php echo get_organization_native() ?>
                </div>
                <?php

                if (!is_null(get_organization_details_native())): ?>
                <div class="organization-contact">
                    <?php echo nl2br(get_organization_details_native()) ?>
                </div>
                <?php endif; ?>
            </div>
          </div>

      </div>
      <hr class="thick-divider no-print" />
      <hr class="thin-divider no-print" />
      </div>

      <?php
          echo '<table border="0"';
          echo_width($_print_option);
          echo ' align="center" cellpadding="2" cellspacing="0" class="MainTable">';
          require_once 'actions.php';
          require_once 'header.php';
          require_once "../shared/views/layout_views/$layout.php";
          require_once "pagger.php";

          echo "</table>";
          echo "</div>";

          if ($_print_option == 3 || $_print_option == 2 || $_print_option == 1) {
          ?>

  <script>
    window.print();
  </script>

  <?php
      }

  ?>

  <!-- ************************* End Of Show print Dialog ********************* !-->
  <script type="text/javascript" src="../shared/Js/lightbox/js/lightbox.min.js"></script>
  <script>
  let zoom = (window.outerWidth / window.innerWidth).toFixed(2) * 100;
  if (zoom > 75)
    document.body.style.zoom = "80%";
  else
    document.body.style.zoom = "75%";
  </script>

<script>
$(document).ready(function() {

    <?php
    if ($_CLEANED['token']): ?>

    if (window.top === window.self) {

        document.open();

        document.write(

            '<!doctype html><html><head><meta charset="utf-8"><title>403 Forbidden</title>' +

            '<meta name="viewport" content="width=device-width, initial-scale=1">' +

            '<style>body{font-family:system-ui,-apple-system,Segoe UI,Roboto,sans-serif;margin:0;padding:2rem;color:#222}' +

            'h1{margin:.2rem 0 .6rem;font-size:1.5rem}p{margin:0;line-height:1.5}</style></head>' +

            '<body><h1>403 Forbidden</h1><p>Direct access is denied!</p></body></html>'

        );

        document.close();

        throw new Error();

    } else {

        // if allowed, reveal content immediately

        document.addEventListener("DOMContentLoaded", function () {

            var el = document.getElemengtById('content');

            if (el) el.style.display = 'block';

        });

    }

    <?php endif?>


    let image = $(".logo-img img")[1] || $(".logo-img img")[0] || $(".logo img")[0]
    image.src = window.parent.$('.branding-logo img')[0] !== undefined ? window.parent.$('.branding-logo img')[0].src : window.parent.$(".logo img")[0].src;
    $(".created-at")[0].innerHTML = window.parent.$('.created-at')[0].innerHTML;

    $(".qrcode-header img")[0].src = window.parent.$('.qrcode img')[0].src;
    $.fn.stars = function() {
        return $(this).each(function() {
        var val = parseFloat($(this).html());
        var size = Math.max(0, (Math.min(5, val))) * 16;
        var $span = $('<span />').width(size);
        $(this).html($span);
        });
    }


    var datasource =                                         <?php echo "'" . escape($datasource) . "';"; ?>
    //    if (datasource == 'sql') {
    //        $("#txtordnarySearch").css('visibility', 'hidden');
    //        $(".srch-btn").css('visibility', 'hidden');
    //        $("#search_advanced").css('visibility', 'hidden');

    //    }
    $('span.stars').stars();

    const urlParams = new URLSearchParams(window.location.search);

    const searchQuery = urlParams.get('print');


    window.addEventListener('load', runEqualizeHeights);

    window.addEventListener('load', equalizeTableHeights);

});


<?php

if (get_settings_value('enable_qr') == '1'): ?>
    try{
    document.querySelectorAll(".qrcode-header").forEach(element => {
        new QRCode(element, {
            text:"<?php echo get_cur_url() ?>",
            width:100,
            height:100,
            colorDark : "#000000",
            colorLight : "#ffffff",
            correctLevel : QRCode.CorrectLevel.H

        });
    });
    }catch(e){

    }
<?php endif; ?>

    document.querySelectorAll('div.barcode').forEach(div => {
        const value = div.getAttribute('jsbarcode-value') || '';
        let format = div.getAttribute('jsbarcode-format') || 'CODE128';


        const barWidth = parseFloat(div.getAttribute('jsbarcode-barwidth')) || 2;
        const barHeight = parseFloat(div.getAttribute('jsbarcode-barheight')) || 60;
        const textAlign = div.getAttribute('jsbarcode-textalign') || 'center';
        const fontSize = div.getAttribute('jsbarcode-fontsize') || 20;
        const fontOptions = div.getAttribute('jsbarcode-fontoptions') || 'bold';
        const displayValue = div.getAttribute('jsbarcode-displayvalue') !== '0';

        div.innerHTML = '';

        const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");

        div.appendChild(svg);

        try{
        JsBarcode(svg, value, {
            format: format,
            width: barWidth,
            height: barHeight,
            textAlign: textAlign,
            fontOptions: fontOptions,
            fontSize: fontSize,
            displayValue: displayValue,
            background: "#ffffff",
            lineColor: "#000000"
        });
        }catch(e){
            div.innerHTML = value;
        }
    });


function equalizeTableHeights() {
    const rows = document.querySelectorAll('.equal-height-row');
    rows.forEach(row => {
        const cells = row.querySelectorAll('.equal-height-cell');
        let maxHeight = 0;

        cells.forEach(cell => {
            cell.style.height = 'auto';
            maxHeight = Math.max(maxHeight, cell.offsetHeight);
        });

        cells.forEach(cell => {
            cell.style.height = maxHeight + 'px';
        });
    });
}


function equalizeTableHeightsTwoColumn() {

    const rows = document.querySelectorAll('tr.equal-height-row-2col');

    if (rows.length === 0) {
        const cells = document.querySelectorAll('.equal-height-cell-2col');

        for (let i = 0; i < cells.length; i += 2) {
            if (cells[i + 1]) {
                equalizeRow([cells[i], cells[i + 1]]);
            }
        }
        return;
    }

    rows.forEach((row, index) => {
        const cells = row.querySelectorAll('.equal-height-cell-2col');
        equalizeRow(cells);
    });
}

function equalizeRow(cells) {
    if (cells.length < 2) return;

    Array.from(cells).forEach(cell => {
        cell.style.height = 'auto';
        cell.style.minHeight = 'auto';
        const table = cell.querySelector('table');
        if (table) {
            table.style.height = 'auto';
            table.style.minHeight = 'auto';
        }
    });

    cells[0].offsetHeight;

    let maxHeight = 0;
    Array.from(cells).forEach(cell => {
        const height = cell.offsetHeight;
        maxHeight = Math.max(maxHeight, height);
    });


    if (maxHeight > 0) {
        Array.from(cells).forEach(cell => {
            cell.style.height = maxHeight + 'px';
            cell.style.minHeight = maxHeight + 'px';

            const table = cell.querySelector('table');
            if (table) {
                table.style.height = '100%';
                table.style.minHeight = maxHeight + 'px';
            }
        });
    }
}

function runEqualizeHeights() {
    setTimeout(equalizeTableHeightsTwoColumn, 100);
    setTimeout(equalizeTableHeightsTwoColumn, 500);
    setTimeout(equalizeTableHeightsTwoColumn, 1000);

    setTimeout(equalizeTableHeights, 100);
    setTimeout(equalizeTableHeights, 500);
    setTimeout(equalizeTableHeights, 1000);
}

if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', runEqualizeHeights);
} else {
    runEqualizeHeights();
}


let resizeTimer;
window.addEventListener('resize', function() {
    clearTimeout(resizeTimer);
    resizeTimer = setTimeout(equalizeTableHeightsTwoColumn, 250);
});

window.fixTableHeights = function() {
    setTimeout(equalizeTableHeightsTwoColumn, 100);
};

let attempts = 0;
const maxAttempts = 5;
const fallbackInterval = setInterval(function() {
    attempts++;
    equalizeTableHeightsTwoColumn();
    if (attempts >= maxAttempts) {
        clearInterval(fallbackInterval);
    }
}, 2000);


</script>

</body>

</html>