<?php
/**
 * Smart Report Maker
 * Version 9.0.0
 * Author : Webuccino 
 * All copyrights are preserved to Webuccino
 * URL : http://mysqlreports.com/
 *
 */
if (! defined ( "DIRECTACESS" ))
	exit ( "No direct script access allowed" );

require_once 'MysqliHandler.php';
require_once 'PDOHandler.php';
class DatabaseHandler {
	public $link;
	public $used_extension; // this value will be used in the get_used_extension function
	public $extension = '';
	public $debug = false;
	public function __construct($host, $user, $pass, $db = '', $allow_debug = false, $extension = '') {
		$this->debug = $allow_debug;
		$extensions = array (
				"mysqli",
				"pdo" 
		);
		if (in_array ( strtolower ( $extension ), $extensions ))
			$this->extension = strtolower ( $extension );
		else
			$this->extension = "";
		
		$this->extension = strtolower ( $extension );
		if (extension_loaded ( 'pdo' )) {
			$this->used_extension = "pdo";
			$this->link = new PDOHandler ( $host, $user, $pass, $db, $this->debug );
		} elseif (extension_loaded ( 'mysqli' ) && function_exists ( 'mysqli_stmt_get_result' )) {
			$this->used_extension = "mysqli";
			$this->link = new MysqliHandler ( $host, $user, $pass, $this->debug, $db );
		} else {
			die ( "No Db drive is recognized" );
		}
	}
	public function get_used_extension() {
		return $this->used_extension;
	}
	
	// this function make query to fetch data from database ( Like using SELECT & SHOW ), this function return array and not handler
	public function query($sqlStatement, $keyType = "NUM", $params = array(), $paramsType = '',$dashboard = Null) // $keyType = ASSOC, NUM, BOTH
{ 
		
            if ($this->used_extension == "pdo") {
           
			return $this->link->query ( $sqlStatement, $keyType, $params,$dashboard ); // pdo
		} else {
			$edited_params = array ();
			if ($paramsType !== '')
				$edited_params = array_merge ( array (
						$paramsType 
				), $params );
			return $this->link->query ( $sqlStatement, $keyType, $params ); // mysqli
		}
	}
	
	// sanitize string
	public function sanitize_values($string) {
		return $this->link->sanitize_values ( $string );
	}
	
	// sanitize array
	public function sanitize_array($array) {
		$clean = array ();
		foreach ( $array as $key => $value ) {
			if (is_array ( $value ))
				$clean [] = $this->sanitize_array ( $value );
			else
				$clean [] = $this->sanitize_values ( $value );
		}
		return $clean;
	}
	
	// this function to check if connection failed or succeeded
	public function is_connection_failed() // if connection failed return true
{
		return $this->link->is_connection_failed ();
	}
	
	// this function return number of rows for current query
	public function get_num_rows() {
		return $this->link->get_num_rows ();
	}
	
	// this function return database handler type
	public function get_db_handler_type() {
		return $this->link->get_db_handler_type ();
	}
	
	// this function for close connection
	public function close_connection() {
		$this->link->close_connection ();
	}
	public function available_extensions() {
		$available_extensions = array ();
                      if (extension_loaded ( 'pdo' ))
			$available_extensions [] = 'PDO';
		if (extension_loaded ( 'mysqli' ) && function_exists ( 'mysqli_stmt_get_result' ))
			$available_extensions [] = 'Mysqli';
		
			
		return $available_extensions;
	}
        
        public function command($sqlStatement,  $params = array(), $paramsType = '',$keyType = "NUM",$dashboard = Null) // $keyType = ASSOC, NUM, BOTH
{ 
		
            if ($this->used_extension == "pdo") {
			
                return $this->link->command ( $sqlStatement, $keyType, $params,$dashboard ); // pdo
                        
		} else {
                    
			$edited_params = array ();
			if ($paramsType !== '')
				$edited_params = array_merge ( array (
						$paramsType 
				), $params );
			return $this->link->command ( $sqlStatement, $edited_params ); // mysqli
		}
	}
	
	public function do_transaction($sqlStatement_array){
            return $this->link->do_transaction($sqlStatement_array);
        }
}
?>