<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>SRM Public Embed</title>
  <!--
    Smart Report Maker - PUBLIC Embed (static HTML)
    --------------------------------------------------------------
    • This embed method can only be used for public resources.
    • Configure everything directly on the <iframe> (src, width, height).   
    -->
</head>

<body>

  <!-- ============================================================
       HTML before embed code
       ------------------------------------------------------------
       This HTML block will be rendered BEFORE the embedded SRM
       resource. Use it for notices, login links, or other UI.
       (Replace or remove this block as needed.)
  =============================================================== -->

  <?php echo getEmbedPreferencesValue('custom_html_before_embed')?>


  <!-- ============================================================
       EMBED (configure everything in the iframe tag below)
       - Set src to your PUBLIC SRM resource URL.
       - Adjust width/height inline.
       - Keep allowfullscreen/loading attributes as desired.
  =============================================================== -->
  <div>
    <iframe src="<?php echo $srm_resource_url;?>"
      style="width: <?php echo (getEmbedPreferencesValue('iframe_width') ?? '100') . '%' ?>; height: <?php echo (getEmbedPreferencesValue('iframe_height') ?? '600') . 'px' ?>; border: 0;"
      title="Smart Report Maker Resource" loading="lazy" allowfullscreen></iframe>
  </div>

  <!-- ============================================================
       HTML after embed code
       ------------------------------------------------------------
       This HTML block will be rendered AFTER the embedded SRM
       resource. Use it for help text, footers, or links.
       (Replace or remove this block as needed.)
  =============================================================== -->

  <?php echo getEmbedPreferencesValue('custom_html_after_embed')?>

</body>

</html>