<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Smart Report Maker</title>

    <link rel="stylesheet" href="{{ public_path('dist/css/all.min.css')}}">
    <link rel="stylesheet" href="{{ public_path('dist/css/adminlte.min.css')}}">
    <link rel="stylesheet" href="{{ public_path('dist/css/style.css')}}">
    <link rel="stylesheet" href="{{ public_path('dist/css/pivot-table.css')}}" />
    @php
        $defaultPivotTableTheme = getSettingsValue('default_pivot_table_theme');
    @endphp
    <link rel="stylesheet" href="{{ public_path("dist/css/themes/$defaultPivotTableTheme/bootstrap.css")}}" />
    <style>
        * {
            font-size: 12px
        }

        table,
        table thead,
        table tbody,
        table tfoot,
        table th,
        table td {
            border: 3px solid #bcbbbb !important;
            vertical-align: middle;
        }

        h6 {
            padding: 5px !important;
            margin: 0px !important;
            line-height: 1.5 !important;
        }

        .organization-name {
            font-family: 'street_corner';
            font-weight: 100;
            font-size: 14px;
            color: #801818;
        }

        .organization-contact {
            font-family: 'street_corner';
            font-size: 12px;
            font-weight: 100;
            color: #3D4652;
            margin-top: 5px;

        }

        .date-title {
            font-family: 'street_corner';
            font-weight: 100;
            font-style: oblique;
            font-size: 14px;
            color: #3D4652;

        }

        .thick-divider {
            border-width: 3px;
            margin-bottom: 0px;
            padding: 2px;
            border-color: #3D4652;
        }

        .thin-divider {
            border-width: 1px;
            margin-top: 0px;
            padding: 0px;
            border-color: #3D4652;
        }

        .table-preview .table-light {
            background-color: #f8f9fa;
            --bs-table-color: #000;
            --bs-table-bg: #f8f9fa;
            --bs-table-border-color: rgb(198.4, 199.2, 200);
            --bs-table-striped-bg: rgb(235.6, 236.55, 237.5);
            --bs-table-striped-color: #000;
            --bs-table-active-bg: rgb(223.2, 224.1, 225);
            --bs-table-active-color: #000;
            --bs-table-hover-bg: rgb(229.4, 230.325, 231.25);
            --bs-table-hover-color: #000;
            color: var(--bs-table-color);
            border-color: var(--bs-table-border-color);
        }
    </style>

<body>

    <header class="mb-3">
        <div class="row">
            <div class="text-right float-left">
                <div class="branding-logo">
                    @if(is_null(getSettingsValue('system_logo')))
                    <img src="{{ public_path('dist/images/srm-logo.jpg') }}" alt="Logo" class="brand-image" />
                    @else
                    <img src="{{ getSystemLogo(true) }}" alt="Logo" class="brand-image w-100" />
                    @endif
                </div>
                <div class="float-left date-title mt-5 ">
                    {{ $pivotTable['options']['pivot_table_title'] }}
                </div>
            </div>

            <div class="organization float-right">
                <div class="organization-name">
                    {{ get_organization() }}
                </div>
                @if(!is_null(get_organization_details()))
                <div class="organization-contact">
                    {!! nl2br(get_organization_details()->contact_info)!!}
                </div>

                @endif
                <div class="date-title mt-5 ">
                    Date: {{ \Carbon\Carbon::now()->format('d-m-Y H:i:s') }}
                </div>

            </div>

            <div style="clear:both"></div>
        </div>
        <div class="row">
            <hr class="thick-divider" />
            <hr class="thin-divider" />
        </div>
    </header>

    <div class="table-preview">
        <div id="table-container">
            <div>

                <table class="table table-bordered text-center">
                    @if($pivotTable['options']['complex'])

                    @php
                    $arrayKeys = array_keys($pivotTable['data'][0]);
                    @endphp

                    <thead>
                        <tr>
                            <th class="table-light">
                                <h6></h6>
                            </th>
                            @php
                            $lastLevelColumns = 0;
                            foreach ($pivotTable['data'][0] as $key => $item) {
                            if (is_array($item)) {
                            $lastLevelColumns += count($item);
                            }else if($key == 'Null'){
                            $lastLevelColumns++;
                            }
                            }
                            @endphp
                            <th colspan="{{ $lastLevelColumns + 1 }}" class="table-light" style="{{ " text-align:" .
                                $request->alignment }}">
                                <h6>{{ $pivotTable['options']['value'] }}</h6>
                            </th>
                        </tr>
                        <tr class="table-light" style="{{ " text-align:" . $request->alignment }}">
                            @foreach($pivotTable['data'][0] as $key => $item)
                            @if(is_array($item))
                            <th class="table-light" colspan="{{ count($item) }}">
                                <h6>{{ $key }}</h6>
                            </th>
                            @else
                            <th rowspan="2" class="table-light">
                                <h6>{{ $key }}</h6>
                            </th>
                            @endif
                            @endforeach

                        </tr>
                        <tr class="table-light" style="{{ " text-align:" . $request->alignment }}">
                            @foreach($pivotTable['data'][0] as $key => $item)
                            @if(is_array($item))
                            @foreach($item as $key => $item)
                            <th class="table-light">
                                <h6>{{ $key }}</h6>
                            </th>
                            @endforeach
                            @endif
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($pivotTable['data'] as $key => $item)
                        @if($key != array_key_last($pivotTable['data']))
                        <tr class="table-light">
                            @foreach($item as $key => $item)
                            @if(is_array($item))
                            @foreach($item as $key => $item)
                            <td class="text-default" style="{{ " text-align:" . $request->alignment }}">
                                <h6>{{ $item }}</h6>
                            </td>
                            @endforeach
                            @else
                            <td class="{{ $loop->first ? 'table-light' : '' }}" style="{{ " text-align:" . $request->
                                alignment }}">
                                <h6 class="{{ $loop->last ? 'text-primary' : '' }}">{{ $item }}</h6>
                            </td>
                            @endif
                            @endforeach
                        </tr>
                        @endif
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            @foreach($pivotTable['data'][array_key_last($pivotTable['data'])] as $key => $item)
                            @if(is_array($item))
                            @foreach($item as $key => $item)
                            <td class="table-default" style="{{ " text-align:" . $request->alignment }}">
                                <h6 class="table-default text-primary">{{ $item }}</h6>
                            </td>
                            @endforeach
                            @else
                            <td class="{{ $loop->first ? 'table-light' : '' }}" style="{{ " text-align:" . $request->
                                alignment }}">
                                <h6 class=" {{ $loop->last ? 'table-default text-primary' : '' }}">{{ $item }}</h6>
                            </td>
                            @endif
                            @endforeach
                        </tr>
                    </tfoot>

                    @elseif($pivotTable['options']['row'] && $pivotTable['options']['column'])

                    @php
                    $arrayKeys = array_keys($pivotTable['data'][0]);

                    @endphp

                    <thead>
                        <tr class="table-light">
                            <th class="table-light">
                                <h6></h6>
                            </th>
                            @php
                            $lastLevelColumns = 0;
                            foreach ($pivotTable['data'][0] as $key => $item) {
                            if (is_array($item)) {
                                $lastLevelColumns += count($item);
                            }else if($key == 'Null'){
                                $lastLevelColumns++;
                            }
                            else{
                                $lastLevelColumns++;
                            }
                            }
                            @endphp
                            <th colspan="{{ $lastLevelColumns - 1}}" class="table-light" style="{{ " text-align:" .
                                $request->alignment }}">
                                <h6>{{ $pivotTable['options']['value'] }}</h6>
                            </th>
                        </tr>

                        <tr class="table-light">
                            @foreach($pivotTable['data'][0] as $key => $item)
                            <th class="table-light" style="{{ " text-align:" . $request->alignment }}">
                                <h6>{{ $key }}</h6>
                            </th>
                            @endforeach

                        </tr>
                    </thead>
                    <tbody>
                        @foreach($pivotTable['data'] as $key => $item)
                        @if($key != array_key_last($pivotTable['data']))
                        <tr class="table-light">
                            @foreach($item as $key => $item)
                            @if($loop->first)
                            <td class="table-light" style="{{ " text-align:" . $request->alignment }}">
                                <h6>{{ $item }}</h6>
                            </td>
                            @else
                            <td style="{{ " text-align:" . $request->alignment }}">
                                <h6 class="{{ $loop->last ? 'text-default text-primary' : 'text-default' }}">{{ $item }}
                                </h6>
                            </td>
                            @endif
                            @endforeach
                        </tr>
                        @endif
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            @foreach($pivotTable['data'][array_key_last($pivotTable['data'])] as $key => $item)
                            <td class="{{ $loop->first ? 'table-light' : 'table-default text-primary' }}" style="{{ "
                                text-align:" . $request->alignment }}">
                                <h6>{{ $item }}</h6>
                            </td>
                            @endforeach
                        </tr>
                    </tfoot>


                    @elseif($pivotTable['options']['row'])
                    @php
                    $arrayKeys = array_keys($pivotTable['data'][0]);

                    @endphp

                    <thead>
                        <tr class="table-light">
                            <th class="table-light" style="{{ " text-align:" . $request->alignment }}">
                                <h6>{{ $arrayKeys[0] }}</h6>
                            </th>
                            <th class="table-light" style="{{ " text-align:" . $request->alignment }}">
                                <h6>{{ $arrayKeys[1] }}</h6>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($pivotTable['data'] as $item)
                        <tr>
                            <td class="table-light" style="{{ " text-align:" . $request->alignment }}">
                                <h6>{{ $item[$arrayKeys[0]] }}</h6>
                            </td>
                            <td class="table-default" style="{{ " text-align:" . $request->alignment }}">{{
                                $item[$arrayKeys[1]] }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="grand-total">
                            <td class="table-light" style="{{ " text-align:" . $request->alignment }}">
                                <h6>{{ $pivotTable['options']['total'][$arrayKeys[0]] }}</h6>
                            </td>
                            <td class="table-default" style="{{ " text-align:" . $request->alignment }}">
                                <span class="text-primary">{{ $pivotTable['options']['total'][$arrayKeys[1]] }}</span>
                            </td>
                        </tr>
                    </tfoot>
                    @elseif($pivotTable['options']['column'])
                    @php
                    $arrayKeys = array_keys($pivotTable['data'][0]);
                    @endphp
                    <thead>
                        <tr>
                            <th class="table-light">
                                <h6></h6>
                            </th>
                            <th colspan="{{ count($pivotTable['data']) + 1 }}" class="table-light" style="{{ "
                                text-align:" . $request->alignment }}">
                                <h6>{{ $arrayKeys[0] }}</h6>
                            </th>
                        </tr>

                        <tr class="table-light">
                            <th class="table-light" style="{{ " text-align:" . $request->alignment }}">
                                <h6></h6>
                            </th>
                            @foreach($pivotTable['data'] as $item)
                            <th class="table-light" style="{{ " text-align:" . $request->alignment }}">
                                <h6>{{ $item[$arrayKeys[0]] }}</h6>
                            </th>
                            @endforeach
                            <th class="table-light" style="{{ " text-align:" . $request->alignment }}">
                                <h6>{{ $pivotTable['options']['total'][$arrayKeys[0]] }}</h6>
                            </th>



                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class="table-light" style="{{ " text-align:" . $request->alignment }}">{{ $arrayKeys[1]
                                }}</td>
                            @foreach($pivotTable['data'] as $item)
                            <td class="table-default" style="{{ " text-align:" . $request->alignment }}">{{
                                $item[$arrayKeys[1]] }}</td>
                            @endforeach
                            <td class="table-default" style="{{ " text-align:" . $request->alignment }}">
                                <span class="text-primary">{{ $pivotTable['options']['total'][$arrayKeys[1]] }}</span>
                            </td>

                        </tr>
                    </tbody>

                    @endif
                </table>
            </div>

        </div>
    </div>
</body>

</html>
