@extends('layouts.app')

@section('styles')

<style>
  div.custom-control-right {
    padding-right: 24px;
    padding-left: 0;
    margin-left: 0;
    margin-right: 0;
  }

  div.custom-control-right .custom-control-label::after {
    right: -1.5rem;
    left: auto;
  }

  div.custom-control-right .custom-control-label::before {
    right: -2.35rem;
    left: auto;
  }
</style>
@endsection


@section('content')

<div class="content-wrapper">
  <div class="content-header mx-3">
    <div class="container-fluid mb-3">
      <div class="row mb-2 mt-3">
        <div class="col-sm-8">
          <h1 class="m-0"><i class="fa fa-puzzle-piece mx-2"></i> SRM-Embed WordPress Plugin: Download & Configuration
          </h1>
        </div>
        <div class="col-sm-4">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
            <li class="breadcrumb-item active">SRM WP Plugin</li>
          </ol>
        </div>
      </div>
    </div>
    <div class="form-section alert" style="background-color: #DAE8FC">
      <div class="d-flex align-items-center mb-3">
        <i class="fas fa-info-circle text-primary mx-2"></i>
        <strong>About This Page</strong>
      </div>
      <p class="help-text">
        The SRM-Embed plugin lets you easily embed any analytic resource—whether private or public—directly into your
        WordPress website. Simply download the plugin, upload it to your WordPress site, and configure it using the
        values provided on this page.
      </p>
    </div>




    <div class="card bg-white">
      <div class="card-body">

        <table class="table" style="margin: auto;width:100% !important">
          <tbody>
            <tr style="border-style: hidden">
              <td class="text-center fw-bold" style="vertical-align: middle;">
                <div class="mr-2 d-inline">
                  @include('dashboard.embed-resource.partials._download_icon')
                </div>
                <a target="_blank" href="{{ get_asset('srm-embed.zip') }}" class="text-decoration-none" id="download-plugin-url">Download SRM-Embed wp
                  plugin & upload it to your wordpress website</a>
                <span class="tool-question mx-1 align-items-center" data-toggle="tooltip" data-placement="top" title=""
                  data-original-title="Please download the SRM-Embed plugin and upload it to your WordPress site. After installation, configure its settings using the 'SRM-Embed WP Plugin General Settings' FORM below, then create Shortcuts for the resources you want to embed through the 'SRM-Embed Plugin Embed shortcodes' form.">
                  <i class="fa-solid fa-circle-question"></i>
                </span>

              </td>

            </tr>
          </tbody>
        </table>

        <div class="row mt-4">
          <div class="col">
            <div class="header text-center mb-4">
              <h5>SRM-Embed WP Plugin General Settings</h5>
            </div>

            <div class="form-group">
              <div class="d-flex">
                <label for="embed-token-api-url">Embed Token API URL</label>
                <span class="tool-question mx-2 align-items-center" data-toggle="tooltip" data-placement="top" title=""
                  data-original-title="After installing the plugin, go to your WordPress Admin dashboard. Under SRM Embed, open the General Settings page. There you’ll find a text box labeled Embed Token API URL. Copy the URL provided here into that field.">
                  <i class="fa-solid fa-circle-question"></i>
                </span>
              </div>
              <div class="row">
                <div class="col-11">
                  <input type="text" class="form-control" id="embed-token-api-url" name="embed_token_api_url"
                    value="{{ route('get-embed-token') }}" readonly>
                </div>
                <div class="col-1">
                  <button id="copy-embed-token-api-url"
                    style="border:none; background:none; cursor:pointer; display:flex; align-items:center; gap:5px;"
                    title="Copy">
                    <i id="copy-embed-token-api-url-icon" class="fa-solid fa-copy mt-2"></i>
                  </button>
                </div>
              </div>
            </div>

            <div class="form-group">
              <div class="d-flex">
                <label for="access-key">Access Key</label>
                <span class="tool-question mx-2 align-items-center" data-toggle="tooltip" data-placement="top" title=""
                  data-original-title="After installing the plugin, go to your WordPress Admin dashboard. Under SRM Embed, open the General Settings page. There you’ll find a text box labeled Access Key. Copy the key provided here into that field. This key is required only for embedding private resources. If you want to include multiple resources, make sure to choose a key with sufficient permissions.">
                  <i class="fa-solid fa-circle-question"></i>
                </span>
              </div>

              <div class="row">
                <div class="col-11">
                  <select name="access_key" id="access-key" class="form-control">
                    <option value="">Please Select Access key</option>
                    @foreach ($accessKeys as $accessKey)
                    <option value="{{$accessKey->id}}"
                      data-access-key-by-id-url="{{route('access_control.getAccessKeyById', $accessKey->id)}}">
                      {{$accessKey->label}}</option>
                    @endforeach
                  </select>
                </div>
              </div>
              <div class="row">
                <div class="col-11">
                  <div id="access-key-confirm" class="alert bootstrap-alert-success mb-3 mt-3" role="alert"
                    style="display: none">
                    <div style="display: flex; align-items: center; justify-content: center;">
                      <div>
                        <code id="access-key-url" style="font-weight:bold;color:black;font-size:smaller;overflow-wrap: anywhere;"></code>
                      </div>
                      <button id="copy-access-key"
                        style="border:none; background:none; cursor:pointer; display:flex; align-items:center; gap:5px;margin-left:10px"
                        title="Copy">
                        <i id="copy-icon" class="fa-solid fa-copy"></i>
                      </button>
                    </div>
                  </div>

                </div>
              </div>
            </div>

          </div> {{-- end of column --}}

          <div class="col">
            <div class="header text-center mb-4">
              <h5>SRM-Embed wp Plugin Embed shortcodes</h5>
            </div>

            <div class="form-group">
              <div class="d-flex">
                <label for="resource-type">Resource Type</label>
                <span class="tool-question mx-2 align-items-center" data-toggle="tooltip" data-placement="top" title=""
                  data-original-title="Select the type of resource you’d like to embed on your WordPress site.">
                  <i class="fa-solid fa-circle-question"></i>
                </span>
              </div>
              <div class="row">
                <div class="col-11">
                  <div>
                    <select name="resource_type" id="resource-type" class="form-control">
                      <option value="">Please Select Resource Type</option>
                      <option value="dashboard" data-resource-types-url="{{route('dashboards.getAllDashboards')}}"
                        data-generate-url="{{route('embed_resource.generateUrl', 'dashboard')}}">Dashboard
                      </option>
                      @foreach ($resourceTypes as $type)
                      <option value="{{ $type['value'] }}"
                        data-resource-types-url="{{route('resources.getAllEmbedResourcesByModuleId',$type['value'])}}"
                        data-generate-url="{{route('embed_resource.generateUrl', $type['value'])}}">{{
                        $type['label'] ==
                        'Report List' ? 'Report' : $type['label'] }}</option>
                      @endforeach
                    </select>
                  </div>
                </div>
              </div>
            </div>

            <div class="form-group">
              <div class="d-flex">
                <label for="resources">Resource</label>
                <span class="tool-question mx-2 align-items-center" data-toggle="tooltip" data-placement="top" title=""
                  data-original-title="Select the resource you want to embed to display its URL.">
                  <i class="fa-solid fa-circle-question"></i>
                </span>
              </div>
              <div class="row">
                <div class="col-11">
                  <select name="resources" id="resources" class="form-control">
                    <option value="">Please Select Resource</option>
                  </select>
                </div>
              </div>
            </div>
            <div class="form-group">
              <div class="d-flex">
                <label for="resource-url">Resource URL</label>
                <span class="tool-question mx-2 align-items-center" data-toggle="tooltip" data-placement="top" title=""
                  data-original-title="After installing the plugin, go to your WordPress Admin dashboard. Under SRM Embed, open the Embed Shortcodes page. There you’ll see a text box labeled Resource URL. Copy the URL provided here into that field.">
                  <i class="fa-solid fa-circle-question"></i>
                </span>
              </div>
              <div class="row">
                <div class="col-11">
                  <input type="text" class="form-control" id="resource-url" name="resource_url" readonly
                    placeholder="Please Select Resource Type and Resource">
                </div>
                <div class="col-1">
                  <button id="copy-resource-url"
                    style="border:none; background:none; cursor:pointer; display:flex; align-items:center; gap:5px;"
                    title="Copy">
                    <i id="copy-resource-url-icon" class="fa-solid fa-copy mt-2"></i>
                  </button>
                </div>
              </div>
            </div>

          </div> {{-- end of column --}}

        </div> {{-- end of row --}}

      </div> {{-- End of card body --}}
    </div>
  </div>
</div>
@include('dashboard.general.partials._smtp-connections-confirm')

@endsection

@section('scripts')
<script src="{{ get_asset('dist/js/qrcode.min.js')}}"></script>

<script src="{{ get_asset('dist/js/embed-plugin.js') }}" defer>
</script>
<script src="{{ get_asset('dist/js/branding.js') }}" defer></script>
@endsection