
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    @if(!is_null(request()->query('expires')))
    <script>
        document.addEventListener("DOMContentLoaded", function () {

        if (window.top === window.self) {

            document.open();
            document.write(

            '<!doctype html><html><head><meta charset="utf-8"><title>403 Forbidden</title>' +

            '<meta name="viewport" content="width=device-width, initial-scale=1">' +

            '<style>body{font-family:system-ui,-apple-system,Segoe UI,Roboto,sans-serif;margin:0;padding:2rem;color:#222}' +

            'h1{margin:.2rem 0 .6rem;font-size:1.5rem}p{margin:0;line-height:1.5}</style></head>' +

            '<body><h1>403 Forbidden</h1><p>Direct access is denied!</p></body></html>'

            );

            document.close();

            throw new Error();
        } else {

            // if allowed, reveal content immediately

            document.addEventListener("DOMContentLoaded", function () {

            var el = document.getElementById('content');

            if (el) el.style.display = 'block';

            });

        }

    });
    </script>
    @endif

    <link rel="stylesheet" href="{{ get_asset('dist/css/c3.min.css'). '?v='. $srmVersion }}" />
    <link rel="stylesheet" href="{{ get_asset('dist/css/all.min.css'). '?v='. $srmVersion}}">
    <link rel="stylesheet" href="{{ get_asset('dist/css/adminlte.min.css'). '?v='. $srmVersion}}">
    <link rel="stylesheet" href="{{ get_asset('dist/css/style.css'). '?v='. $srmVersion}}" />
    <style>
        .content-wrapper>* {
            font-family: 'poppins', 'arial';
        }

        .c3-tooltip-container {
            background-color: #ffffff;
            border-radius: 0.25em;
            min-width: 180px !important;
            width: auto !important;
            max-width: 300px;
            min-width: 10%;
            padding: 20px;
            box-shadow: 0 0 1px rgba(0, 0, 0, .125), 0 1px 3px rgba(0, 0, 0, .2);
            pointer-events: auto !important;
        }

        .c3-text {
            transform: translateX(-25px) !important;
            fill: #000 !important;
        }

        .c3 .c3-grid line {
            stroke-opacity: 0.3;
            stroke-width: 1px;
        }

        .c3-xgrid,
        .c3-ygrid {
            stroke-dasharray: 0 0;
        }
    </style>

</head>

<body>
    <div class="container-fluid">

        <div class="clearfix"></div>
        @if(!is_null($chart))

        <div class="card card-primary card-outline mt-3 mx-1">
            <div class="card-header">
                <h3 class="card-title" style="color:black;font-weight:bold">
                    @if($chart->getResourceConfiguration('chart_link'))
                    <a href="{{ resourceInternalSignedUrl('charts.details',['chart' => $chart->name], is_null(request()->query('expires')))  }}"
                        style="color:black">{{
                        $chart->getResourceConfiguration('title') }}</a>
                    @else
                    {{ $chart->getResourceConfiguration('title') }}
                    @endif
                </h3>
            </div>
            <div class="card-body">
                <div id="{{ Str::of($chart->name)->kebab() }}"></div>
                <canvas id="chartCanvas" style="display: none;"></canvas>

            </div>

        </div>

        @endif


    </div>

    <script src="{{ get_asset('dist/js/moment.min.js') . '?v='. $srmVersion }}"></script>
    <script src="{{ get_asset('dist/js/d3.v5.min.js') . '?v='. $srmVersion }}"></script>
    <script src="{{ get_asset('dist/js/c3.min.js') . '?v='. $srmVersion }}"></script>
    <script src="{{ get_asset('dist/js/charts.js') . '?v='. $srmVersion }}"></script>
    @php

    $chartName = Str::of($chart->name)->kebab();
    @endphp
    <script>
        @if(!is_null($chart))
                                        {!! $chart->script !!}
                                    @endif
    </script>

</body>
</htm>