<div class="modal fade" id="{{ $id }}-modal" tabindex="-1" role="dialog" aria-labelledby="{{ $id }}-modal"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content custom-rounded-edges">
            <div class="modal-header">
                <h5 class="modal-title ml-3" id="exampleModalLongTitle">
                    <i class="fa-solid fa-barcode fa-fw mx-2"></i>
                    New Barcode Definition
                </h5>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <div class="modal-body mx-4">
                <div class="mb-3">
                    Define reusable barcode settings that can later be applied to fields in your report. Each setting includes format and appearance controls.
                </div>
                <form id="{{ $id }}-form">
                    @csrf

                    <div class="form-group">
                        <label for="label" class="mr-2 h5">Label</label>
                        <span class="tool-question mx-2" data-toggle="tooltip" data-placement="top" title=""
                            data-original-title="The name you'll use to refer to this setting in other screens.">
                            <i class="fa-solid fa-circle-question"></i>
                        </span>
                        <input type="text" class="form-control" id="label" name="label">
                    </div>

                    <div class="form-group">
                        <label for="type" class="mr-2 h5">Barcode Type</label>
                        <span class="tool-question mx-2" data-toggle="tooltip" data-placement="top" title=""
                            data-original-title="Choose the barcode format (Code128, EAN-13, etc.)">
                            <i class="fa-solid fa-circle-question"></i>
                        </span>

                        <select class="form-control" name="type" id="type">
                            <option value=""></option>
                            <option value="CODE128">CODE128</option>
                            <option value="EAN13">EAN-13</option>
                            <option value="EAN8">EAN-8</option>
                            <option value="EAN5">EAN-5</option>
                            <option value="EAN2">EAN-2</option>
                            <option value="UPC">UPC-A</option>
                            <option value="UPCE">UPC-E</option>
                            <option value="CODE39">CODE39</option>
                            <option value="ITF">ITF</option>
                            <option value="ITF14">ITF-14</option>
                            <option value="MSI">MSI</option>
                            <option value="MSI10">MSI10</option>
                            <option value="MSI11">MSI11</option>
                            <option value="MSI1010">MSI1010</option>
                            <option value="MSI1110">MSI1110</option>
                            <option value="pharmacode">Pharmacode</option>
                            <option value="codabar">Codabar</option>
                        </select>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                <label for="width" class="h5">Bar Width</label>
                                <span class="tool-question mx-2" data-toggle="tooltip" data-placement="top" title=""
                                    data-original-title="Thickness of each vertical bar line.">
                                    <i class="fa-solid fa-circle-question"></i>
                                </span>
                                <input type="number" class="form-control" id="width" name="width" value="2">
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <label for="height" class="h5">Bar Height</label>
                                <span class="tool-question mx-2" data-toggle="tooltip" data-placement="top" title=""
                                    data-original-title="Height of the barcode bars in pixels.">
                                    <i class="fa-solid fa-circle-question"></i>
                                </span>
                                <input type="number" class="form-control" id="height" name="height" value="60">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                <label for="font-size" class="h5">Font Size</label>
                                <span class="tool-question mx-2" data-toggle="tooltip" data-placement="top" title=""
                                    data-original-title="Size of the label text, in pixels.">
                                    <i class="fa-solid fa-circle-question"></i>
                                </span>
                                <input type="number" class="form-control" id="font-size" name="font_size" value="12">
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="form-group">
                                <label for="text-align" class="h5">Text Alignment</label>
                                <span class="tool-question mx-2" data-toggle="tooltip" data-placement="top" title=""
                                    data-original-title="Align the label text: left, center, or right.">
                                    <i class="fa-solid fa-circle-question"></i>
                                </span>
                                <select class="form-control" name="text_align" id="text-align">
                                    <option value="center">Center</option>
                                    <option value="left">Left</option>
                                    <option value="right">Right</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex">
                        <input type="checkbox" class="" id="display-value" name="display_value" checked=""
                            >
                        <label  for="display-value" class="mb-0 ml-2">Show Text</label>
                        <span class="tool-question mx-2 align-items-center" data-toggle="tooltip" data-placement="top"
                            title=""
                            data-original-title="Displays the data below the barcode.">
                            <i class="fa-solid fa-circle-question"></i>
                        </span>
                    </div>

                    <div class="text-center">
                        <button type="button" id="saveBtn-{{ $id }}" class="btn btn-primary mx-2 px-5 py-2 my-2">
                            Save
                        </button>
                        <button type="button" class="btn btn-light mx-2 px-5 py-2 my-2" id="cancelBtn-{{ $id }}"
                            data-dismiss="modal">
                            Cancel
                        </button>

                    </div>
                    <div class="col-md-12 mt-3">
                        <div id="{{ $id }}-confirm" class="alert bootstrap-alert-success mx-4 mb-3" role="alert"
                            style="display: none">
                        </div>
                        <div id="{{ $id }}-error" class="alert bootstrap-alert-danger mx-4 mb-3" role="alert"
                            style="display: none">
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>
</div>