@extends('layouts.app')
@section('styles')
<!-- DataTables -->
<link rel="stylesheet"
    href="{{ get_asset('dist/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet"
    href="{{ get_asset('dist/plugins/datatables-responsive/css/responsive.bootstrap4.min.css'). '?v='. $srmVersion}}">
<link rel=" stylesheet"
    href="{{ get_asset('dist/plugins/datatables-buttons/css/buttons.bootstrap4.min.css'). '?v='. $srmVersion}}">

<style>
    div.custom-control-right {
        padding-right: 24px;
        padding-left: 0;
        margin-left: 0;
        margin-right: 0;
    }

    div.custom-control-right .custom-control-label::after {
        right: -1.5rem;
        left: auto;
    }

    div.custom-control-right .custom-control-label::before {
        right: -2.35rem;
        left: auto;
    }
</style>

@endsection

@section('content')

@include('dashboard.access-keys.partials._access-key-confirmation-modal',[
'id' => 'delete-access-key',
'modal_title' => 'Delete Confirmation',
'method'=> 'DELETE'
])

@include('dashboard.access-keys.partials._access-key-confirmation-modal',[
'id' => 'revoke-access-key',
'modal_title' => 'Revoke Confirmation',
'method'=> 'DELETE'
])


<div id="view-access-key-modal-container">

</div>

@include('dashboard.access-keys.partials._access-key-add-modal',[
'id' => 'add-access-key',
])

@include('dashboard.access-keys.partials.success-modal')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header mx-3">
        <div class="container-fluid">
            <div class="row mb-2 mt-3">
                <div class="col-sm-6">
                    <h3> <i class="fa-solid fa-key fa-fw"></i>
                        Embedding Access Control</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item active">Embedding Access Control</li>
                    </ol>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->

        <div class="row alert" style="background-color: #DAE8FC">
            <span style="font-weight: bold;"> Access Keys allow you to securely embed reports, pivot tables, charts, KPIs, or dashboards from SRM into external applications or web pages.</span> Each key is either linked to a specific group's permissions or grants access to all resources. You can optionally restrict a key by IP address (typically the IP of your web application). Use these keys in your applications to authenticate and display embedded SRM content safely and efficiently.
        </div>
        <div class="row ml-5">
            <div class="form-group col-md-9">

                <input id="search-access-keys" class="form-control w-100" type="text" placeholder="Search by Label..."
                    aria-label="Search" style="height: 50px;">
                @include('dashboard.users.partials._session')

            </div>


        </div>
        <div class="form-group text-center mt-3">
            <button class="btn btn-primary px-3 py-2 my-2 my-sm-0 srm-button search-filter" type="submit"><i
                    class="fas fa-search"></i> Search</button>
            <button class="btn btn-outline-primary px-3 py-2 my-2 ml-2 my-sm-0 srm-button reset-filter" type="button"><i
                    class="fa-solid fa-eye"></i> Show All</button>
        </div>

        <button class="btn btn-primary add-barcode-button px-3 py-2 mb-3 float-right srm-button " type="button"
            data-toggle="modal" data-target="#add-access-key-modal">
            <i class="fas fa-plus"></i> Add Access Key
        </button>


        <div class="clearfix card-body mt-3">
            <table id="access-keys" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th>Label</th>
                        <th>Type</th>
                        <th>Group</th>
                        <th>Uses Count</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($accessKeys as $accessKey)

                    <tr>
                        <td style="vertical-align: middle">
                            {{ $accessKey->label }}
                        </td>
                        <td style="vertical-align: middle">{{ $accessKey->type }}</td>
                        <td style="vertical-align: middle">{{ isset($accessKey->group) ?$accessKey->group->name : '' }}</td>
                        <td style="vertical-align: middle">{{ isset($accessKey->uses_count) ?$accessKey->uses_count : '' }}</td>
                        <td>
                            <div class="dropdown">
                                <button type="button" id="ellipsisMenu1" data-toggle="dropdown" aria-haspopup="true"
                                    aria-expanded="false" style="border:none;background:none">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor"
                                        class="bi bi-three-dots-vertical" viewBox="0 0 16 16">
                                        <path
                                            d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0zm0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0z" />
                                    </svg>
                                </button>
                                <div class="dropdown-menu" aria-labelledby="ellipsisMenu">
                                    <a class="dropdown-item view-access-key" data-toggle="modal"
                                        data-url="{{ route('access_control.show',$accessKey->id) }}">View</a>
                                    <a class="dropdown-item revoke-access-key" data-toggle="modal"
                                        data-target="#revoke-access-key-modal"
                                        data-url="{{ route('access_control.revoke',$accessKey->id) }}">Revoke All Linked Tokens</a>

                                    <a class="dropdown-item delete-access-key" data-toggle="modal"
                                        data-target="#delete-access-key-modal"
                                        data-url="{{ route('access_control.destroy',$accessKey->id) }}">Delete</a>
                                </div>
                            </div>
                        </td>
                    </tr>
                    @endforeach

                </tbody>
            </table>
        </div>

    </section>

</div>
@endsection
@section('scripts')
<script src="{{ get_asset('dist/plugins/datatables/jquery.dataTables.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-responsive/js/dataTables.responsive.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/plugins/datatables-responsive/js/responsive.bootstrap4.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/dataTables.buttons.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.bootstrap4.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/plugins/jszip/jszip.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/pdfmake/pdfmake.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/pdfmake/vfs_fonts.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.html5.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.print.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-buttons/js/buttons.colVis.min.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js'). '?v='. $srmVersion}}">
</script>
<script src="{{ get_asset('dist/js/custom-datatables.js'). '?v='. $srmVersion}}"></script>
<script src="{{ get_asset('dist/js/JsBarcode.min.js'). '?v='. $srmVersion}}" defer></script>

<script>
    displayUserPanel();
</script>


<script src="{{ get_asset('dist/js/access-keys.js'). '?v='. $srmVersion }}" defer>
</script>


@endsection