$(document).ready(function () {

    $("#groups-pane").on("click", ".add-group-button", function () {
        reloadForm("add-group-form");
    });

    $(document).on("click", "#saveBtn-add-group", function () {
        let fields = ["name"];
        sendAjaxRequest("add-group-form", fields, "add-group-confirm", "add-group-error", reloadGroupTable, ["groups","add"]);
        reloadForm("add-user-form");

    });

    $("#add-group-form").on("click", "#cancelBtn-add-group", function () {
        reloadForm("add-group-form");
    });

    $("#delete-group-form").on("click", "#saveBtn-delete-user", function () {

        sendAjaxRequestWithSuccess("delete-group-form", 'delete-group-modal', reloadGroupTable, ["groups"]);

    });


    $('#groups').on('click', ".edit-group", function () {
        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            success: function (response) {
                $('#edit-group-modal-container').html(response);
                $('#edit-group-modal').modal('show');


                $("#edit-group-form").on("click", "#saveBtn-edit-group", function () {

                    let fields = ["name"];
                    sendAjaxRequest("edit-group-form", fields, "edit-group-confirm", "edit-group-error", reloadGroupTable, ["groups"]);
                });

                $("#edit-group-form").on("click", "#cancelBtn-edit-group", function () {
                    reloadForm("edit-group-form");
                });


            },
        });

    });


    $("#users-pane").on("click", ".add-user-button", function () {
        reloadForm("add-user-form");
    });

    $("#users-pane").on("click", ".activate-admin-user", function () {

        sendAjaxRequestWithSuccess("activate-admin-user-form", 'asasas', reloadUsersTable, ["users"]);

    });

    $("#users-pane").on("click", ".activate-user", function () {

        reloadForm("activate-user-form");

    });

    $("#activate-user-form").on("click", "#saveBtn-activate-user", function () {

        let fields = ["user-group"];
        sendAjaxRequest("activate-user-form", fields, "activate-user-confirm", "activate-user-error", reloadUsersTable, ["users"]);

    });

    $("#block-user-form").on("click", "#saveBtn-block-user", function () {

        sendAjaxRequestWithSuccess("block-user-form", 'block-user-modal', reloadUsersTable, ["users"]);

    });



    $("#unblock-user-form").on("click", "#saveBtn-unblock-user", function () {

        sendAjaxRequestWithSuccess("unblock-user-form", 'unblock-user-modal', reloadUsersTable, ["users"]);

    });

    $("#delete-user-form").on("click", "#saveBtn-delete-user", function () {

        sendAjaxRequestWithSuccess("delete-user-form", 'delete-user-modal', reloadUsersTable, ["users"]);

    });


    $("#add-user-form").on("click", "#saveBtn-add-user", function () {

        let fields = ["first_name", "last_name", "user_name", "role", "Email", "email", "group", "Phone", "status", "email_confirm"];
        sendAjaxRequest("add-user-form", fields, "add-user-confirm", "add-user-error", reloadUsersTable, ["users"]);

    });

    $("#add-user-form").on("click", "#cancelBtn-add-user", function () {
        reloadForm("add-user-form");
    });


    $('#users').on('click', ".edit-user", function () {
        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            success: function (response) {
                $('#edit-user-modal-container').html(response);
                $('#edit-user-modal').modal('show');


                $("#edit-user-form").on("click", "#saveBtn-edit-user", function () {

                    let fields = ["first_name", "last_name", "user_name", "role", "Email", "email", "group", "Phone", "status", "email_confirm"];
                    sendAjaxRequest("edit-user-form", fields, "edit-user-confirm", "edit-user-error", reloadUsersTable, ["users"]);
                });

                $("#edit-user-form").on("click", "#cancelBtn-edit-user", function () {
                    reloadForm("edit-user-form");
                });


            },
        });

    });


    //tabs
    $('.tab-item').click(function (e) {
        sessionStorage.setItem("clicked", $(this).attr('id'));
    });


    if (sessionStorage.getItem("clicked") != null) {
        var clickeId = sessionStorage.getItem("clicked");
        $('.tab-item').removeClass('active');
        $(`#${clickeId}`).addClass('active');

        $('.tab-pane').removeClass('active');
        $($($(`#${clickeId}`).attr('href'))).addClass('show active');


    }

    // delete group confirmation
    $('#groups').on('click', '.delete-group', function (event) {
        $('#delete-group-form').attr('data-url', $(this).attr('data-url'))
    });


    // activate user modal
    $('#users').on('click', '.activate-user', function (event) {
        $('#activate-user-form').attr('data-url', $(this).attr('data-url'))
    });

    // block user modal
    $('#users').on('click', '.block-user', function (event) {
        let user_name = $(this).closest('tr').find('td:first').text();
        $('#block-user-modal').find('.modal-body p').text(`Are you sure you want to block ${user_name}? `)
        $('#block-user-form').attr('data-url', $(this).attr('data-url'))
    });


    // block user modal
    $('#users').on('click', '.unblock-user', function (event) {
        let user_name = $(this).closest('tr').find('td:first').text();
        $('#unblock-user-modal').find('.modal-body p').text(`Are you sure you want to Unblock ${user_name}? `)
        $('#unblock-user-form').attr('data-url', $(this).attr('data-url'))
    });

    // block user modal
    $('#users').on('click', ".delete-user", function (event) {
        let user_name = $(this).closest('tr').find('td:first').text();
        $('#delete-user-modal').find('.modal-body p').text(`Are you sure you want to delete ${user_name}? `)
        $('#delete-user-form').attr('data-url', $(this).attr('data-url'))
    });

    $("#add-user-form").on('change', "#role", function () {
        if ($(this).val() == "admin") {
            $('#group').attr('disabled', true);
        } else {
            $('#group').attr('disabled', false);
        }
    });

    $("#edit-user-modal-container").on('change', "#role", function () {
        if ($(this).val() == "admin") {
            $('#group').attr('disabled', true);
            $('#group option:first').prop('selected', true);

        } else {
            $('#group').attr('disabled', false);
        }
    });


});
