$(function () {

    $('.container-fluid').on('click', "#add-metric-button", function () {

        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            success: function (response) {
                $('#add-metric-modal').modal('show');
                $("#add-metric-iframe-loader").fadeOut();
                $('#add-metric-modal').find("iframe").attr("src", url);

                $("#add-metric-modal-iframe").on('load', function () {

                    adjustModalHeight("add-metric-modal-iframe");

                    $("#add-metric-iframe-loader").fadeOut();
                });

            }, error: function (response) {
                $(`#success-modal`).find('h5').text(response.responseJSON.message).show();
                $(`#success-modal`).modal('show');
                $("#global-loader").fadeOut();
                $('#add-metric-modal').find("iframe").attr("src", "");

            }

        });

    });

    $("#add-metric-modal").on('hidden.bs.modal', function () {
        let forgetSessionUrl = $("#add-metric-button").data('forget');

        $.ajax({
            type: "POST",
            url: forgetSessionUrl,
            success: function () {
                $('#add-metric-modal').find("iframe").attr("src", "");
            }

        });

    })


    // change report category

    $(document).on('click', ".change-category", function () {
        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            beforeSend: function () {
                $("#global-loader").fadeIn();
            },

            success: function (response) {
                $("#global-loader").fadeOut();

                $('#change-category-modal-container').html(response);
                $('#change-category-modal').modal('show');

                $("#change-category-modal").on("click", "#saveBtn-change-category", function () {

                    let fields = ["metric_category"];
                    sendAjaxRequest("change-category-form", fields, "confirm-change-category", "error-change-category", reloadPagePartially, [null, ".charts", ".charts"]);
                });

                $("#change-category-modal").on("click", "#cancelBtn-change-category", function () {
                    reloadForm("change-category-form");
                    $('#error-change-category, #confirm-change-category').hide();

                });


            },
        });

    });


    // delete report modal
    $(document).on('click', ".delete-metric", function (event) {
        let metric = $(this).closest('.small-box').find(".inner").find("p").text();
        $('#delete-metric-modal').find('.modal-body p').text(`Are you sure you want to delete "${metric}" metric?`)
        $('#delete-metric-form').attr('data-url', $(this).attr('data-url'))
    });

    $("#delete-metric-form").on("click", "#saveBtn-delete-metric", function () {

        sendAjaxRequestWithSuccess("delete-metric-form", 'delete-metric-modal', reloadMetricPagePartially, [".metric-parent-container", ".metric-parent-container", false], true);

    });


    $(document).on('click', ".edit-metric", function () {
        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            beforeSend: function () {
                $('#edit-metric-modal').modal('show');

                $("#edit-metric-iframe-loader").fadeIn();


            },
            success: function (response) {

                $('#edit-metric-modal').find("iframe").attr("src", url);

                $("#edit-metric-iframe-loader").fadeOut();

                $("#edit-metric-modal-iframe").on('load', function () {
                    $("#edit-metric-iframe-loader").fadeOut();

                    adjustModalHeight("edit-metric-modal-iframe");

                });

                $('#edit-metric-modal').on('hidden.bs.modal', function () {
                    let forgetSessionUrl = $("#add-metric-button").data('forget');

                    $.ajax({
                        type: "GET",
                        url: forgetSessionUrl,
                        success: function () {
                            $('#edit-metric-modal-iframe').attr("src", "");
                        }

                    });


                });
                $("#global-loader").fadeOut();


            }, error: function (response) {
                $(`#success-modal`).find('h5').text(response.responseJSON.message).show();
                $(`#success-modal`).modal('show');

                setTimeout(function () {
                    $('#edit-metric-modal').modal('hide');
                }, 500)

                $("#global-loader").fadeOut();


            }

        });

    });

    $(document).on('click', "#metric-search", function (e) {
        e.preventDefault();
        reloadPagePartially("metric-search-form", ".metric-parent-container", ".metric-parent-container");
    });

    $(document).on('click', ".show-all", function () {
        $('input[name="metricTitle"]').val("");
        $('select[name="metricCategory"]').val("");

        reloadPagePartially("metric-search-form", ".metric-parent-container", ".metric-parent-container");

        let url = window.location.href.split("?")[0];
        // remove page query if exists
        window.history.replaceState('', '', url);
    });



    $(document).on('click', ".duplicate-metric", function () {
        let url = $(this).data('url');
        $('#duplicate-modal').modal('show');
        $('#duplicate-form').attr('data-url', $(this).attr('data-url'))
        $('#duplicate-form #name').val($(this).attr('data-name') + "_1")
    });


    $(document).on("click", "#saveBtn-duplicate", function () {
        
        sendAjaxRequestWithErrorsAndWithSuccess("duplicate-form", 'duplicate-modal','error-duplicate', reloadMetricPagePartially, [".metric-parent-container", ".metric-parent-container", false], true);

    });

})
