    $(document).on('click', ".view-access-log", function () {
        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            success: function (response) {
                $('#view-access-log-modal-container').html(response);
                $('#view-access-log-modal').modal('show');

                $('[data-toggle="tooltip"]').tooltip();

                document.getElementById('showAccessKey').addEventListener('change', function () {
                    document.getElementById('accessKeyContainer').style.display = this.checked ? 'block' : 'none';
                });

                document.getElementById('copyAccessKey').addEventListener('click', function () {
                    const accessKey = document.getElementById('accessKey').innerText;
                    navigator.clipboard.writeText(accessKey).then(() => {
                        const icon = document.getElementById('copyAccessKey');
                        icon.classList.remove('fa-copy');
                        icon.classList.add('fa-check');
                        setTimeout(() => {
                            icon.classList.remove('fa-check');
                            icon.classList.add('fa-copy');
                        }, 2000);
                    });
                });

            },
        });

    });
