<?php

namespace App\Services;

use App\Models\Setting;
use App\Models\EmbedPreference;

class EmbedPreferencService
{

    public function getPreferences()
    {
        $preferences = EmbedPreference::get();
        $arrayOfPreferences = $preferences->map(function ($key) {
            return  [$key->key => $key->value];
        });

        return array_merge(...$arrayOfPreferences);
    }

    public function update($settings)
    {
        foreach ($this->prepareToUpdate($settings) as $setting => $value) {
            EmbedPreference::updateOrCreate(
                [
                    'key' => $setting
                ],
                [
                    'value' => $value
                ]
            );
        }
    }

    private function prepareToUpdate($data)
    {
        return [
            'custom_php_before_embed' => isset($data["custom_php_before_embed"]) ? $data["custom_php_before_embed"] : null,
            'custom_php_after_embed' => isset($data["custom_php_after_embed"]) ? $data["custom_php_after_embed"] : null,
            'custom_html_before_embed' => isset($data["custom_html_before_embed"]) ? $data["custom_html_before_embed"] : null,
            'custom_html_after_embed' => isset($data["custom_html_after_embed"]) ? $data["custom_html_after_embed"] : null,
            'iframe_width' => isset($data["iframe_width"]) ? $data["iframe_width"] : 100,
            'iframe_height' => isset($data["iframe_height"]) ? $data["iframe_height"] : 800,
            'embed_token_life_span' => isset($data["embed_token_life_span"]) ? $data["embed_token_life_span"] : 60,
        ];
    }
}
