<?php

namespace App\Services;

use App\Models\Resource;
use App\Models\Dashboard;
use App\Repositories\DashboardRepository;

class DashboardService
{
    private $dashboardRepository;
    private $homeService;
    public function __construct(DashboardRepository $dashboardRepository, HomeService $homeService)
    {
        $this->homeService         = $homeService;
        $this->dashboardRepository = $dashboardRepository;

    }

    public function index()
    {
        return Dashboard::where('user_id', auth()->user()->user_ID)
            ->orderBy('order', 'asc')->withCount('widgets')->get();
    }

    public function show($dashboard)
    {
        $this->checkAccess($dashboard);

        $numberOfDashboardWidgets = config('srm_config.dashboard.max_dashboard_widgets', 20);

        $paginatedWidgets = $dashboard->widgets()->paginate($numberOfDashboardWidgets);

        foreach ($paginatedWidgets as $widget) {

            if (isset($widget->resource_id)) {
                $this->homeService->buildResource($widget->resource);
            } else {

                if (request()->query('mode')) {
                    $widget->report_lists = collect($widget->report_lists)
                        ->filter(function ($r) {
                            $report = Resource::find($r['id']);
                            return !empty($report->configurations->Json_configurations["embed"]);
                        })->values();
                }
            }

        }

        return [$dashboard, $paginatedWidgets];
    }

    public function store($request)
    {
        $this->dashboardRepository->store($request);
    }

    public function update($request, $dashboard)
    {
        $this->dashboardRepository->update($request, $dashboard);
    }

    public function moveUp($dashboard)
    {
        $this->dashboardRepository->moveUp($dashboard);
    }

    public function moveDown($dashboard)
    {
        $this->dashboardRepository->moveDown($dashboard);

    }

    public function destory($dashboard)
    {
        $this->dashboardRepository->destory($dashboard);

    }

    public function checkAccess($dashboard)
    {
        $user = auth()->user();

        if (!is_null(request()->query('token')) && !is_null(session('loginType'))) {
            return true;
        }

        $isAuthorized = (
            ($user && $dashboard->user_id == auth()->user()->user_ID) ||
            strtolower($dashboard->access_type) == "public"
        );

        if (!$isAuthorized) {
            abort(403, 'Access denied');
        }

    }

    public function getRecentDashboard()
    {
        return $this->dashboardRepository->getRecentDashboard();
    }

    public function getAllDashboards()
    {
        return Dashboard::where('user_id', auth()->user()->user_ID)
            ->orderBy('order', 'asc')->withCount('widgets');
    }

}
