<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;

use App\Mails\ActivateUserMail;
use App\Mails\VerificationMail;
use App\Mails\ResetPasswordMail;
use App\Mails\InvitationUserMail;
use App\Mails\ResetPasswordManually;
use App\Mails\EmailChangedConfirmation;
use Illuminate\Notifications\Notifiable;
use App\Mails\ResetPasswordConfirmationMail;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Auth\Passwords\CanResetPassword;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable implements MustVerifyEmail
{
    use HasFactory;
    use Notifiable;
    use SoftDeletes;
    use CanResetPassword;

    protected $primaryKey = 'user_ID';
    protected $connection = 'mysql';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'first_name',
        'last_name',
        'user_name',
        'Email',
        'Password',
        'password',
        'Phone',
        'consecutive_login_failures',
        'last_lock_time',
        'Security_question_index',
        'Security_answer',
        'status',
        'is_admin',
        'is_owner',
        'added_by',
        'regestration_IP',
        'group_id',
        'email_verified_at'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'Password',
        'remember_token'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password'          => 'hashed'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix      = config('srm_config.installer.table_prefix');
        $this->table = "{$prefix}Users";
    }

    public function getAuthPassword()
    {
        return $this->Password;
    }

    public function getEmailForPasswordReset()
    {
        return $this->Email;
    }

    public function getEmailForVerification()
    {
        return $this->Email;
    }

    public function getUserType()
    {

        if ($this->is_owner || $this->is_admin) {
            return 'admin';
        } else {
            return 'user';
        }

    }

    public function sendPasswordResetNotification($token)
    {
        (new ResetPasswordMail($this, $token))->send();
    }

    public function sendPasswordResetConfirmationNotification($user)
    {
        (new ResetPasswordConfirmationMail($user))->send();
    }

    public function setLastChangePasswordIPAddress($ip_address)
    {
        $this->last_change_password_IP = $ip_address;
    }

    public function sendEmailVerificationNotification()
    {
        (new VerificationMail($this))->send();
    }

    public function sendEmailInvitationNotification($temp_password)
    {
        (new InvitationUserMail($this, $temp_password))->send();
    }

    public function sendActivateUserMail()
    {
        (new ActivateUserMail($this))->send();
    }

    public function sendResetPasswordManuallyMail($temp_password)
    {
        (new ResetPasswordManually($this, $temp_password))->send();
    }

    public function sendEmailChangedConfirmationMail($new_email)
    {
        (new EmailChangedConfirmation($this, $new_email))->send();
    }

    public function isAdmin()
    {
        return $this->is_admin;
    }

    public function isOwner()
    {
        return $this->is_owner;
    }

    public function isUser()
    {
        return !$this->is_admin && !$this->is_owner;
    }

    public function isAdminOrOwner()
    {
        return $this->isAdmin() || $this->isOwner();
    }

    public function isAdminAndOwner()
    {
        return $this->isAdmin() && $this->isOwner();
    }

    public function group()
    {
        return $this->belongsTo(Group::class, 'group_id');
    }

    public function resource()
    {
        return $this->belongsTo(User::class, 'resource_creator');
    }

    public function isEmailConfirmed()
    {
        return isset($this->email_verified_at) ? true : false;
    }

}