<?php

namespace App\Models;

use App\Models\ScheduledTask;
use Illuminate\Database\Eloquent\Relations\Pivot;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ScheduledTaskResource extends Pivot
{
    use HasFactory;

    protected $connection = 'mysql';
    public $timestamps    = false;

    protected $fillable = [
        'task_id',
        'resource_id'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix      = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}scheduled_task_resources";
    }

    public function resource()
    {
        return $this->hasMany(Resource::class, 'id', 'resource_id');
    }

    public function ScheduledTask()
    {
        return $this->hasMany(ScheduledTask::class, 'id', 'task_id');
    }

}
