<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class EmbedLog extends Model
{
    use HasFactory;

    protected $primaryKey = 'id';
    protected $connection = 'mysql';

    protected $fillable = [
        'access_key_id',
        'token_id',
        'resource_url',
        'success',
        'attembed_ip',
        'origin',
        'reason'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix      = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}embed_log";
    }

    public function accessKey()
    {
        return $this->belongsTo(AccessKey::class, 'access_key_id');
    }
}
