<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Category extends Model
{
    use HasFactory, SoftDeletes;
    protected $primaryKey = 'id';
    protected $connection = 'mysql';

    protected $fillable = [
        'name',
        'description',
        'icon',
        'order'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix      = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}categories";
    }

    public function resources()
    {
        return $this->hasMany(Resource::class, 'category_id');
    }

    public static function tableName()
    {
        return with(new static )->getTable();
    }

    public function isDefaultCategory($defaultCategory)
    {
        return strtolower($this->name) == strtolower($defaultCategory) ? true : false;
    }
}
