<?php

namespace App\Mails;

use App\Mails\SendMail;
use App\Mails\MailTrait;
use App\Mails\MailInterface;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Config;

class VerificationMail implements MailInterface
{
    use MailTrait;

    public $user;
    private $subject;
    private $content;
    private $username;
    private $signature;
    private $headers;
    private $receiver;

    public function __construct($user)
    {
        $this->user = $user;
    }

    public function send()
    {
        $this->buildMailMessage("Activate your email");

        SendMail::mail(
            $this->receiver,
            $this->subject,
            $this->content,
            $this->headers,
        );
    }

    /**
     * Set the value of content
     */
    public function setMessageContent()
    {
        $username        = $this->username;
        $organization    = get_organization();
        $signature       = $this->signature;
        $verificationUrl = $this->verificationUrl($this->user);

        $this->content = view(
            'auth.mails.verify',
            compact('username', 'organization', 'signature', 'verificationUrl')
        )->render();
    }

    protected function verificationUrl($notifiable)
    {
        return URL::temporarySignedRoute(
            'verification.verify',
            Carbon::now()->addMinutes(Config::get('auth.verification.expire', 1440)),
            [
                'id'   => $notifiable->getKey(),
                'hash' => sha1($notifiable->getEmailForVerification())
            ]
        );
    }
}
