<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class UpdateEmbedPreferencesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "custom_php_before_embed"  => ["nullable"],
            "custom_php_after_embed"   => ["nullable"],
            "custom_html_before_embed" => ["nullable"],
            "custom_html_after_embed"  => ["nullable"],
            "iframe_height"            => ["required"],
            "iframe_width"             => ["required"],
            "embed_token_life_span"    => ["required"]
        ];
    }

    public function messages()
    {
        return [
            "iframe_height.required"       => trans("embed-preference.validations.required.iframe_height"),
            "iframe_width.required"       => trans("embed-preference.validations.required.iframe_width"),
            "embed_token_life_span.required"       => trans("embed-preference.validations.required.embed_token_life_span"),

        ];
    }

    public function validated($key = null, $default = null): array
    {
        return array_merge(parent::validated(), ['cronjobs_created' => null]);
    }
}
