<?php

namespace App\Http\Requests\PivotTable;

use Carbon\Carbon;
use App\Models\Resource;
use Illuminate\Foundation\Http\FormRequest;

class pivotTableShowRequest extends FormRequest
{


    public function rules(): array
    {
        $prefix = config("srm_config.installer.table_prefix", "srm_");

        return [
            'parameters'              => ["nullable"],
            'parametersValues.*'      => ["nullable"],
            'parametersValues.*.from' => ["nullable", function ($attribute, $value, $fail) {
                $this->validateDateRange($attribute, $value, $fail);
            }
            ],
            'parametersValues.*.to'   => ["nullable", function ($attribute, $value, $fail) {
                $this->validateDateRange($attribute, $value, $fail);
            }

            ],
        ];
    }

    private function validateDateRange($attribute, $value, $fail)
    {
        $data = $this->input('parametersValues');

        foreach ($data as $values) {
            $from = $values['from'] ?? null;
            $to   = $values['to'] ?? null;

            if (is_null($from) xor is_null($to)) {
                return $fail(trans("pivot-tables.validations.required.missing_filter_date"));
            }

            if ($to && $from && Carbon::parse($to)->lessThan(Carbon::parse($from))) {
                return $fail(trans("pivot-tables.validations.custom.to_date_less_than_from_date"));
            }

        }

    }

    public function messages()
    {
        return [
            'values_fields.required' => trans('pivot-tables.validations.required.values_fields'),
        ];
    }

}
