<?php

namespace App\Http\Requests\PivotTable;

use Illuminate\Foundation\Http\FormRequest;

class PivotTableDuplicateRequest extends FormRequest
{

    public function rules(): array
    {
        $prefix = config("srm_config.installer.table_prefix", "srm_");

        return [
            'name' => ['required', "unique:{$prefix}analytics_resources,name", 'regex:/^[a-zA-Z_][a-zA-Z0-9_ \-]*$/']
        ];
    }

    public function messages()
    {
        return [
            'values_fields.required' => trans('pivot-tables.validations.required.values_fields')
        ];
    }

}
