<?php

namespace App\Http\Requests\Metrics;

use Illuminate\Foundation\Http\FormRequest;

class SettingStepUpdateRequest extends FormRequest
{

    protected function prepareForValidation()
    {
        if ($this->has('name')) {
            $this->merge([
                'name' => preg_replace('/[-\s]+/', '_', $this->input('name'))
            ]);
        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $prefix = config("srm_config.installer.table_prefix", "srm_");
        return [
            'name'          => ['required', "unique:{$prefix}analytics_resources,name," . $this->route('metric')->id, 'regex:/^[a-zA-Z_][a-zA-Z0-9_ \-]*$/'],
            'title'         => ['required', "string", "max:70"],
            'category'      => ['required'],
            'security_type' => ['required'],
            'groups'        => ['nullable', 'array']
        ];
    }

    public function messages()
    {
        return [
            'name.required'          => trans('metrics.validations.required.name'),
            'name.unique'            => trans('metrics.validations.unique.name'),
            'name.regex'             => trans('metrics.validations.regex'),
            'title.required'         => trans('metrics.validations.required.title'),
            'title.max'              => trans('metrics.validations.max.title'),
            'title.regex'            => trans('metrics.validations.regex'),
            'category.required'      => trans('metrics.validations.required.category'),
            'connection.required'    => trans('metrics.validations.required.connection'),
            'security_type.required' => trans('metrics.validations.required.security_type')
        ];
    }
}
