<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\Resource;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class checkEmbedToken
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if ($request->has('authorization') 
            && $request->input('authorization')) {
            return $next($request);
        }

        $routeName = $request->route()->getName();

        $resourceTypeMap = [
            'pivot-tables.' => 'pivotTable',
            'charts.'       => 'chart',
            'metrics.'      => 'metric',
            'reports.'      => 'report',
        ];

        foreach ($resourceTypeMap as $prefix => $param) {
            if (str_starts_with($routeName, $prefix)) {
                $resource = $this->resolveResource($request->route($param));

                if ($prefix === 'reports.') {
                    // dd($resource->access_control_type);
                    if ($resource->access_control_type === 'Public') {
                        $url = route('home') . '/public/srm_modules/' . $resource->url;
                        return redirect()->to($url);
                    }
                    return redirect()->route('login');
                }

                if ($resource->access_control_type !== 'Public') {
                    return redirect()->route('login');
                }

                break; // Once matched, stop checking other prefixes
            }
        }

        return $next($request);
    }

    private function resolveResource($resource)
    {
        if (is_string($resource)) {
            return Resource::where('name', $resource)->first();
        }

        return $resource;
    }
}
