<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class OnlyFullVersion
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        if (!checkDemo()) {
            return $next($request);
        }

        $demoMessage = $request->has('pivot_table_name') ? trans('global.messages.pivot_table_demo_message') : trans('global.messages.demo_message');

        return $request->wantsJson()
        ? response()->json([
            'demo' => $demoMessage
        ])
        : redirect()->back()->with('demo', $demoMessage);
    }

}
