<?php

namespace App\Http\Controllers;

use App\Models\Module;
use App\Services\ModuleService;
use App\Services\ResourceService;

class ResourceController extends Controller
{
    private $moduleService;
    private $resourceService;

    public function __construct(ModuleService $moduleService, ResourceService $resourceService)
    {
        $this->moduleService   = $moduleService;
        $this->resourceService = $resourceService;
    }

    public function getAllResourcesByModuleId($module, $dashboard = null)
    {
        return response()->json([
            "success" => true,
            "data"    => [
                'resources' => $this->resourceService->getAllResourceByModuleId($module, $dashboard)
                    ->select(['id', 'name'])
                    ->get(),
                'can_add'   => Module::find($module)->checkWhoCanAccessModule() || auth()->user()->isAdminOrOwner()
            ]
        ]);

    }

    public function getAllEmbedResourcesByModuleId($module, $dashboard = null)
    {
        return response()->json([
            "success" => true,
            "data"    => [
                'resources' => $this->resourceService->getAllEmbedResourcesByModuleId($module, $dashboard)
                    ->select(['id', 'name'])
                    ->get(),
                'can_add'   => Module::find($module)->checkWhoCanAccessModule() || auth()->user()->isAdminOrOwner()
            ]
        ]);

    }
}
