<?php

namespace App\Http\Controllers\PivotTables;

use App\Models\Resource;
use App\Services\PivotTableService;
use App\Http\Controllers\Controller;
use App\Http\Middleware\OnlyFullVersion;
use App\Http\Requests\PivotTable\PivotTableRequest;

class PivotTableUpdateController extends Controller
{
    private $pivotTableService;

    public function __construct(PivotTableService $pivotTableService)
    {
        $this->pivotTableService = $pivotTableService;

        $this->middleware(OnlyFullVersion::class);

    }

    public function __invoke(PivotTableRequest $request, Resource $pivotTable)
    {
        $resourceId = $this->pivotTableService->update($request->validated(), $pivotTable);

        return response()->json([
            'success' => true,
            "message" => trans('pivot-tables.messages.update')
        ]);

    }

}
