<?php

namespace App\Http\Controllers\PivotTables;

use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Builders\PivotTableBuilder;
use App\Services\PivotTableService;
use App\Http\Controllers\Controller;
use App\Http\Requests\PivotTable\PivotTableRequest;

class PivotTablePrintController extends Controller
{
    public $pivotTableService;
    public $pivotTableBuilder;

    public function __construct(PivotTableService $pivotTableService)
    {
        $this->pivotTableService = $pivotTableService;
        $this->pivotTableBuilder = new PivotTableBuilder(request());
    }

    public function __invoke(PivotTableRequest $request)
    {
        $pivotTable = $this->pivotTableBuilder->build($request->validated());
        $pdf = Pdf::loadView('dashboard.pivot-tables.pdf.print', compact('pivotTable','request'))
            ->setPaper('a4', 'landscape');

        return $pdf->stream("test" . '.pdf');
    }
}
