<?php

namespace App\Http\Controllers\Metrics;

use App\Models\Resource;
use Illuminate\Http\Request;
use App\Services\MetricService;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Http\Controllers\Controller;

class MetricDrillPrintController extends Controller
{
    public $metricService;

    public function __construct(MetricService $metricService)
    {
        $this->metricService = $metricService;
    }

    public function __invoke(Resource $metric)
    {
        [$data, $keys] = $this->metricService->drill($metric);

        $image = request()->input('metricPrintImageData');

        if (count($keys) > 5) {

            $pdf = Pdf::loadView('dashboard.metrics.pdf.drill', compact('metric', 'data', 'keys', 'image'))->setPaper('a4', 'landscape');

        } else {
            $pdf = Pdf::loadView('dashboard.metrics.pdf.drill', compact('metric', 'data', 'keys', 'image'));

        }

        return $pdf->stream(ucfirst($metric->name) . '-page ' . $data->currentPage() . '.pdf');

    }

}
