<?php

namespace App\Http\Controllers;

use App\Services\HomeService;
use App\Services\EmbedResourceService;
use App\Services\EmbedPreferencService;
use App\Http\Middleware\OnlyFullVersion;
use Illuminate\Support\Facades\Response;
use App\Http\Requests\generateEmbedResourceRequest;

class EmbedResourceController extends Controller
{
    public $homeService;
    public $embedPreferencService;

    public function __construct(HomeService $homeService, EmbedResourceService $embedPreferencService)
    {
        $this->homeService           = $homeService;
        $this->embedPreferencService = $embedPreferencService;
    }

    public function index()
    {
        $resourceTypes = $this->homeService->getResourceTypes();

        return view('dashboard.embed-resource.index', compact('resourceTypes'));
    }

    public function generate(generateEmbedResourceRequest $request)
    {
        $url = $this->embedPreferencService->generate($request->validated());

        return response()->json([
            "url"     => $url,
            "type"    => $request['type_of_embed'],
            "message" => "The embedding preferences are updates successfully."
        ]);
    }

    public function generateUrl($type, $resource)
    {
        $url = $this->embedPreferencService->getUrl($type, $resource);

        return response()->json([
            "url"     => $url,
        ]);
    }

    public function generatePHP($resourceType, $resource, $accessKey)
    {
        $data = $this->embedPreferencService->preparePHPFileData($resourceType, $resource, $accessKey);
        $path = resource_path('views/embed/php.stub');

        $content = file_get_contents($path);

        foreach ($data as $key => $value) {

            if (is_array($value)) {
                $value = json_encode($value);
            }

            $content = str_replace('{{' . $key . '}}', $value, $content);
        }

        return Response::make($content, 200, [
            'Content-Type'        => 'text/plain',
            'Content-Disposition' => 'attachment; filename="Embed_' . $data['srm_resource_name'] . '.php"'
        ]);

    }

    public function generateHTML($resourceType, $resource)
    {
        $data = $this->embedPreferencService->prepareHTMLFileData($resourceType, $resource);
        $html = view('embed.html', $data);

        return Response::make($html, 200, [
            'Content-Type'        => 'text/html',
            'Content-Disposition' => 'attachment; filename="Embed_' . $data['srm_resource_name'] . '.html"'
        ]);

    }

    public function getAllDashboards()
    {

    }

}
