<?php

namespace App\Http\Controllers;

use App\Models\Group;
use App\Models\AccessKey;
use App\Services\BarcodeService;
use App\Models\BarcodeDefinition;
use App\Services\AccessKeyService;
use App\Http\Middleware\OnlyFullVersion;
use App\Http\Requests\StoreAccessKeyRequest;
use App\Http\Requests\StoreBarCodeDefinitionRequest;
use App\Http\Requests\UpdateBarCodeDefinitionRequest;
use App\Http\Requests\UpdateEmbedPreferencesRequest;
use App\Services\EmbedPreferencService;

class EmbedPreferencesController extends Controller
{
    public $embedPreferencService;

    public function __construct(EmbedPreferencService $embedPreferencService)
    {
        $this->embedPreferencService = $embedPreferencService;

        $this->middleware(OnlyFullVersion::class)->only(
            [
                'update'
            ]
        );
    }

    public function index()
    {
        $preferences = $this->embedPreferencService->getPreferences();
        $groups = Group::all();

        return view('dashboard.embed-preferences.index', compact('preferences', 'groups'));
    }


    public function update(UpdateEmbedPreferencesRequest $request)
    {
        $this->embedPreferencService->update($request->validated());

        return response()->json([
            "message" => "The embedding preferences are updates successfully.",
        ]);
    }

}
