<?php

namespace App\Http\Controllers;

use App\Models\EmbedLog;
use App\Services\HomeService;
use App\Services\AccessKeyService;
use App\Http\Middleware\OnlyFullVersion;

class AccessLogController extends Controller
{
    public $homeService;
    public $accessKeyService;

    public function __construct(HomeService $homeService, AccessKeyService $accessKeyService)
    {
        $this->homeService      = $homeService;
        $this->accessKeyService = $accessKeyService;

        $this->middleware(OnlyFullVersion::class)->only(
            [
                'update'
            ]
        );
    }

    public function index()
    {
        $logs = EmbedLog::with(['accessKey' => function ($query) {
            $query->withTrashed();
        }])
            ->orderBy('created_at', 'desc')
            ->get();
            
        if(checkDemo()){
            $logs = EmbedLog::whereRaw("1 = 0")->get();
        }

        return view('dashboard.access-log.index', compact('logs'));
    }

    public function show(EmbedLog $accessLog)
    {

        return view('dashboard.access-log.partials._view_modal', compact('accessLog'));
    }

}
