<?php

namespace App\Generators;

class ParametersFilter
{
    private $parameter;
    private $values;
    private $table;
    private $column;

    public function __construct($parameter, $values)
    {
        $this->parameter = $parameter;
        $this->values    = $values;
        $this->table     = $this->parameter['table'] ?? '';
        $this->column    = $this->parameter['column'] ?? '';

    }

    private function multiSelectFilter()
    {
        $values = (array) $this->values;

        if (empty($values) || (count($values) === 1 && strcasecmp($values[0], 'Null') === 0)) {
            $sql = " {$this->table}.{$this->column} IS NULL";
            return [$sql, []];
        }

        $valuesWithoutNull = array_filter($values, function($value) {
            return strcasecmp($value, 'Null') !== 0;
        });

        $placeholders = implode(',', array_fill(0, count($valuesWithoutNull), '?'));
        $nullCondition = in_array('null', array_map('strtolower', $values)) ? " OR {$this->table}.{$this->column} IS NULL" : '';
        $sql = " ( {$this->table}.{$this->column} IN ($placeholders)$nullCondition ) ";

        return [$sql, $valuesWithoutNull];

    }


    private function numericSliderFilter()
    {
        if(empty($this->values)){
            return [];
        }
        $minAndMax = explode(',', $this->values);

        $min = explode(':', $minAndMax[0]);

        $max = explode(':', $minAndMax[1]);

        $sql = " {$this->table}.{$this->column} >= ? AND {$this->table}.{$this->column} <= ?";

        return [$sql, [$min[1], $max[1]] ?? []];
    }


    private function numericSearchBoxFilter()
    {
        if(empty($this->values)){
            return [];
        }
        $sql = " {$this->table}.{$this->column} = ?";

        return [$sql, [$this->values] ?? []];
    }

    private function searchBoxFilter()
    {
        if(empty($this->values)){
            return [];
        }
        $sql = " {$this->table}.{$this->column} LIKE ?";

        $this->values = '%' . $this->values . '%';

        return [$sql, [$this->values] ?? []];
    }

    private function dateCalenderFilter()
    {
        if(empty($this->values)){
            return null;
        }

        $from = $this->values['from'];

        $to = $this->values['to'];

        $sql = " ({$this->table}.{$this->column} >= ? AND {$this->table}.{$this->column} <= ?)";

        return [$sql, [$from, $to] ?? []];
    }


    private function timeSliderFilter()
    {
        if(empty($this->values)){
            return [];
        }
        $minAndMax = explode(',', $this->values);

        $min = explode('=', $minAndMax[0])[1];

        $max = explode('=', $minAndMax[1])[1];

        $sql = " ({$this->table}.{$this->column} >= ? AND {$this->table}.{$this->column} <= ?)";

        return [$sql, [$min, $max] ?? []];
    }


    private function checkTypeAndBuild()
    {
        switch ($this->parameter['function']) {
            case 'multi-select':
                return $this->multiSelectFilter();
                break;
            case 'numeric-slider':
                return $this->numericSliderFilter();
                break;
            case 'numeric-search-box':
                return $this->numericSearchBoxFilter();
                break;
            case 'search-box':
                return $this->searchBoxFilter();
                break;
            case 'date-calendar':
                return $this->dateCalenderFilter();
                break;
            case 'time-slider':
                return $this->timeSliderFilter();
                break;
            default:
                break;
        }

        return ['', []];
    }

    public function getSqlAndBindings()
    {
        // if(is_null($this->values) || empty($this->values)){
        //     return null;
        // }
        return $this->checkTypeAndBuild();
    }

}
