<?php require base_path_native('views/partials/head.php')?>
<?php require base_path_native('views/partials/pills.php')?>

<div class="tab-content">
  <div class="row">
    <div class="col-sm-12">
      <div class="form-group">
        <p style="text-align: center; margin: 20px">
          <img src="<?=asset_native('assets/assets/img/srm-logo.jpg')?>" />
        </p>
        <div style="text-align: center">
          <h3>Welcome to Smart Report Maker!</h3>
          <p class="description">
            We appreciate your choice of Smart Report Maker.
            This installation wizard will guide you through
            the process of installing all the modules
            included in the Smart Report Maker Full
            Reporting Package.
          </p>
        </div>
      </div>
    </div>
  </div>
  <?php

  if (!check_minimum_php_version()["can_run"]): ?>
  <div class="text-center text-danger text-sm">
    <small><?=check_minimum_php_version()["php_version_warning"]?></small>
  </div>
  <?php endif;?>

  <div class="text-center text-danger">
    <h5> Installation Method: <?php echo ucfirst(installation_method()) ?></h5>
  </div>
  <div style="margin: 20px" class="wizard-footer">
    <div class="pull-right">
      <!-- Finish Button -->
      <input type="button" class="btn btn-finish btn-fill btn-warning btn-wd" name="finish" value="Finish"
        style="display: none" />
      <?php

      if (!(is_docker() || is_hosted_version() || empty(check_write_permissions()))): ?>
      <a class="btn  btn-fill btn-warning btn-wd" href="<?=route_native('/permissions')?>">Next</a>
      <?php else: ?>
      <a class="btn  btn-fill btn-warning btn-wd" href="<?=route_native('/database')?>">Next</a>
      <?php endif;?>
    </div>
    <div class="pull-left">
      <a class="btn btn-previous btn-default btn-wd disabled">Previous</a>
    </div>
    <div class="clearfix"></div>
  </div>
  <?php require base_path_native('views/partials/footer.php')?>
</div>