<?php

use Webuccino\Install\Core\Seeder;
use Webuccino\Install\Core\Migration;

chdir(__DIR__);

const BASE_PATH = __DIR__ . '/';
require BASE_PATH . '../vendor/autoload.php';
require BASE_PATH . 'Core/functions.php';
require BASE_PATH . 'bootstrap.php';

if ($argc < 2) {
    echo "Usage: php upgrade.php [migrate|rollback]\n";
    exit(1);
}

try {
    $action    = $argv[1] ?? null;
    $migration = new Migration();

    switch ($action) {
        case 'migrate':
            $migration->runMigrations();

            writeImportLog("Seeding started");

            (new Seeder())->runSeeders();

            writeImportLog("Seeding finished");

            echo "DB imported successfully\n";

            break;

        case 'rollback':
            $migration->rollbackMigrations();

            writeImportLog("Rollback finished");

            echo "DB rollback successfully\n";
            break;
        default:
            echo "Usage: php upgrade.php [migrate|rollback]\n";

            break;
    }

} catch (\Exception $e) {

    writeImportLog("Upgrade error: " . $e->getMessage());

    echo $e->getMessage();

}
