<?php

namespace Webuccino\Install\seeder;

use Illuminate\Database\Capsule\Manager as Capsule;

class NorthWindSeeder
{
    public $prefix;
    private $categories;
    private $customers;
    private $employees;
    private $suppliers;
    private $region;
    private $territory;
    private $shipper;
    private $product;
    private $employeeTerritory;
    private $salesOrder;
    private $orderDetail;

    public function __construct()
    {
        $this->prefix = 'test_';

        $this->categories        = $this->prefix . 'Category';
        $this->customers         = $this->prefix . 'Customer';
        $this->employees         = $this->prefix . 'Employee';
        $this->suppliers         = $this->prefix . 'Supplier';
        $this->region            = $this->prefix . 'Region';
        $this->territory         = $this->prefix . 'Territory';
        $this->shipper           = $this->prefix . 'Shipper';
        $this->product           = $this->prefix . 'Product';
        $this->employeeTerritory = $this->prefix . 'EmployeeTerritory';
        $this->salesOrder        = $this->prefix . 'SalesOrder';
        $this->orderDetail       = $this->prefix . 'OrderDetail';
    }

    public function run()
    {
        $this->insertCategories();
        $this->insertCustomers();
        $this->insertEmployees();
        $this->insertSuppliers();
        $this->insertProducts();
        $this->insertSalesOrders();

    }

    private function insertCategories()
    {
        if(Capsule::table($this->categories)->count() !== 0)
            return;

        $this->addCategory(1, "Beverages", "Soft drinks, coffees, teas, beers, and ales");
        $this->addCategory(2, "Condiments", "Sweet and savory sauces, relishes, spreads, and seasonings");
        $this->addCategory(3, "Confections", "Desserts, candies, and sweet breads");
        $this->addCategory(4, "Dairy Products", "Cheeses");
        $this->addCategory(5, "Grains/Cereals", "Breads, crackers, pasta, and cereal");
        $this->addCategory(6, "Meat/Poultry", "Prepared meats");
        $this->addCategory(7, "Produce", "Dried fruit and bean curd");
        $this->addCategory(8, "Seafood", "Seaweed and fish");
    }

    private function addCategory($categoryId, $categoryName, $description)
    {
        Capsule::table($this->categories)->updateOrInsert(
            ["categoryId" => $categoryId],
            [
                "categoryName" => $categoryName,
                "description"  => $description,
                'created_at'   => $this->getRandomDate(),
                'updated_at'   => $this->getRandomDate()
            ]
        );

        return Capsule::table($this->categories)->where("categoryName", $categoryName)->first();
    }

    private function addCustomer(
        $custId,
        $companyName,
        $contactName,
        $contactTitle,
        $address,
        $city,
        $region,
        $postalCode,
        $country,
        $phone,
        $mobile,
        $email,
        $fax
    ) {
        Capsule::table($this->customers)->updateOrInsert(
            ['custId' => $custId],
            [
                'custId'       => $custId,
                'companyName'  => $companyName,
                'contactName'  => $contactName,
                'contactTitle' => $contactTitle,
                'address'      => $address,
                'city'         => $city,
                'region'       => $region,
                'postalCode'   => $postalCode,
                'country'      => $country,
                'phone'        => $phone,
                'mobile'       => $mobile,
                'email'        => $email,
                'fax'          => $fax,
                'created_at'   => $this->getRandomDate(),
                'updated_at'   => $this->getRandomDate()
            ]
        );

        return Capsule::table($this->customers)->where("custId", $custId)->first();
    }

    private function insertCustomers()
    {
        if(Capsule::table($this->customers)->count() !== 0)
            return;

        $this->addCustomer(
            1,
            'Customer NRZBB',
            'Allen, Michael',
            'Sales Representative',
            'Obere Str. 0123',
            'Berlin',
            null,
            '10092',
            'Germany',
            '030-3456789',
            null,
            null,
            '030-0123456'
        );

        $this->addCustomer(
            2,
            'Customer MLTDN',
            'Hassall, Mark',
            'Owner',
            'Avda. de la Constitución 5678',
            'México D.F.',
            null,
            '10077',
            'Mexico',
            '(5) 789-0123',
            null,
            null,
            '(5) 456-7890'
        );

        $this->addCustomer(
            3,
            'Customer KBUDE',
            'Peoples, John',
            'Owner',
            'Mataderos  7890',
            'México D.F.',
            null,
            '10097',
            'Mexico',
            '(5) 123-4567',
            null,
            null,
            null
        );

        $this->addCustomer(
            4,
            'Customer HFBZG',
            'Arndt, Torsten',
            'Sales Representative',
            '7890 Hanover Sq.',
            'London',
            null,
            '10046',
            'UK',
            '(171) 456-7890',
            null,
            null,
            '(171) 456-7891'
        );

        $this->addCustomer(
            5,
            'Customer HGVLZ',
            'Higginbotham, Tom',
            'Order Administrator',
            'Berguvsvägen  5678',
            'Luleå',
            null,
            '10112',
            'Sweden',
            '0921-67 89 01',
            null,
            null,
            '0921-23 45 67'
        );

        $this->addCustomer(
            6,
            'Customer XHXJV',
            'Poland, Carole',
            'Sales Representative',
            'Forsterstr. 7890',
            'Mannheim',
            null,
            '10117',
            'Germany',
            '0621-67890',
            null,
            null,
            '0621-12345'
        );

        $this->addCustomer(
            7,
            'Customer QXVLA',
            'Bansal, Dushyant',
            'Marketing Manager',
            '2345, place Kléber',
            'Strasbourg',
            null,
            '10089',
            'France',
            '67.89.01.23',
            null,
            null,
            '67.89.01.24'
        );

        $this->addCustomer(
            8,
            'Customer QUHWH',
            'Ilyina, Julia',
            'Owner',
            'C/ Araquil, 0123',
            'Madrid',
            null,
            '10104',
            'Spain',
            '(91) 345 67 89',
            null,
            null,
            '(91) 012 34 56'
        );

        $this->addCustomer(
            9,
            'Customer RTXGC',
            'Raghav, Amritansh',
            'Owner',
            '6789, rue des Bouchers',
            'Marseille',
            null,
            '10105',
            'France',
            '23.45.67.89',
            null,
            null,
            '23.45.67.80'
        );

        $this->addCustomer(
            10,
            'Customer EEALV',
            'Bassols, Pilar Colome',
            'Accounting Manager',
            '8901 Tsawassen Blvd.',
            'Tsawassen',
            'BC',
            '10111',
            'Canada',
            '(604) 901-2345',
            null,
            null,
            '(604) 678-9012'
        );

        $this->addCustomer(
            11,
            'Customer UBHAU',
            'Jaffe, David',
            'Sales Representative',
            'Fauntleroy Circus 4567',
            'London',
            null,
            '10064',
            'UK',
            '(171) 789-0123',
            null,
            null,
            null
        );

        $this->addCustomer(
            12,
            'Customer PSNMQ',
            'Ray, Mike',
            'Sales Agent',
            'Cerrito 3456',
            'Buenos Aires',
            null,
            '10057',
            'Argentina',
            '(1) 890-1234',
            null,
            null,
            '(1) 567-8901'
        );

        $this->addCustomer(
            13,
            'Customer VMLOG',
            'Benito, Almudena',
            'Marketing Manager',
            'Sierras de Granada 7890',
            'México D.F.',
            null,
            '10056',
            'Mexico',
            '(5) 456-7890',
            null,
            null,
            '(5) 123-4567'
        );

        $this->addCustomer(
            14,
            'Customer WNMAF',
            'Jelitto, Jacek',
            'Owner',
            'Hauptstr. 0123',
            'Bern',
            null,
            '10065',
            'Switzerland',
            '0452-678901',
            null,
            null,
            null
        );

        $this->addCustomer(
            15,
            'Customer JUWXK',
            'Richardson, Shawn',
            'Sales Associate',
            'Av. dos Lusíadas, 6789',
            'Sao Paulo',
            'SP',
            '10087',
            'Brazil',
            '(11) 012-3456',
            null,
            null,
            null
        );

        $this->addCustomer(
            16,
            'Customer GYBBY',
            'Birkby, Dana',
            'Sales Representative',
            'Berkeley Gardens 0123 Brewery',
            'London',
            null,
            '10039',
            'UK',
            '(171) 234-5678',
            null,
            null,
            '(171) 234-5679'
        );

        $this->addCustomer(
            17,
            'Customer FEVNN',
            'Jones, TiAnna',
            'Order Administrator',
            'Walserweg 4567',
            'Aachen',
            null,
            '10067',
            'Germany',
            '0241-789012',
            null,
            null,
            '0241-345678'
        );

        $this->addCustomer(
            18,
            'Customer BSVAR',
            'Rizaldy, Arif',
            'Owner',
            '3456, rue des Cinquante Otages',
            'Nantes',
            null,
            '10041',
            'France',
            '89.01.23.45',
            null,
            null,
            '89.01.23.46'
        );

        $this->addCustomer(
            19,
            'Customer RFNQC',
            'Boseman, Randall',
            'Sales Agent',
            '5678 King George',
            'London',
            null,
            '10110',
            'UK',
            '(171) 345-6789',
            null,
            null,
            '(171) 345-6780'
        );

        $this->addCustomer(
            20,
            'Customer THHDP',
            'Kane, John',
            'Sales Manager',
            'Kirchgasse 9012',
            'Graz',
            null,
            '10059',
            'Austria',
            '1234-5678',
            null,
            null,
            '9012-3456'
        );

        $this->addCustomer(
            21,
            'Customer KIdPX',
            'Russo, Giuseppe',
            'Marketing Assistant',
            'Rua Orós, 3456',
            'Sao Paulo',
            'SP',
            '10096',
            'Brazil',
            '(11) 456-7890',
            null,
            null,
            null
        );

        $this->addCustomer(
            22,
            'Customer DTDMN',
            'Bueno, Janaina Burdan, Neville',
            'Accounting Manager',
            'C/ Moralzarzal, 5678',
            'Madrid',
            null,
            '10080',
            'Spain',
            '(91) 890 12 34',
            null,
            null,
            '(91) 567 89 01'
        );

        $this->addCustomer(
            23,
            'Customer WVFAF',
            'Khanna, Karan',
            'Assistant Sales Agent',
            '4567, chaussée de Tournai',
            'Lille',
            null,
            '10048',
            'France',
            '45.67.89.01',
            null,
            null,
            '45.67.89.02'
        );

        $this->addCustomer(
            24,
            'Customer CYZTN',
            'San Juan, Patricia',
            'Owner',
            'Åkergatan 5678',
            'Bräcke',
            null,
            '10114',
            'Sweden',
            '0695-67 89 01',
            null,
            null,
            null
        );

        $this->addCustomer(
            25,
            'Customer AZJED',
            'Carlson, Jason',
            'Marketing Manager',
            'Berliner Platz 9012',
            'München',
            null,
            '10091',
            'Germany',
            '089-8901234',
            null,
            null,
            '089-5678901'
        );

        $this->addCustomer(
            26,
            'Customer USDBG',
            'Koch, Paul',
            'Marketing Manager',
            '9012, rue Royale',
            'Nantes',
            null,
            '10101',
            'France',
            '34.56.78.90',
            null,
            null,
            '34.56.78.91'
        );

        $this->addCustomer(
            27,
            'Customer WMFEA',
            'Schmöllerl, Martin',
            'Sales Representative',
            'Via Monte Bianco 4567',
            'Torino',
            null,
            '10099',
            'Italy',
            '011-2345678',
            null,
            null,
            '011-9012345'
        );

        $this->addCustomer(
            28,
            'Customer XYUFB',
            'Cavaglieri, Giorgio',
            'Sales Manager',
            'Jardim das rosas n. 8901',
            'Lisboa',
            null,
            '10054',
            'Portugal',
            '(1) 456-7890',
            null,
            null,
            '(1) 123-4567'
        );

        $this->addCustomer(
            29,
            'Customer MDLWA',
            'Kolesnikova, Katerina',
            'Marketing Manager',
            'Rambla de Cataluña, 8901',
            'Barcelona',
            null,
            '10081',
            'Spain',
            '(93) 789 0123',
            null,
            null,
            '(93) 456 7890'
        );

        $this->addCustomer(
            30,
            'Customer KSLQF',
            'Shabalin, Rostislav',
            'Sales Manager',
            'C/ Romero, 1234',
            'Sevilla',
            null,
            '10075',
            'Spain',
            '(95) 901 23 45',
            null,
            null,
            null
        );

        $this->addCustomer(
            31,
            'Customer YJCBX',
            'Cheng, Yao-Qiang',
            'Sales Associate',
            'Av. Brasil, 5678',
            'Campinas',
            'SP',
            '10128',
            'Brazil',
            '(11) 567-8901',
            null,
            null,
            null
        );

        $this->addCustomer(
            32,
            'Customer YSIQX',
            'Krishnan, Venky',
            'Marketing Manager',
            '6789 Baker Blvd.',
            'Eugene',
            'OR',
            '10070',
            'USA',
            '(503) 555-0122',
            null,
            null,
            null
        );

        $this->addCustomer(
            33,
            'Customer FVXPQ',
            'Sigurdarson, Hallur ',
            'Owner',
            '5ª Ave. Los Palos Grandes 3456',
            'Caracas',
            'DF',
            '10043',
            'Venezuela',
            '(2) 789-0123',
            null,
            null,
            '(2) 456-7890'
        );

        $this->addCustomer(
            34,
            'Customer IBVRG',
            'Cohen, Shy',
            'Accounting Manager',
            'Rua do Paço, 7890',
            'Rio de Janeiro',
            'RJ',
            '10076',
            'Brazil',
            '(21) 789-0123',
            null,
            null,
            '(21) 789-0124'
        );

        $this->addCustomer(
            35,
            'Customer UMTLM',
            'Langohr, Kris',
            'Sales Representative',
            'Carrera 1234 con Ave. Carlos Soublette #8-35',
            'San Cristóbal',
            'Táchira',
            '10066',
            'Venezuela',
            '(5) 567-8901',
            null,
            null,
            '(5) 234-5678'
        );

        $this->addCustomer(
            36,
            'Customer LVJSO',
            'Smith, Denise',
            'Sales Representative',
            'City Center Plaza 2345 Main St.',
            'Elgin',
            'OR',
            '10103',
            'USA',
            '(503) 555-0126',
            null,
            null,
            '(503) 555-0135'
        );

        $this->addCustomer(
            37,
            'Customer FRXZL',
            'Crăciun, Ovidiu V.',
            'Sales Associate',
            '9012 Johnstown Road',
            'Cork',
            'Co. Cork',
            '10051',
            'Ireland',
            '8901 234',
            null,
            null,
            '5678 9012'
        );

        $this->addCustomer(
            38,
            'Customer LJUCA',
            'Lee, Frank',
            'Marketing Manager',
            'Garden House Crowther Way 3456',
            'Cowes',
            'Isle of Wight',
            '10063',
            'UK',
            '(198) 567-8901',
            null,
            null,
            null
        );

        $this->addCustomer(
            39,
            'Customer GLLAG',
            'Song, Lolan',
            'Sales Associate',
            'Maubelstr. 8901',
            'Brandenburg',
            null,
            '10060',
            'Germany',
            '0555-34567',
            null,
            null,
            null
        );

        $this->addCustomer(
            40,
            'Customer EFFTC',
            'De Oliveira, Jose',
            'Sales Representative',
            '2345, avenue de l\'Europe',
            'Versailles',
            null,
            '10108',
            'France',
            '12.34.56.78',
            null,
            null,
            '12.34.56.79'
        );

        $this->addCustomer(
            41,
            'Customer XIIWM',
            'Litton, Tim',
            'Sales Manager',
            '3456 rue Alsace-Lorraine',
            'Toulouse',
            null,
            '10053',
            'France',
            '90.12.34.56',
            null,
            null,
            '90.12.34.57'
        );

        $this->addCustomer(
            42,
            'Customer IAIJK',
            'Steiner, Dominik',
            'Marketing Assistant',
            '2345 Oak St.',
            'Vancouver',
            'BC',
            '10098',
            'Canada',
            '(604) 567-8901',
            null,
            null,
            '(604) 234-5678'
        );

        $this->addCustomer(
            43,
            'Customer UISOJ',
            'Deshpande, Anu',
            'Marketing Manager',
            '8901 Orchestra Terrace',
            'Walla Walla',
            'WA',
            '10069',
            'USA',
            '(509) 555-0119',
            null,
            null,
            '(509) 555-0130'
        );

        $this->addCustomer(
            44,
            'Customer OXFRU',
            'Louverdis, George',
            'Sales Representative',
            'Magazinweg 8901',
            'Frankfurt a.M.',
            null,
            '10095',
            'Germany',
            '069-7890123',
            null,
            null,
            '069-4567890'
        );

        $this->addCustomer(
            45,
            'Customer QXPPT',
            'Sunkammurali,  Krishna',
            'Owner',
            '1234 Polk St. Suite 5',
            'San Francisco',
            'CA',
            '10062',
            'USA',
            '(415) 555-0118',
            null,
            null,
            null
        );

        $this->addCustomer(
            46,
            'Customer XPNIK',
            'Dressler, Marlies',
            'Accounting Manager',
            'Carrera 7890 con Ave. Bolívar #65-98 Llano Largo',
            'Barquisimeto',
            'Lara',
            '10093',
            'Venezuela',
            '(9) 789-0123',
            null,
            null,
            '(9) 456-7890'
        );

        $this->addCustomer(
            47,
            'Customer PSQUZ',
            'Lupu, Cornel',
            'Owner',
            'Ave. 5 de Mayo Porlamar 5678',
            'I. de Margarita',
            'Nueva Esparta',
            '10121',
            'Venezuela',
            '(8) 01-23-45',
            null,
            null,
            '(8) 67-89-01'
        );

        $this->addCustomer(
            48,
            'Customer DVFMB',
            'Szymczak, Radosław',
            'Sales Manager',
            '9012 Chiaroscuro Rd.',
            'Portland',
            'OR',
            '10073',
            'USA',
            '(503) 555-0117',
            null,
            null,
            '(503) 555-0129'
        );

        $this->addCustomer(
            49,
            'Customer CQRAA',
            'Duerr, Bernard',
            'Marketing Manager',
            'Via Ludovico il Moro 6789',
            'Bergamo',
            null,
            '10106',
            'Italy',
            '035-345678',
            null,
            null,
            '035-901234'
        );

        $this->addCustomer(
            50,
            'Customer JYPSC',
            'Mace, Donald',
            'Sales Agent',
            'Rue Joseph-Bens 0123',
            'Bruxelles',
            null,
            '10074',
            'Belgium',
            '(02) 890 12 34',
            null,
            null,
            '(02) 567 89 01'
        );

        $this->addCustomer(
            51,
            'Customer PVDZC',
            'Taylor, Maurice',
            'Marketing Assistant',
            '8901 rue St. Laurent',
            'Montréal',
            'Québec',
            '10040',
            'Canada',
            '(514) 345-6789',
            null,
            null,
            '(514) 012-3456'
        );

        $this->addCustomer(
            52,
            'Customer PZNLA',
            'Dupont-Roc, Patrice',
            'Marketing Assistant',
            'Heerstr. 4567',
            'Leipzig',
            null,
            '10125',
            'Germany',
            '0342-12345',
            null,
            null,
            null
        );

        $this->addCustomer(
            53,
            'Customer GCJSG',
            'Mallit, Ken',
            'Sales Associate',
            'South House 1234 Queensbridge',
            'London',
            null,
            '10061',
            'UK',
            '(171) 890-1234',
            null,
            null,
            '(171) 890-1235'
        );

        $this->addCustomer(
            54,
            'Customer TDKEG',
            'Tiano, Mike',
            'Sales Agent',
            'Ing. Gustavo Moncada 0123 Piso 20-A',
            'Buenos Aires',
            null,
            '10094',
            'Argentina',
            '(1) 123-4567',
            null,
            null,
            '(1) 890-1234'
        );

        $this->addCustomer(
            55,
            'Customer KZQZT',
            'Egelund-Muller, Anja',
            'Sales Representative',
            '7890 Bering St.',
            'Anchorage',
            'AK',
            '10050',
            'USA',
            '(907) 555-0115',
            null,
            null,
            '(907) 555-0128'
        );

        $this->addCustomer(
            56,
            'Customer QNIVZ',
            'Marinova, Nadejda',
            'Owner',
            'Mehrheimerstr. 9012',
            'Köln',
            null,
            '10047',
            'Germany',
            '0221-0123456',
            null,
            null,
            '0221-7890123'
        );

        $this->addCustomer(
            57,
            'Customer WVAXS',
            'Tollevsen, Bjørn',
            'Owner',
            '5678, boulevard Charonne',
            'Paris',
            null,
            '10085',
            'France',
            '(1) 89.01.23.45',
            null,
            null,
            '(1) 89.01.23.46'
        );

        $this->addCustomer(
            58,
            'Customer AHXHT',
            'Fakhouri, Fadi',
            'Sales Representative',
            'Calle Dr. Jorge Cash 8901',
            'México D.F.',
            null,
            '10116',
            'Mexico',
            '(5) 890-1234',
            null,
            null,
            '(5) 567-8901'
        );

        $this->addCustomer(
            59,
            'Customer LOLJO',
            'Meston, Tosh',
            'Sales Manager',
            'Geislweg 2345',
            'Salzburg',
            null,
            '10127',
            'Austria',
            '4567-8901',
            null,
            null,
            '2345-6789'
        );

        $this->addCustomer(
            60,
            'Customer QZURI',
            'Uppal, Sunil',
            'Sales Representative',
            'Estrada da saúde n. 6789',
            'Lisboa',
            null,
            '10083',
            'Portugal',
            '(1) 789-0123',
            null,
            null,
            null
        );

        $this->addCustomer(
            61,
            'Customer WULWD',
            'Florczyk, Krzysztof',
            'Accounting Manager',
            'Rua da Panificadora, 1234',
            'Rio de Janeiro',
            'RJ',
            '10115',
            'Brazil',
            '(21) 678-9012',
            null,
            null,
            '(21) 678-9013'
        );

        $this->addCustomer(
            62,
            'Customer WFIZJ',
            'Misiec, Anna',
            'Marketing Assistant',
            'Alameda dos Canàrios, 1234',
            'Sao Paulo',
            'SP',
            '10102',
            'Brazil',
            '(11) 901-2345',
            null,
            null,
            null
        );

        $this->addCustomer(
            63,
            'Customer IRRVL',
            'Veronesi, Giorgio',
            'Accounting Manager',
            'Taucherstraße 1234',
            'Cunewalde',
            null,
            '10126',
            'Germany',
            '0372-12345',
            null,
            null,
            null
        );

        $this->addCustomer(
            64,
            'Customer LWGMD',
            'Gaffney, Lawrie',
            'Sales Representative',
            'Av. del Libertador 3456',
            'Buenos Aires',
            null,
            '10124',
            'Argentina',
            '(1) 234-5678',
            null,
            null,
            '(1) 901-2345'
        );

        $this->addCustomer(
            65,
            'Customer NYUHS',
            'Moore, Michael',
            'Assistant Sales Representative',
            '6789 Milton Dr.',
            'Albuquerque',
            'NM',
            '10109',
            'USA',
            '(505) 555-0125',
            null,
            null,
            '(505) 555-0134'
        );

        $this->addCustomer(
            66,
            'Customer LHANT',
            'Voss, Florian',
            'Sales Associate',
            'Strada Provinciale 7890',
            'Reggio Emilia',
            null,
            '10038',
            'Italy',
            '0522-012345',
            null,
            null,
            '0522-678901'
        );

        $this->addCustomer(
            67,
            'Customer QVEPD',
            'Garden, Euan',
            'Assistant Sales Agent',
            'Av. Copacabana, 6789',
            'Rio de Janeiro',
            'RJ',
            '10052',
            'Brazil',
            '(21) 345-6789',
            null,
            null,
            null
        );

        $this->addCustomer(
            68,
            'Customer CCKOT',
            'Myrcha, Jacek',
            'Sales Manager',
            'Grenzacherweg 0123',
            'Genève',
            null,
            '10122',
            'Switzerland',
            '0897-012345',
            null,
            null,
            null
        );

        $this->addCustomer(
            69,
            'Customer SIUIH',
            'Watters, Jason M.',
            'Accounting Manager',
            'Gran Vía, 4567',
            'Madrid',
            null,
            '10071',
            'Spain',
            '(91) 567 8901',
            null,
            null,
            '(91) 234 5678'
        );

        $this->addCustomer(
            70,
            'Customer TMXGN',
            'Ginters, Kaspars',
            'Owner',
            'Erling Skakkes gate 2345',
            'Stavern',
            null,
            '10123',
            'Norway',
            '07-89 01 23',
            null,
            null,
            '07-45 67 89'
        );

        $this->addCustomer(
            71,
            'Customer LCOUJ',
            'Navarro, Tomás',
            'Sales Representative',
            '9012 Suffolk Ln.',
            'Boise',
            'Id',
            '10078',
            'USA',
            '(208) 555-0116',
            null,
            null,
            null
        );

        $this->addCustomer(
            72,
            'Customer AHPOP',
            'Welcker, Brian',
            'Sales Manager',
            '4567 Wadhurst Rd.',
            'London',
            null,
            '10088',
            'UK',
            '(171) 901-2345',
            null,
            null,
            '(171) 901-2346'
        );

        $this->addCustomer(
            73,
            'Customer JMIKW',
            'Gonzalez, Nuria',
            'Owner',
            'Vinbæltet 3456',
            'Kobenhavn',
            null,
            '10079',
            'Denmark',
            '12 34 56 78',
            null,
            null,
            '90 12 34 56'
        );

        $this->addCustomer(
            74,
            'Customer YSHXL',
            'O’Brien, Dave',
            'Marketing Manager',
            '9012, rue Lauriston',
            'Paris',
            null,
            '10058',
            'France',
            '(1) 23.45.67.89',
            null,
            null,
            '(1) 23.45.67.80'
        );

        $this->addCustomer(
            75,
            'Customer XOJYP',
            'Wojciechowska, Agnieszka',
            'Sales Manager',
            'P.O. Box 1234',
            'Lander',
            'WY',
            '10113',
            'USA',
            '(307) 555-0114',
            null,
            null,
            '(307) 555-0127'
        );

        $this->addCustomer(
            76,
            'Customer SFOGW',
            'Gulbis, Katrin',
            'Accounting Manager',
            'Boulevard Tirou, 2345',
            'Charleroi',
            null,
            '10100',
            'Belgium',
            '(071) 56 78 90 12',
            null,
            null,
            '(071) 34 56 78 90'
        );

        $this->addCustomer(
            77,
            'Customer LCYBZ',
            'Osorio, Cristian',
            'Marketing Manager',
            '2345 Jefferson Way Suite 2',
            'Portland',
            'OR',
            '10042',
            'USA',
            '(503) 555-0120',
            null,
            null,
            null
        );

        $this->addCustomer(
            78,
            'Customer NLTYP',
            'Young, Robin',
            'Marketing Assistant',
            '0123 Grizzly Peak Rd.',
            'Butte',
            'MT',
            '10107',
            'USA',
            '(406) 555-0121',
            null,
            null,
            '(406) 555-0131'
        );

        $this->addCustomer(
            79,
            'Customer FAPSM',
            'Wickham, Jim',
            'Marketing Manager',
            'Luisenstr. 0123',
            'Münster',
            null,
            '10118',
            'Germany',
            '0251-456789',
            null,
            null,
            '0251-012345'
        );

        $this->addCustomer(
            80,
            'Customer VONTK',
            'Geschwandtner, Jens',
            'Owner',
            'Avda. Azteca 4567',
            'México D.F.',
            null,
            '10044',
            'Mexico',
            '(5) 678-9012',
            null,
            null,
            null
        );

        $this->addCustomer(
            81,
            'Customer YQQWW',
            'Nagel, Jean-Philippe',
            'Sales Representative',
            'Av. Inês de Castro, 1234',
            'Sao Paulo',
            'SP',
            '10120',
            'Brazil',
            '(11) 123-4567',
            null,
            null,
            '(11) 234-5678'
        );

        $this->addCustomer(
            82,
            'Customer EYHKM',
            'Veninga, Tjeerd',
            'Sales Associate',
            '1234 DaVinci Blvd.',
            'Kirkland',
            'WA',
            '10119',
            'USA',
            '(206) 555-0124',
            null,
            null,
            '(206) 555-0133'
        );

        $this->addCustomer(
            83,
            'Customer ZRNDE',
            'Fonteneau, Karl',
            'Sales Manager',
            'Smagsloget 3456',
            'Århus',
            null,
            '10090',
            'Denmark',
            '23 45 67 89',
            null,
            null,
            '01 23 45 67'
        );

        $this->addCustomer(
            84,
            'Customer NRCSK',
            'Tuntisangaroon, Sittichai',
            'Sales Agent',
            '6789, rue du Commerce',
            'Lyon',
            null,
            '10072',
            'France',
            '78.90.12.34',
            null,
            null,
            '78.90.12.35'
        );

        $this->addCustomer(
            85,
            'Customer ENQZT',
            'McLin, Nkenge',
            'Accounting Manager',
            '5678 rue de l\'Abbaye',
            'Reims',
            null,
            '10082',
            'France',
            '56.78.90.12',
            null,
            null,
            '56.78.90.13'
        );

        $this->addCustomer(
            86,
            'Customer SNXOJ',
            'Syamala, Manoj',
            'Sales Representative',
            'Adenauerallee 7890',
            'Stuttgart',
            null,
            '10086',
            'Germany',
            '0711-345678',
            null,
            null,
            '0711-901234'
        );

        $this->addCustomer(
            87,
            'Customer ZHYOS',
            'Ludwig, Michael',
            'Accounting Manager',
            'Torikatu 9012',
            'Oulu',
            null,
            '10045',
            'Finland',
            '981-123456',
            null,
            null,
            '981-789012'
        );

        $this->addCustomer(
            88,
            'Customer SRQVM',
            'Li, Yan',
            'Sales Manager',
            'Rua do Mercado, 4567',
            'Resende',
            'SP',
            '10084',
            'Brazil',
            '(14) 234-5678',
            null,
            null,
            null
        );

        $this->addCustomer(
            89,
            'Customer YBQTI',
            'Smith Jr., Ronaldo',
            'Owner',
            '8901 - 14th Ave. S. Suite 3B',
            'Seattle',
            'WA',
            '10049',
            'USA',
            '(206) 555-0123',
            null,
            null,
            '(206) 555-0132'
        );

        $this->addCustomer(
            90,
            'Customer XBBVR',
            'Larsson, Katarina',
            'Owner/Marketing Assistant',
            'Keskuskatu 2345',
            'Helsinki',
            null,
            '10055',
            'Finland',
            '90-012 3456',
            null,
            null,
            '90-789 0123'
        );

        $this->addCustomer(
            91,
            'Customer CCFIZ',
            'Conn, Steve',
            'Owner',
            'ul. Filtrowa 6789',
            'Warszawa',
            null,
            '10068',
            'Poland',
            '(26) 234-5678',
            null,
            null,
            '(26) 901-2345'
        );

    }

    private function addEmployee(
        $employeeId,
        $lastname,
        $firstname,
        $title,
        $titleOfCourtesy,
        $birthDate,
        $hireDate,
        $address,
        $city,
        $region,
        $postalCode,
        $country,
        $phone,
        $extension,
        $mobile,
        $email,
        $photo,
        $notes,
        $mgrId,
        $photoPath
    ) {
        Capsule::table($this->employees)->updateOrInsert(
            ['employeeId' => $employeeId],
            [
                'lastname'        => $lastname,
                'firstname'       => $firstname,
                'title'           => $title,
                'titleOfCourtesy' => $titleOfCourtesy,
                'birthDate'       => $birthDate,
                'hireDate'        => $this->getRandomDate(),
                'address'         => $address,
                'city'            => $city,
                'region'          => $region,
                'postalCode'      => $postalCode,
                'country'         => $country,
                'phone'           => $phone,
                'extension'       => $extension,
                'mobile'          => $mobile,
                'email'           => $email,
                'photo'           => $photo,
                'notes'           => $notes,
                'mgrId'           => $mgrId,
                'photoPath'       => $photoPath,
                'created_at'      => $this->getRandomDate(),
                'updated_at'      => $this->getRandomDate()
            ]
        );

        return Capsule::table($this->employees)->where("employeeId", $employeeId)->first();
    }

    private function insertEmployees()
    {
        if(Capsule::table($this->employees)->count() !== 0)
            return;

        $this->addEmployee(
            1,
            'Davis',
            'Sara',
            'CEO',
            'Ms.',
            '1958-12-08 00:00:00',
            '2002-05-01 00:00:00',
            '7890 - 20th Ave. E., Apt. 2A',
            'Seattle',
            'WA',
            '10003',
            'USA',
            '(206) 555-0101',
            null,
            null,
            null,
            null,
            null,
            null,
            null
        );

        $this->addEmployee(
            2,
            'Funk',
            'Don',
            'Vice President, Sales',
            'Dr.',
            '1962-02-19 00:00:00',
            '2002-08-14 00:00:00',
            '9012 W. Capital Way',
            'Tacoma',
            'WA',
            '10001',
            'USA',
            '(206) 555-0100',
            null,
            null,
            null,
            null,
            null,
            1,
            null
        );

        $this->addEmployee(
            3,
            'Lew',
            'Judy',
            'Sales Manager',
            'Ms.',
            '1973-08-30 00:00:00',
            '2002-04-01 00:00:00',
            '2345 Moss Bay Blvd.',
            'Kirkland',
            'WA',
            '10007',
            'USA',
            '(206) 555-0103',
            null,
            null,
            null,
            null,
            null,
            2,
            null
        );

        $this->addEmployee(
            4,
            'Peled',
            'Yael',
            'Sales Representative',
            'Mrs.',
            '1947-09-19 00:00:00',
            '2003-05-03 00:00:00',
            '5678 Old Redmond Rd.',
            'Redmond',
            'WA',
            '10009',
            'USA',
            '(206) 555-0104',
            null,
            null,
            null,
            null,
            null,
            3,
            null
        );

        $this->addEmployee(
            5,
            'Buck',
            'Sven',
            'Sales Manager',
            'Mr.',
            '1965-03-04 00:00:00',
            '2003-10-17 00:00:00',
            '8901 Garrett Hill',
            'London',
            null,
            '10004',
            'UK',
            '(71) 234-5678',
            null,
            null,
            null,
            null,
            null,
            2,
            null
        );

        $this->addEmployee(
            6,
            'Suurs',
            'Paul',
            'Sales Representative',
            'Mr.',
            '1973-07-02 00:00:00',
            '2003-10-17 00:00:00',
            '3456 Coventry House, Miner Rd.',
            'London',
            null,
            '10005',
            'UK',
            '(71) 345-6789',
            null,
            null,
            null,
            null,
            null,
            5,
            null
        );

        $this->addEmployee(
            7,
            'King',
            'Russell',
            'Sales Representative',
            'Mr.',
            '1970-05-29 00:00:00',
            '2004-01-02 00:00:00',
            '6789 Edgeham Hollow, Winchester Way',
            'London',
            null,
            '10002',
            'UK',
            '(71) 123-4567',
            null,
            null,
            null,
            null,
            null,
            5,
            null
        );

        $this->addEmployee(
            8,
            'Cameron',
            'Maria',
            'Sales Representative',
            'Ms.',
            '1968-01-09 00:00:00',
            '2004-03-05 00:00:00',
            '4567 - 11th Ave. N.E.',
            'Seattle',
            'WA',
            '10006',
            'USA',
            '(206) 555-0102',
            null,
            null,
            null,
            null,
            null,
            3,
            null
        );

        $this->addEmployee(
            9,
            'Dolgopyatova',
            'Zoya',
            'Sales Representative',
            'Ms.',
            '1976-01-27 00:00:00',
            '2004-11-15 00:00:00',
            '1234 Houndstooth Rd.',
            'London',
            null,
            '10008',
            'UK',
            '(71) 456-7890',
            null,
            null,
            null,
            null,
            null,
            5,
            null
        );

    }

    private function addSupplier(
        $supplierId,
        $companyName,
        $contactName,
        $contactTitle,
        $address,
        $city,
        $region,
        $postalCode,
        $country,
        $phone,
        $email,
        $fax,
        $HomePage
    ) {
        Capsule::table($this->suppliers)->updateOrInsert(
            ['supplierId' => $supplierId],
            [
                'companyName'  => $companyName,
                'contactName'  => $contactName,
                'contactTitle' => $contactTitle,
                'address'      => $address,
                'city'         => $city,
                'region'       => $region,
                'postalCode'   => $postalCode,
                'country'      => $country,
                'phone'        => $phone,
                'email'        => $email,
                'fax'          => $fax,
                'HomePage'     => $HomePage,
                'created_at'   => $this->getRandomDate(),
                'updated_at'   => $this->getRandomDate()

            ]
        );

        return Capsule::table($this->suppliers)->where("supplierId", $supplierId)->first();
    }

    private function insertSuppliers()
    {

        if(Capsule::table($this->suppliers)->count() !== 0)
            return;

        $this->addSupplier(
            1,
            'Supplier SWRXU',
            'Adolphi, Stephan',
            'Purchasing Manager',
            '2345 Gilbert St.',
            'London',
            null,
            '10023',
            'UK',
            '(171) 456-7890',
            null,
            null,
            null
        );

        $this->addSupplier(
            2,
            'Supplier VHQZD',
            'Hance, Jim',
            'Order Administrator',
            'P.O. Box 5678',
            'New Orleans',
            'LA',
            '10013',
            'USA',
            '(100) 555-0111',
            null,
            null,
            null
        );

        $this->addSupplier(
            3,
            'Supplier STUAZ',
            'Parovszky, Alfons',
            'Sales Representative',
            '1234 Oxford Rd.',
            'Ann Arbor',
            'MI',
            '10026',
            'USA',
            '(313) 555-0109',
            null,
            '(313) 555-0112',
            null
        );

        $this->addSupplier(
            4,
            'Supplier QOVFD',
            'Balázs, Erzsébet',
            'Marketing Manager',
            '7890 Sekimai Musashino-shi',
            'Tokyo',
            null,
            '10011',
            'Japan',
            '(03) 6789-0123',
            null,
            null,
            null
        );

        $this->addSupplier(
            5,
            'Supplier EQPNC',
            'Holm, Michael',
            'Export Administrator',
            'Calle del Rosal 4567',
            'Oviedo',
            'Asturias',
            '10029',
            'Spain',
            '(98) 123 45 67',
            null,
            null,
            null
        );

        $this->addSupplier(
            6,
            'Supplier QWUSF',
            'Popkova, Darya',
            'Marketing Representative',
            '8901 Setsuko Chuo-ku',
            'Osaka',
            null,
            '10028',
            'Japan',
            '(06) 789-0123',
            null,
            null,
            null
        );

        $this->addSupplier(
            7,
            'Supplier GQRCV',
            'Ræbild, Jesper',
            'Marketing Manager',
            '5678 Rose St. Moonie Ponds',
            'Melbourne',
            'Victoria',
            '10018',
            'Australia',
            '(03) 123-4567',
            null,
            '(03) 456-7890',
            null
        );

        $this->addSupplier(
            8,
            'Supplier BWGYE',
            'Iallo, Lucio',
            'Sales Representative',
            '9012 King\'s Way',
            'Manchester',
            null,
            '10021',
            'UK',
            '(161) 567-8901',
            null,
            null,
            null
        );

        $this->addSupplier(
            9,
            'Supplier QQYEU',
            'Basalik, Evan',
            'Sales Agent',
            'Kaloadagatan 4567',
            'Göteborg',
            null,
            '10022',
            'Sweden',
            '031-345 67 89',
            null,
            '031-678 90 12',
            null
        );

        $this->addSupplier(
            10,
            'Supplier UNAHG',
            'Barnett, Dave',
            'Marketing Manager',
            'Av. das Americanas 2345',
            'Sao Paulo',
            null,
            '10034',
            'Brazil',
            '(11) 345 6789',
            null,
            null,
            null
        );

        $this->addSupplier(
            11,
            'Supplier ZPYVS',
            'Jain, Mukesh',
            'Sales Manager',
            'Tiergartenstraße 3456',
            'Berlin',
            null,
            '10016',
            'Germany',
            '(010) 3456789',
            null,
            null,
            null
        );

        $this->addSupplier(
            12,
            'Supplier SVIYA',
            'Regev, Barak',
            'International Marketing Mgr.',
            'Bogenallee 9012',
            'Frankfurt',
            null,
            '10024',
            'Germany',
            '(069) 234567',
            null,
            null,
            null
        );

        $this->addSupplier(
            13,
            'Supplier TEGSC',
            'Brehm, Peter',
            'Coordinator Foreign Markets',
            'Frahmredder 3456',
            'Cuxhaven',
            null,
            '10019',
            'Germany',
            '(04721) 1234',
            null,
            '(04721) 2345',
            null
        );

        $this->addSupplier(
            14,
            'Supplier KEREV',
            'Keil, Kendall',
            'Sales Representative',
            'Viale Dante, 6789',
            'Ravenna',
            null,
            '10015',
            'Italy',
            '(0544) 56789',
            null,
            '(0544) 34567',
            null
        );

        $this->addSupplier(
            15,
            'Supplier NZLIF',
            'Sałas-Szlejter, Karolina',
            'Marketing Manager',
            'Hatlevegen 1234',
            'Sandvika',
            null,
            '10025',
            'Norway',
            '(0)9-012345',
            null,
            null,
            null
        );

        $this->addSupplier(
            16,
            'Supplier UHZRG',
            'Scholl, Thorsten',
            'Regional Account Rep.',
            '8901 - 8th Avenue Suite 210',
            'Bend',
            'OR',
            '10035',
            'USA',
            '(503) 555-0108',
            null,
            null,
            null
        );

        $this->addSupplier(
            17,
            'Supplier QZGUF',
            'Kleinerman, Christian',
            'Sales Representative',
            'Brovallavägen 0123',
            'Stockholm',
            null,
            '10033',
            'Sweden',
            '08-234 56 78',
            null,
            null,
            null
        );

        $this->addSupplier(
            18,
            'Supplier LVJUA',
            'Canel, Fabrice',
            'Sales Manager',
            '3456, Rue des Francs-Bourgeois',
            'Paris',
            null,
            '10031',
            'France',
            '(1) 90.12.34.56',
            null,
            '(1) 01.23.45.67',
            null
        );

        $this->addSupplier(
            19,
            'Supplier JDNUG',
            'Chapman, Greg',
            'Wholesale Account Agent',
            'Order Processing Dept. 7890 Paul Revere Blvd.',
            'Boston',
            'MA',
            '10027',
            'USA',
            '(617) 555-0110',
            null,
            '(617) 555-0113',
            null
        );

        $this->addSupplier(
            20,
            'Supplier CIYNM',
            'Köszegi, Emília',
            'Owner',
            '6789 Serangoon Loop, Suite #402',
            'Singapore',
            null,
            '10037',
            'Singapore',
            '012-3456',
            null,
            null,
            null
        );

        $this->addSupplier(
            21,
            'Supplier XOXZA',
            'Shakespear, Paul',
            'Sales Manager',
            'Lyngbysild Fiskebakken 9012',
            'Lyngby',
            null,
            '10012',
            'Denmark',
            '67890123',
            null,
            '78901234',
            null
        );

        $this->addSupplier(
            22,
            'Supplier FNUXM',
            'Skelly, Bonnie L.',
            'Accounting Manager',
            'Verkoop Rijnweg 8901',
            'Zaandam',
            null,
            '10014',
            'Netherlands',
            '(12345) 8901',
            null,
            '(12345) 5678',
            null
        );

        $this->addSupplier(
            23,
            'Supplier ELCRN',
            'LaMee, Brian',
            'Product Manager',
            'Valtakatu 1234',
            'Lappeenranta',
            null,
            '10032',
            'Finland',
            '(953) 78901',
            null,
            null,
            null
        );

        $this->addSupplier(
            24,
            'Supplier JNNES',
            'Clark, Molly',
            'Sales Representative',
            '6789 Prince Edward Parade Hunter\'s Hill',
            'Sydney',
            'NSW',
            '10030',
            'Australia',
            '(02) 234-5678',
            null,
            '(02) 567-8901',
            null
        );

        $this->addSupplier(
            25,
            'Supplier ERVYZ',
            'Sprenger, Christof',
            'Marketing Manager',
            '7890 Rue St. Laurent',
            'Montréal',
            'Québec',
            '10017',
            'Canada',
            '(514) 456-7890',
            null,
            null,
            null
        );

        $this->addSupplier(
            26,
            'Supplier ZWZDM',
            'Cunha, Gonçalo',
            'Order Administrator',
            'Via dei Gelsomini, 5678',
            'Salerno',
            null,
            '10020',
            'Italy',
            '(089) 4567890',
            null,
            '(089) 4567890',
            null
        );

        $this->addSupplier(
            27,
            'Supplier ZRYDZ',
            'Leoni, Alessandro',
            'Sales Manager',
            '4567, rue H. Voiron',
            'Montceau',
            null,
            '10036',
            'France',
            '89.01.23.45',
            null,
            null,
            null
        );

        $this->addSupplier(
            28,
            'Supplier OAVQT',
            'Teper, Jeff',
            'Sales Representative',
            'Bat. B 2345, rue des Alpes',
            'Annecy',
            null,
            '10010',
            'France',
            '01.23.45.67',
            null,
            '89.01.23.45',
            null
        );

        $this->addSupplier(
            29,
            'Supplier OGLRK',
            'Walters, Rob',
            'Accounting Manager',
            '0123 rue Chasseur',
            'Ste-Hyacinthe',
            'Québec',
            '10009',
            'Canada',
            '(514) 567-890',
            null,
            '(514) 678-9012',
            null
        );

    }

    private function addRegion($regionId, $regiondescription)
    {
        Capsule::table($this->region)->updateOrInsert(
            ["regionId" => $regionId],
            [
                "regiondescription" => $regiondescription,
                'created_at'        => $this->getRandomDate(),
                'updated_at'        => $this->getRandomDate()
            ]
        );

        return Capsule::table($this->region)->where("regionId", $regionId)->first();
    }

    private function insertRegions()
    {
        $this->addRegion(1, 'Eastern');
        $this->addRegion(2, 'Western');
        $this->addRegion(3, 'Northern');
        $this->addRegion(4, 'Southern');
    }

    private function addTerritory(
        $territoryId,
        $territorydescription,
        $regionId
    ) {
        Capsule::table($this->territory)->updateOrInsert(
            ["territoryId" => $territoryId],
            [
                "territorydescription" => $territorydescription,
                "regionId"             => $regionId,
                'created_at'           => $this->getRandomDate(),
                'updated_at'           => $this->getRandomDate()
            ]
        );

        return Capsule::table($this->territory)->where("territoryId", $territoryId)->first();

    }

    private function insertTerritories()
    {
        $this->addTerritory(
            '01581',
            'Westboro',
            1
        );

        $this->addTerritory(
            '01730',
            'Bedford',
            1
        );

        $this->addTerritory(
            '01833',
            'Georgetow',
            1
        );

        $this->addTerritory(
            '02116',
            'Boston',
            1
        );

        $this->addTerritory(
            '02139',
            'Cambridge',
            1
        );

        $this->addTerritory(
            '02184',
            'Braintree',
            1
        );

        $this->addTerritory(
            '02903',
            'Providence',
            1
        );

        $this->addTerritory(
            '03049',
            'Hollis',
            3
        );

        $this->addTerritory(
            '03801',
            'Portsmouth',
            3
        );

        $this->addTerritory(
            '06897',
            'Wilton',
            1
        );

        $this->addTerritory(
            '07960',
            'Morristown',
            1
        );

        $this->addTerritory(
            '08837',
            'Edison',
            1
        );

        $this->addTerritory(
            '10019',
            'New York',
            1
        );

        $this->addTerritory(
            '10038',
            'New York',
            1
        );

        $this->addTerritory(
            '11747',
            'Mellvile',
            1
        );

        $this->addTerritory(
            '14450',
            'Fairport',
            1
        );

        $this->addTerritory(
            '19428',
            'Philadelphia',
            3
        );

        $this->addTerritory(
            '19713',
            'Neward',
            1
        );

        $this->addTerritory(
            '20852',
            'Rockville',
            1
        );

        $this->addTerritory(
            '27403',
            'Greensboro',
            1
        );

        $this->addTerritory(
            '27511',
            'Cary',
            1
        );

        $this->addTerritory(
            '29202',
            'Columbia',
            4
        );

        $this->addTerritory(
            '30346',
            'Atlanta',
            4
        );

        $this->addTerritory(
            '31406',
            'Savannah',
            4
        );

        $this->addTerritory(
            '32859',
            'Orlando',
            4
        );

        $this->addTerritory(
            '33607',
            'Tampa',
            4
        );

        $this->addTerritory(
            '40222',
            'Louisville',
            1
        );

        $this->addTerritory(
            '44122',
            'Beachwood',
            3
        );

        $this->addTerritory(
            '45839',
            'Findlay',
            3
        );

        $this->addTerritory(
            '48075',
            'Southfield',
            3
        );

        $this->addTerritory(
            '48084',
            'Troy',
            3
        );

        $this->addTerritory(
            '48304',
            'Bloomfield Hills',
            3
        );

        $this->addTerritory(
            '53404',
            'Racine',
            3
        );

        $this->addTerritory(
            '55113',
            'Roseville',
            3
        );

        $this->addTerritory(
            '55439',
            'Minneapolis',
            3
        );

        $this->addTerritory(
            '60179',
            'Hoffman Estates',
            2
        );

        $this->addTerritory(
            '60601',
            'Chicago',
            2
        );

        $this->addTerritory(
            '72716',
            'Bentonville',
            4
        );

        $this->addTerritory(
            '75234',
            'Dallas',
            4
        );

        $this->addTerritory(
            '78759',
            'Austin',
            4
        );

        $this->addTerritory(
            '80202',
            'Denver',
            2
        );

        $this->addTerritory(
            '80909',
            'Colorado Springs',
            2
        );

        $this->addTerritory(
            '85014',
            'Phoenix',
            2
        );

        $this->addTerritory(
            '85251',
            'Scottsdale',
            2
        );

        $this->addTerritory(
            '90405',
            'Santa Monica',
            2
        );

        $this->addTerritory(
            '94025',
            'Menlo Park',
            2
        );

        $this->addTerritory(
            '94105',
            'San Francisco',
            2
        );

        $this->addTerritory(
            '95008',
            'Campbell',
            2
        );

        $this->addTerritory(
            '95054',
            'Santa Clara',
            2
        );

        $this->addTerritory(
            '95060',
            'Santa Cruz',
            2
        );

        $this->addTerritory(
            '98004',
            'Bellevue',
            2
        );

        $this->addTerritory(
            '98052',
            'Redmond',
            2
        );

        $this->addTerritory(
            '98104',
            'Seattle',
            2
        );

    }

    private function addShipper(
        $shipperId,
        $companyName,
        $phone
    ) {
        Capsule::table($this->shipper)->updateOrInsert(
            ["shipperId" => $shipperId],
            [
                "companyName" => $companyName,
                "phone"       => $phone,
                'created_at'  => $this->getRandomDate(),
                'updated_at'  => $this->getRandomDate()

            ]
        );

        return Capsule::table($this->shipper)->where("shipperId", $shipperId)->first();

    }

    private function insertShippers()
    {

        $this->addShipper(
            1,
            'Shipper GVSUA',
            '(503) 555-0137'
        );

        $this->addShipper(
            2,
            'Shipper ETYNR',
            '(425) 555-0136'
        );

        $this->addShipper(
            3,
            'Shipper ZHISN',
            '(415) 555-0138'
        );

    }

    private function addProduct(
        $productId,
        $productName,
        $supplierId,
        $categoryId,
        $quantityPerUnit,
        $unitPrice,
        $unitsInStock,
        $unitsOnOrder,
        $reorderLevel,
        $discontinued
    ) {
        $countries = ["USA", "UK", "France", "Italy"];

        Capsule::table($this->product)->updateOrInsert(
            ["productId" => $productId],
            [
                "productName"     => $productName,
                "supplierId"      => $supplierId,
                "categoryId"      => $categoryId,
                "quantityPerUnit" => $quantityPerUnit,
                "unitPrice"       => $unitPrice,
                "unitsInStock"    => mt_rand(1, 100),
                "unitsOnOrder"    => $unitsOnOrder,
                "reorderLevel"    => $reorderLevel,
                "discontinued"    => $discontinued,
                "made_in"         => $countries[array_rand($countries)],
                "paid"            => mt_rand(10000, 900000),
                'created_at'      => $this->getRandomDate(),
                'updated_at'      => $this->getRandomDate()
            ]
        );

        return Capsule::table($this->product)->where("productId", $productId)->first();

    }

    private function insertProducts()
    {
        if(Capsule::table($this->product)->count() !== 0)
            return;

        $this->addProduct(
            1,
            'Product HHYDP',
            1,
            1,
            null,
            '18.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            2,
            'Product RECZE',
            1,
            1,
            null,
            '19.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            3,
            'Product IMEHJ',
            1,
            2,
            null,
            '10.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            4,
            'Product KSBRM',
            2,
            2,
            null,
            '22.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            5,
            'Product EPEIM',
            2,
            2,
            null,
            '21.35',
            null,
            null,
            null,
            '1'
        );

        $this->addProduct(
            6,
            'Product VAIIV',
            3,
            2,
            null,
            '25.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            7,
            'Product HMLNI',
            3,
            7,
            null,
            '30.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            8,
            'Product WVJFP',
            3,
            2,
            null,
            '40.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            9,
            'Product AOZBW',
            4,
            6,
            null,
            '97.00',
            null,
            null,
            null,
            '1'
        );

        $this->addProduct(
            10,
            'Product YHXGE',
            4,
            8,
            null,
            '31.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            11,
            'Product QMVUN',
            5,
            4,
            null,
            '21.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            12,
            'Product OSFNS',
            5,
            4,
            null,
            '38.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            13,
            'Product POXFU',
            6,
            8,
            null,
            '6.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            14,
            'Product PWCJB',
            6,
            7,
            null,
            '23.25',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            15,
            'Product KSZOI',
            6,
            2,
            null,
            '15.50',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            16,
            'Product PAFRH',
            7,
            3,
            null,
            '17.45',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            17,
            'Product BLCAX',
            7,
            6,
            null,
            '39.00',
            null,
            null,
            null,
            '1'
        );

        $this->addProduct(
            18,
            'Product CKEDC',
            7,
            8,
            null,
            '62.50',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            19,
            'Product XKXDO',
            8,
            3,
            null,
            '9.20',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            20,
            'Product QHFFP',
            8,
            3,
            null,
            '81.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            21,
            'Product VJZZH',
            8,
            3,
            null,
            '10.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            22,
            'Product CPHFY',
            9,
            5,
            null,
            '21.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            23,
            'Product JLUDZ',
            9,
            5,
            null,
            '9.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            24,
            'Product QOGNU',
            10,
            1,
            null,
            '4.50',
            null,
            null,
            null,
            '1'
        );

        $this->addProduct(
            25,
            'Product LYLNI',
            11,
            3,
            null,
            '14.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            26,
            'Product HLGZA',
            11,
            3,
            null,
            '31.23',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            27,
            'Product SMIOH',
            11,
            3,
            null,
            '43.90',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            28,
            'Product OFBNT',
            12,
            7,
            null,
            '45.60',
            null,
            null,
            null,
            '1'
        );

        $this->addProduct(
            29,
            'Product VJXYN',
            12,
            6,
            null,
            '123.79',
            null,
            null,
            null,
            '1'
        );

        $this->addProduct(
            30,
            'Product LYERX',
            13,
            8,
            null,
            '25.89',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            31,
            'Product XWOXC',
            14,
            4,
            null,
            '12.50',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            32,
            'Product NUNAW',
            14,
            4,
            null,
            '32.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            33,
            'Product ASTMN',
            15,
            4,
            null,
            '2.50',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            34,
            'Product SWNJY',
            16,
            1,
            null,
            '14.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            35,
            'Product NEVTJ',
            16,
            1,
            null,
            '18.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            36,
            'Product GMKIJ',
            17,
            8,
            null,
            '19.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            37,
            'Product EVFFA',
            17,
            8,
            null,
            '26.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            38,
            'Product QDOMO',
            18,
            1,
            null,
            '263.50',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            39,
            'Product LSOFL',
            18,
            1,
            null,
            '18.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            40,
            'Product YZIXQ',
            19,
            8,
            null,
            '18.40',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            41,
            'Product TTEEX',
            19,
            8,
            null,
            '9.65',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            42,
            'Product RJVNM',
            20,
            5,
            null,
            '14.00',
            null,
            null,
            null,
            '1'
        );

        $this->addProduct(
            43,
            'Product ZZZHR',
            20,
            1,
            null,
            '46.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            44,
            'Product VJIEO',
            20,
            2,
            null,
            '19.45',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            45,
            'Product AQOKR',
            21,
            8,
            null,
            '9.50',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            46,
            'Product CBRRL',
            21,
            8,
            null,
            '12.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            47,
            'Product EZZPR',
            22,
            3,
            null,
            '9.50',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            48,
            'Product MYNXN',
            22,
            3,
            null,
            '12.75',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            49,
            'Product FPYPN',
            23,
            3,
            null,
            '20.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            50,
            'Product BIUDV',
            23,
            3,
            null,
            '16.25',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            51,
            'Product APITJ',
            24,
            7,
            null,
            '53.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            52,
            'Product QSRXF',
            24,
            5,
            null,
            '7.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            53,
            'Product BKGEA',
            24,
            6,
            null,
            '32.80',
            null,
            null,
            null,
            '1'
        );

        $this->addProduct(
            54,
            'Product QAQRL',
            25,
            6,
            null,
            '7.45',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            55,
            'Product YYWRT',
            25,
            6,
            null,
            '24.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            56,
            'Product VKCMF',
            26,
            5,
            null,
            '38.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            57,
            'Product OVLQI',
            26,
            5,
            null,
            '19.50',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            58,
            'Product ACRVI',
            27,
            8,
            null,
            '13.25',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            59,
            'Product UKXRI',
            28,
            4,
            null,
            '55.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            60,
            'Product WHBYK',
            28,
            4,
            null,
            '34.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            61,
            'Product XYZPE',
            29,
            2,
            null,
            '28.50',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            62,
            'Product WUXYK',
            29,
            3,
            null,
            '49.30',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            63,
            'Product ICKNK',
            7,
            2,
            null,
            '43.90',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            64,
            'Product HCQDE',
            12,
            5,
            null,
            '33.25',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            65,
            'Product XYWBZ',
            2,
            2,
            null,
            '21.05',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            66,
            'Product LQMGN',
            2,
            2,
            null,
            '17.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            67,
            'Product XLXQF',
            16,
            1,
            null,
            '14.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            68,
            'Product TBTBL',
            8,
            3,
            null,
            '12.50',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            69,
            'Product COAXA',
            15,
            4,
            null,
            '36.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            70,
            'Product TOONT',
            7,
            1,
            null,
            '15.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            71,
            'Product MYMOI',
            15,
            4,
            null,
            '21.50',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            72,
            'Product GEEOO',
            14,
            4,
            null,
            '34.80',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            73,
            'Product WEUJZ',
            17,
            8,
            null,
            '15.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            74,
            'Product BKAZJ',
            4,
            7,
            null,
            '10.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            75,
            'Product BWRLG',
            12,
            1,
            null,
            '7.75',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            76,
            'Product JYGFE',
            23,
            1,
            null,
            '18.00',
            null,
            null,
            null,
            '0'
        );

        $this->addProduct(
            77,
            'Product LUNZZ',
            12,
            2,
            null,
            '13.00',
            null,
            null,
            null,
            '0'
        );

    }

    private function addEmployeeTerritory(
        $employeeId,
        $territoryId
    ) {
        Capsule::table($this->employeeTerritory)->updateOrInsert(
            ["employeeId" => $employeeId, "territoryId" => $territoryId],
            []
        );

        return Capsule::table($this->employeeTerritory)->where("employeeId", $employeeId)->first();

    }

    private function InsertEmployeesTerritories()
    {
        $this->addEmployeeTerritory(
            2,
            '01581'
        );

        $this->addEmployeeTerritory(
            2,
            '01730'
        );

        $this->addEmployeeTerritory(
            2,
            '01833'
        );

        $this->addEmployeeTerritory(
            2,
            '02116'
        );

        $this->addEmployeeTerritory(
            2,
            '02139'
        );

        $this->addEmployeeTerritory(
            2,
            '02184'
        );

        $this->addEmployeeTerritory(
            5,
            '02903'
        );

        $this->addEmployeeTerritory(
            9,
            '03049'
        );

        $this->addEmployeeTerritory(
            9,
            '03801'
        );

        $this->addEmployeeTerritory(
            1,
            '06897'
        );

        $this->addEmployeeTerritory(
            5,
            '07960'
        );

        $this->addEmployeeTerritory(
            5,
            '08837'
        );

        $this->addEmployeeTerritory(
            5,
            '10019'
        );

        $this->addEmployeeTerritory(
            5,
            '10038'
        );

        $this->addEmployeeTerritory(
            5,
            '11747'
        );

        $this->addEmployeeTerritory(
            5,
            '14450'
        );

        $this->addEmployeeTerritory(
            8,
            '19428'
        );

        $this->addEmployeeTerritory(
            1,
            '19713'
        );

        $this->addEmployeeTerritory(
            4,
            '20852'
        );

        $this->addEmployeeTerritory(
            4,
            '27403'
        );

        $this->addEmployeeTerritory(
            4,
            '27511'
        );

        $this->addEmployeeTerritory(
            3,
            '30346'
        );

        $this->addEmployeeTerritory(
            3,
            '31406'
        );

        $this->addEmployeeTerritory(
            3,
            '32859'
        );

        $this->addEmployeeTerritory(
            3,
            '33607'
        );

        $this->addEmployeeTerritory(
            2,
            '40222'
        );

        $this->addEmployeeTerritory(
            8,
            '44122'
        );

        $this->addEmployeeTerritory(
            8,
            '45839'
        );

        $this->addEmployeeTerritory(
            9,
            '48075'
        );

        $this->addEmployeeTerritory(
            9,
            '48084'
        );

        $this->addEmployeeTerritory(
            9,
            '48304'
        );

        $this->addEmployeeTerritory(
            8,
            '53404'
        );

        $this->addEmployeeTerritory(
            9,
            '55113'
        );

        $this->addEmployeeTerritory(
            9,
            '55439'
        );

        $this->addEmployeeTerritory(
            7,
            '60179'
        );

        $this->addEmployeeTerritory(
            7,
            '60601'
        );

        $this->addEmployeeTerritory(
            7,
            '80202'
        );

        $this->addEmployeeTerritory(
            7,
            '80909'
        );

        $this->addEmployeeTerritory(
            6,
            '85014'
        );

        $this->addEmployeeTerritory(
            6,
            '85251'
        );

        $this->addEmployeeTerritory(
            7,
            '90405'
        );

        $this->addEmployeeTerritory(
            7,
            '94025'
        );

        $this->addEmployeeTerritory(
            7,
            '94105'
        );

        $this->addEmployeeTerritory(
            7,
            '95008'
        );

        $this->addEmployeeTerritory(
            7,
            '95054'
        );

        $this->addEmployeeTerritory(
            7,
            '95060'
        );

        $this->addEmployeeTerritory(
            6,
            '98004'
        );

        $this->addEmployeeTerritory(
            6,
            '98052'
        );

        $this->addEmployeeTerritory(
            6,
            '98104'
        );
    }

    private function addOrderDetail(
        $orderDetailId,
        $orderId,
        $productId,
        $unitPrice,
        $quantity,
        $discount
    ) {
        Capsule::table($this->orderDetail)->updateOrInsert(
            ["orderDetailId" => $orderDetailId],
            [
                "orderDetailId" => $orderDetailId,
                "orderId"       => $orderId,
                "productId"     => $productId,
                "unitPrice"     => $unitPrice,
                "quantity"      => $quantity,
                "discount"      => $discount
            ]
        );

        return Capsule::table($this->orderDetail)->where("orderDetailId", $orderDetailId)->first();

    }

    /*
    private function insertOrderDetails()
    {
    $this->addOrderDetail(
    12,
    10252,
    20,
    '64.80',
    40,
    '0.05',
    );

    $this->addOrderDetail(
    13,
    10252,
    33,
    '2.00',
    25,
    '0.05',
    );

    $this->addOrderDetail(
    14,
    10252,
    60,
    '27.20',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    18,
    10254,
    24,
    '3.60',
    15,
    '0.15',
    );

    $this->addOrderDetail(
    19,
    10254,
    55,
    '19.20',
    21,
    '0.15',
    );

    $this->addOrderDetail(
    20,
    10254,
    74,
    '8.00',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    21,
    10255,
    2,
    '15.20',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    22,
    10255,
    16,
    '13.90',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    23,
    10255,
    36,
    '15.20',
    25,
    '0.00',
    );

    $this->addOrderDetail(
    24,
    10255,
    59,
    '44.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    27,
    10257,
    27,
    '35.10',
    25,
    '0.00',
    );

    $this->addOrderDetail(
    28,
    10257,
    39,
    '14.40',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    29,
    10257,
    77,
    '10.40',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    30,
    10258,
    2,
    '15.20',
    50,
    '0.20',
    );

    $this->addOrderDetail(
    31,
    10258,
    5,
    '17.00',
    65,
    '0.20',
    );

    $this->addOrderDetail(
    32,
    10258,
    32,
    '25.60',
    6,
    '0.20',
    );

    $this->addOrderDetail(
    44,
    10263,
    16,
    '13.90',
    60,
    '0.25',
    );

    $this->addOrderDetail(
    45,
    10263,
    24,
    '3.60',
    28,
    '0.00',
    );

    $this->addOrderDetail(
    46,
    10263,
    30,
    '20.70',
    60,
    '0.25',
    );

    $this->addOrderDetail(
    47,
    10263,
    74,
    '8.00',
    36,
    '0.25',
    );

    $this->addOrderDetail(
    56,
    10268,
    29,
    '99.00',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    57,
    10268,
    72,
    '27.80',
    4,
    '0.00',
    );

    $this->addOrderDetail(
    92,
    10283,
    15,
    '12.40',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    93,
    10283,
    19,
    '7.30',
    18,
    '0.00',
    );

    $this->addOrderDetail(
    94,
    10283,
    60,
    '27.20',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    95,
    10283,
    72,
    '27.80',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    110,
    10289,
    3,
    '8.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    111,
    10289,
    64,
    '26.60',
    9,
    '0.00',
    );

    $this->addOrderDetail(
    130,
    10296,
    11,
    '16.80',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    131,
    10296,
    16,
    '13.90',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    132,
    10296,
    69,
    '28.80',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    145,
    10302,
    17,
    '31.20',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    146,
    10302,
    28,
    '36.40',
    28,
    '0.00',
    );

    $this->addOrderDetail(
    147,
    10302,
    43,
    '36.80',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    181,
    10315,
    34,
    '11.20',
    14,
    '0.00',
    );

    $this->addOrderDetail(
    182,
    10315,
    70,
    '12.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    186,
    10318,
    41,
    '7.70',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    187,
    10318,
    76,
    '14.40',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    192,
    10321,
    35,
    '14.40',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    214,
    10328,
    59,
    '44.00',
    9,
    '0.00',
    );

    $this->addOrderDetail(
    215,
    10328,
    65,
    '16.80',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    216,
    10328,
    68,
    '10.00',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    221,
    10330,
    26,
    '24.90',
    50,
    '0.15',
    );

    $this->addOrderDetail(
    222,
    10330,
    72,
    '27.80',
    25,
    '0.15',
    );

    $this->addOrderDetail(
    224,
    10332,
    18,
    '50.00',
    40,
    '0.20',
    );

    $this->addOrderDetail(
    225,
    10332,
    42,
    '11.20',
    10,
    '0.20',
    );

    $this->addOrderDetail(
    226,
    10332,
    47,
    '7.60',
    16,
    '0.20',
    );

    $this->addOrderDetail(
    236,
    10336,
    4,
    '17.60',
    18,
    '0.10',
    );

    $this->addOrderDetail(
    244,
    10339,
    4,
    '17.60',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    245,
    10339,
    17,
    '31.20',
    70,
    '0.05',
    );

    $this->addOrderDetail(
    246,
    10339,
    62,
    '39.40',
    28,
    '0.00',
    );

    $this->addOrderDetail(
    275,
    10351,
    38,
    '210.80',
    20,
    '0.05',
    );

    $this->addOrderDetail(
    276,
    10351,
    41,
    '7.70',
    13,
    '0.00',
    );

    $this->addOrderDetail(
    277,
    10351,
    44,
    '15.50',
    77,
    '0.05',
    );

    $this->addOrderDetail(
    278,
    10351,
    65,
    '16.80',
    10,
    '0.05',
    );

    $this->addOrderDetail(
    279,
    10352,
    24,
    '3.60',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    280,
    10352,
    54,
    '5.90',
    20,
    '0.15',
    );

    $this->addOrderDetail(
    281,
    10353,
    11,
    '16.80',
    12,
    '0.20',
    );

    $this->addOrderDetail(
    282,
    10353,
    38,
    '210.80',
    50,
    '0.20',
    );

    $this->addOrderDetail(
    285,
    10355,
    24,
    '3.60',
    25,
    '0.00',
    );

    $this->addOrderDetail(
    286,
    10355,
    57,
    '15.60',
    25,
    '0.00',
    );

    $this->addOrderDetail(
    290,
    10357,
    10,
    '24.80',
    30,
    '0.20',
    );

    $this->addOrderDetail(
    291,
    10357,
    26,
    '24.90',
    16,
    '0.00',
    );

    $this->addOrderDetail(
    292,
    10357,
    60,
    '27.20',
    8,
    '0.20',
    );

    $this->addOrderDetail(
    296,
    10359,
    16,
    '13.90',
    56,
    '0.05',
    );

    $this->addOrderDetail(
    297,
    10359,
    31,
    '10.00',
    70,
    '0.05',
    );

    $this->addOrderDetail(
    298,
    10359,
    60,
    '27.20',
    80,
    '0.05',
    );

    $this->addOrderDetail(
    312,
    10364,
    69,
    '28.80',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    313,
    10364,
    71,
    '17.20',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    321,
    10368,
    21,
    '8.00',
    5,
    '0.10',
    );

    $this->addOrderDetail(
    322,
    10368,
    28,
    '36.40',
    13,
    '0.10',
    );

    $this->addOrderDetail(
    323,
    10368,
    57,
    '15.60',
    25,
    '0.00',
    );

    $this->addOrderDetail(
    324,
    10368,
    64,
    '26.60',
    35,
    '0.10',
    );

    $this->addOrderDetail(
    327,
    10370,
    1,
    '14.40',
    15,
    '0.15',
    );

    $this->addOrderDetail(
    328,
    10370,
    64,
    '26.60',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    329,
    10370,
    74,
    '8.00',
    20,
    '0.15',
    );

    $this->addOrderDetail(
    341,
    10376,
    31,
    '10.00',
    42,
    '0.05',
    );

    $this->addOrderDetail(
    342,
    10377,
    28,
    '36.40',
    20,
    '0.15',
    );

    $this->addOrderDetail(
    343,
    10377,
    39,
    '14.40',
    20,
    '0.15',
    );

    $this->addOrderDetail(
    352,
    10381,
    74,
    '8.00',
    14,
    '0.00',
    );

    $this->addOrderDetail(
    353,
    10382,
    5,
    '17.00',
    32,
    '0.00',
    );

    $this->addOrderDetail(
    354,
    10382,
    18,
    '50.00',
    9,
    '0.00',
    );

    $this->addOrderDetail(
    355,
    10382,
    29,
    '99.00',
    14,
    '0.00',
    );

    $this->addOrderDetail(
    356,
    10382,
    33,
    '2.00',
    60,
    '0.00',
    );

    $this->addOrderDetail(
    357,
    10382,
    74,
    '8.00',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    358,
    10383,
    13,
    '4.80',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    359,
    10383,
    50,
    '13.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    360,
    10383,
    56,
    '30.40',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    372,
    10388,
    45,
    '7.60',
    15,
    '0.20',
    );

    $this->addOrderDetail(
    373,
    10388,
    52,
    '5.60',
    20,
    '0.20',
    );

    $this->addOrderDetail(
    374,
    10388,
    53,
    '26.20',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    375,
    10389,
    10,
    '24.80',
    16,
    '0.00',
    );

    $this->addOrderDetail(
    376,
    10389,
    55,
    '19.20',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    377,
    10389,
    62,
    '39.40',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    378,
    10389,
    70,
    '12.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    379,
    10390,
    31,
    '10.00',
    60,
    '0.10',
    );

    $this->addOrderDetail(
    380,
    10390,
    35,
    '14.40',
    40,
    '0.10',
    );

    $this->addOrderDetail(
    381,
    10390,
    46,
    '9.60',
    45,
    '0.00',
    );

    $this->addOrderDetail(
    382,
    10390,
    72,
    '27.80',
    24,
    '0.10',
    );

    $this->addOrderDetail(
    384,
    10392,
    69,
    '28.80',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    392,
    10395,
    46,
    '9.60',
    28,
    '0.10',
    );

    $this->addOrderDetail(
    393,
    10395,
    53,
    '26.20',
    70,
    '0.10',
    );

    $this->addOrderDetail(
    394,
    10395,
    69,
    '28.80',
    8,
    '0.00',
    );

    $this->addOrderDetail(
    398,
    10397,
    21,
    '8.00',
    10,
    '0.15',
    );

    $this->addOrderDetail(
    399,
    10397,
    51,
    '42.40',
    18,
    '0.15',
    );

    $this->addOrderDetail(
    406,
    10400,
    29,
    '99.00',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    407,
    10400,
    35,
    '14.40',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    408,
    10400,
    49,
    '16.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    413,
    10402,
    23,
    '7.20',
    60,
    '0.00',
    );

    $this->addOrderDetail(
    414,
    10402,
    63,
    '35.10',
    65,
    '0.00',
    );

    $this->addOrderDetail(
    415,
    10403,
    16,
    '13.90',
    21,
    '0.15',
    );

    $this->addOrderDetail(
    416,
    10403,
    48,
    '10.20',
    70,
    '0.15',
    );

    $this->addOrderDetail(
    420,
    10405,
    3,
    '8.00',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    434,
    10410,
    33,
    '2.00',
    49,
    '0.00',
    );

    $this->addOrderDetail(
    435,
    10410,
    59,
    '44.00',
    16,
    '0.00',
    );

    $this->addOrderDetail(
    436,
    10411,
    41,
    '7.70',
    25,
    '0.20',
    );

    $this->addOrderDetail(
    437,
    10411,
    44,
    '15.50',
    40,
    '0.20',
    );

    $this->addOrderDetail(
    438,
    10411,
    59,
    '44.00',
    9,
    '0.20',
    );

    $this->addOrderDetail(
    458,
    10419,
    60,
    '27.20',
    60,
    '0.05',
    );

    $this->addOrderDetail(
    459,
    10419,
    69,
    '28.80',
    20,
    '0.05',
    );

    $this->addOrderDetail(
    471,
    10424,
    35,
    '14.40',
    60,
    '0.20',
    );

    $this->addOrderDetail(
    472,
    10424,
    38,
    '210.80',
    49,
    '0.20',
    );

    $this->addOrderDetail(
    473,
    10424,
    68,
    '10.00',
    30,
    '0.20',
    );

    $this->addOrderDetail(
    478,
    10427,
    14,
    '18.60',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    482,
    10430,
    17,
    '31.20',
    45,
    '0.20',
    );

    $this->addOrderDetail(
    483,
    10430,
    21,
    '8.00',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    484,
    10430,
    56,
    '30.40',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    485,
    10430,
    59,
    '44.00',
    70,
    '0.20',
    );

    $this->addOrderDetail(
    486,
    10431,
    17,
    '31.20',
    50,
    '0.25',
    );

    $this->addOrderDetail(
    487,
    10431,
    40,
    '14.70',
    50,
    '0.25',
    );

    $this->addOrderDetail(
    488,
    10431,
    47,
    '7.60',
    30,
    '0.25',
    );

    $this->addOrderDetail(
    491,
    10433,
    56,
    '30.40',
    28,
    '0.00',
    );

    $this->addOrderDetail(
    494,
    10435,
    2,
    '15.20',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    495,
    10435,
    22,
    '16.80',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    496,
    10435,
    72,
    '27.80',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    505,
    10439,
    12,
    '30.40',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    506,
    10439,
    16,
    '13.90',
    16,
    '0.00',
    );

    $this->addOrderDetail(
    507,
    10439,
    64,
    '26.60',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    508,
    10439,
    74,
    '8.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    514,
    10442,
    11,
    '16.80',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    515,
    10442,
    54,
    '5.90',
    80,
    '0.00',
    );

    $this->addOrderDetail(
    516,
    10442,
    66,
    '13.60',
    60,
    '0.00',
    );

    $this->addOrderDetail(
    545,
    10453,
    48,
    '10.20',
    15,
    '0.10',
    );

    $this->addOrderDetail(
    546,
    10453,
    70,
    '12.00',
    25,
    '0.10',
    );

    $this->addOrderDetail(
    557,
    10458,
    26,
    '24.90',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    558,
    10458,
    28,
    '36.40',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    559,
    10458,
    43,
    '36.80',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    560,
    10458,
    56,
    '30.40',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    561,
    10458,
    71,
    '17.20',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    567,
    10461,
    21,
    '8.00',
    40,
    '0.25',
    );

    $this->addOrderDetail(
    568,
    10461,
    30,
    '20.70',
    28,
    '0.25',
    );

    $this->addOrderDetail(
    569,
    10461,
    55,
    '19.20',
    60,
    '0.25',
    );

    $this->addOrderDetail(
    570,
    10462,
    13,
    '4.80',
    1,
    '0.00',
    );

    $this->addOrderDetail(
    571,
    10462,
    23,
    '7.20',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    572,
    10463,
    19,
    '7.30',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    573,
    10463,
    42,
    '11.20',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    574,
    10464,
    4,
    '17.60',
    16,
    '0.20',
    );

    $this->addOrderDetail(
    575,
    10464,
    43,
    '36.80',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    576,
    10464,
    56,
    '30.40',
    30,
    '0.20',
    );

    $this->addOrderDetail(
    577,
    10464,
    60,
    '27.20',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    595,
    10471,
    7,
    '24.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    596,
    10471,
    56,
    '30.40',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    597,
    10472,
    24,
    '3.60',
    80,
    '0.05',
    );

    $this->addOrderDetail(
    598,
    10472,
    51,
    '42.40',
    18,
    '0.00',
    );

    $this->addOrderDetail(
    599,
    10473,
    33,
    '2.00',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    600,
    10473,
    71,
    '17.20',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    605,
    10475,
    31,
    '10.00',
    35,
    '0.15',
    );

    $this->addOrderDetail(
    606,
    10475,
    66,
    '13.60',
    60,
    '0.15',
    );

    $this->addOrderDetail(
    607,
    10475,
    76,
    '14.40',
    42,
    '0.15',
    );

    $this->addOrderDetail(
    608,
    10476,
    55,
    '19.20',
    2,
    '0.05',
    );

    $this->addOrderDetail(
    609,
    10476,
    70,
    '12.00',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    610,
    10477,
    1,
    '14.40',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    611,
    10477,
    21,
    '8.00',
    21,
    '0.25',
    );

    $this->addOrderDetail(
    612,
    10477,
    39,
    '14.40',
    20,
    '0.25',
    );

    $this->addOrderDetail(
    625,
    10484,
    21,
    '8.00',
    14,
    '0.00',
    );

    $this->addOrderDetail(
    626,
    10484,
    40,
    '14.70',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    627,
    10484,
    51,
    '42.40',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    628,
    10485,
    2,
    '15.20',
    20,
    '0.10',
    );

    $this->addOrderDetail(
    629,
    10485,
    3,
    '8.00',
    20,
    '0.10',
    );

    $this->addOrderDetail(
    630,
    10485,
    55,
    '19.20',
    30,
    '0.10',
    );

    $this->addOrderDetail(
    631,
    10485,
    70,
    '12.00',
    60,
    '0.10',
    );

    $this->addOrderDetail(
    632,
    10486,
    11,
    '16.80',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    633,
    10486,
    51,
    '42.40',
    25,
    '0.00',
    );

    $this->addOrderDetail(
    634,
    10486,
    74,
    '8.00',
    16,
    '0.00',
    );

    $this->addOrderDetail(
    640,
    10489,
    11,
    '16.80',
    15,
    '0.25',
    );

    $this->addOrderDetail(
    641,
    10489,
    16,
    '13.90',
    18,
    '0.00',
    );

    $this->addOrderDetail(
    642,
    10490,
    59,
    '44.00',
    60,
    '0.00',
    );

    $this->addOrderDetail(
    643,
    10490,
    68,
    '10.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    644,
    10490,
    75,
    '6.20',
    36,
    '0.00',
    );

    $this->addOrderDetail(
    645,
    10491,
    44,
    '15.50',
    15,
    '0.15',
    );

    $this->addOrderDetail(
    646,
    10491,
    77,
    '10.40',
    7,
    '0.15',
    );

    $this->addOrderDetail(
    647,
    10492,
    25,
    '11.20',
    60,
    '0.05',
    );

    $this->addOrderDetail(
    648,
    10492,
    42,
    '11.20',
    20,
    '0.05',
    );

    $this->addOrderDetail(
    653,
    10495,
    23,
    '7.20',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    654,
    10495,
    41,
    '7.70',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    655,
    10495,
    77,
    '10.40',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    660,
    10498,
    24,
    '4.50',
    14,
    '0.00',
    );

    $this->addOrderDetail(
    661,
    10498,
    40,
    '18.40',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    662,
    10498,
    42,
    '14.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    663,
    10499,
    28,
    '45.60',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    664,
    10499,
    49,
    '20.00',
    25,
    '0.00',
    );

    $this->addOrderDetail(
    677,
    10505,
    62,
    '49.30',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    697,
    10514,
    20,
    '81.00',
    39,
    '0.00',
    );

    $this->addOrderDetail(
    698,
    10514,
    28,
    '45.60',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    699,
    10514,
    56,
    '38.00',
    70,
    '0.00',
    );

    $this->addOrderDetail(
    700,
    10514,
    65,
    '21.05',
    39,
    '0.00',
    );

    $this->addOrderDetail(
    701,
    10514,
    75,
    '7.75',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    710,
    10517,
    52,
    '7.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    711,
    10517,
    59,
    '55.00',
    4,
    '0.00',
    );

    $this->addOrderDetail(
    712,
    10517,
    70,
    '15.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    716,
    10519,
    10,
    '31.00',
    16,
    '0.05',
    );

    $this->addOrderDetail(
    717,
    10519,
    56,
    '38.00',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    718,
    10519,
    60,
    '34.00',
    10,
    '0.05',
    );

    $this->addOrderDetail(
    728,
    10523,
    17,
    '39.00',
    25,
    '0.10',
    );

    $this->addOrderDetail(
    729,
    10523,
    20,
    '81.00',
    15,
    '0.10',
    );

    $this->addOrderDetail(
    730,
    10523,
    37,
    '26.00',
    18,
    '0.10',
    );

    $this->addOrderDetail(
    731,
    10523,
    41,
    '9.65',
    6,
    '0.10',
    );

    $this->addOrderDetail(
    746,
    10529,
    55,
    '24.00',
    14,
    '0.00',
    );

    $this->addOrderDetail(
    747,
    10529,
    68,
    '12.50',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    748,
    10529,
    69,
    '36.00',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    749,
    10530,
    17,
    '39.00',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    750,
    10530,
    43,
    '46.00',
    25,
    '0.00',
    );

    $this->addOrderDetail(
    751,
    10530,
    61,
    '28.50',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    752,
    10530,
    76,
    '18.00',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    754,
    10532,
    30,
    '25.89',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    755,
    10532,
    66,
    '17.00',
    24,
    '0.00',
    );

    $this->addOrderDetail(
    770,
    10537,
    31,
    '12.50',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    771,
    10537,
    51,
    '53.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    772,
    10537,
    58,
    '13.25',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    773,
    10537,
    72,
    '34.80',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    774,
    10537,
    73,
    '15.00',
    9,
    '0.00',
    );

    $this->addOrderDetail(
    775,
    10538,
    70,
    '15.00',
    7,
    '0.00',
    );

    $this->addOrderDetail(
    776,
    10538,
    72,
    '34.80',
    1,
    '0.00',
    );

    $this->addOrderDetail(
    777,
    10539,
    13,
    '6.00',
    8,
    '0.00',
    );

    $this->addOrderDetail(
    778,
    10539,
    21,
    '10.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    779,
    10539,
    33,
    '2.50',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    780,
    10539,
    49,
    '20.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    791,
    10543,
    12,
    '38.00',
    30,
    '0.15',
    );

    $this->addOrderDetail(
    792,
    10543,
    23,
    '9.00',
    70,
    '0.15',
    );

    $this->addOrderDetail(
    799,
    10547,
    32,
    '32.00',
    24,
    '0.15',
    );

    $this->addOrderDetail(
    800,
    10547,
    36,
    '19.00',
    60,
    '0.00',
    );

    $this->addOrderDetail(
    810,
    10551,
    16,
    '17.45',
    40,
    '0.15',
    );

    $this->addOrderDetail(
    811,
    10551,
    35,
    '18.00',
    20,
    '0.15',
    );

    $this->addOrderDetail(
    812,
    10551,
    44,
    '19.45',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    813,
    10552,
    69,
    '36.00',
    18,
    '0.00',
    );

    $this->addOrderDetail(
    814,
    10552,
    75,
    '7.75',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    832,
    10558,
    47,
    '9.50',
    25,
    '0.00',
    );

    $this->addOrderDetail(
    833,
    10558,
    51,
    '53.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    834,
    10558,
    52,
    '7.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    835,
    10558,
    53,
    '32.80',
    18,
    '0.00',
    );

    $this->addOrderDetail(
    836,
    10558,
    73,
    '15.00',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    850,
    10565,
    24,
    '4.50',
    25,
    '0.10',
    );

    $this->addOrderDetail(
    851,
    10565,
    64,
    '33.25',
    18,
    '0.10',
    );

    $this->addOrderDetail(
    861,
    10570,
    11,
    '21.00',
    15,
    '0.05',
    );

    $this->addOrderDetail(
    862,
    10570,
    56,
    '38.00',
    60,
    '0.05',
    );

    $this->addOrderDetail(
    863,
    10571,
    14,
    '23.25',
    11,
    '0.15',
    );

    $this->addOrderDetail(
    864,
    10571,
    42,
    '14.00',
    28,
    '0.15',
    );

    $this->addOrderDetail(
    886,
    10578,
    35,
    '18.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    887,
    10578,
    57,
    '19.50',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    908,
    10590,
    1,
    '18.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    909,
    10590,
    77,
    '13.00',
    60,
    '0.05',
    );

    $this->addOrderDetail(
    920,
    10595,
    35,
    '18.00',
    30,
    '0.25',
    );

    $this->addOrderDetail(
    921,
    10595,
    61,
    '28.50',
    120,
    '0.25',
    );

    $this->addOrderDetail(
    922,
    10595,
    69,
    '36.00',
    65,
    '0.25',
    );

    $this->addOrderDetail(
    926,
    10597,
    24,
    '4.50',
    35,
    '0.20',
    );

    $this->addOrderDetail(
    927,
    10597,
    57,
    '19.50',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    928,
    10597,
    65,
    '21.05',
    12,
    '0.20',
    );

    $this->addOrderDetail(
    931,
    10599,
    62,
    '49.30',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    934,
    10601,
    13,
    '6.00',
    60,
    '0.00',
    );

    $this->addOrderDetail(
    935,
    10601,
    59,
    '55.00',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    939,
    10604,
    48,
    '12.75',
    6,
    '0.10',
    );

    $this->addOrderDetail(
    940,
    10604,
    76,
    '18.00',
    10,
    '0.10',
    );

    $this->addOrderDetail(
    941,
    10605,
    16,
    '17.45',
    30,
    '0.05',
    );

    $this->addOrderDetail(
    942,
    10605,
    59,
    '55.00',
    20,
    '0.05',
    );

    $this->addOrderDetail(
    943,
    10605,
    60,
    '34.00',
    70,
    '0.05',
    );

    $this->addOrderDetail(
    944,
    10605,
    71,
    '21.50',
    15,
    '0.05',
    );

    $this->addOrderDetail(
    948,
    10607,
    7,
    '30.00',
    45,
    '0.00',
    );

    $this->addOrderDetail(
    949,
    10607,
    17,
    '39.00',
    100,
    '0.00',
    );

    $this->addOrderDetail(
    950,
    10607,
    33,
    '2.50',
    14,
    '0.00',
    );

    $this->addOrderDetail(
    951,
    10607,
    40,
    '18.40',
    42,
    '0.00',
    );

    $this->addOrderDetail(
    952,
    10607,
    72,
    '34.80',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    961,
    10612,
    10,
    '31.00',
    70,
    '0.00',
    );

    $this->addOrderDetail(
    962,
    10612,
    36,
    '19.00',
    55,
    '0.00',
    );

    $this->addOrderDetail(
    963,
    10612,
    49,
    '20.00',
    18,
    '0.00',
    );

    $this->addOrderDetail(
    964,
    10612,
    60,
    '34.00',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    965,
    10612,
    76,
    '18.00',
    80,
    '0.00',
    );

    $this->addOrderDetail(
    966,
    10613,
    13,
    '6.00',
    8,
    '0.10',
    );

    $this->addOrderDetail(
    967,
    10613,
    75,
    '7.75',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    972,
    10616,
    38,
    '263.50',
    15,
    '0.05',
    );

    $this->addOrderDetail(
    973,
    10616,
    56,
    '38.00',
    14,
    '0.00',
    );

    $this->addOrderDetail(
    974,
    10616,
    70,
    '15.00',
    15,
    '0.05',
    );

    $this->addOrderDetail(
    975,
    10616,
    71,
    '21.50',
    15,
    '0.05',
    );

    $this->addOrderDetail(
    976,
    10617,
    59,
    '55.00',
    30,
    '0.15',
    );

    $this->addOrderDetail(
    977,
    10618,
    6,
    '25.00',
    70,
    '0.00',
    );

    $this->addOrderDetail(
    978,
    10618,
    56,
    '38.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    979,
    10618,
    68,
    '12.50',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    980,
    10619,
    21,
    '10.00',
    42,
    '0.00',
    );

    $this->addOrderDetail(
    981,
    10619,
    22,
    '21.00',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    982,
    10620,
    24,
    '4.50',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    983,
    10620,
    52,
    '7.00',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    984,
    10621,
    19,
    '9.20',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    985,
    10621,
    23,
    '9.00',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    986,
    10621,
    70,
    '15.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    987,
    10621,
    71,
    '21.50',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    995,
    10624,
    28,
    '45.60',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    996,
    10624,
    29,
    '123.79',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    997,
    10624,
    44,
    '19.45',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1004,
    10627,
    62,
    '49.30',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1005,
    10627,
    73,
    '15.00',
    35,
    '0.15',
    );

    $this->addOrderDetail(
    1014,
    10633,
    12,
    '38.00',
    36,
    '0.15',
    );

    $this->addOrderDetail(
    1015,
    10633,
    13,
    '6.00',
    13,
    '0.15',
    );

    $this->addOrderDetail(
    1016,
    10633,
    26,
    '31.23',
    35,
    '0.15',
    );

    $this->addOrderDetail(
    1017,
    10633,
    62,
    '49.30',
    80,
    '0.15',
    );

    $this->addOrderDetail(
    1030,
    10638,
    45,
    '9.50',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1031,
    10638,
    65,
    '21.05',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    1032,
    10638,
    72,
    '34.80',
    60,
    '0.00',
    );

    $this->addOrderDetail(
    1036,
    10641,
    2,
    '19.00',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    1037,
    10641,
    40,
    '18.40',
    60,
    '0.00',
    );

    $this->addOrderDetail(
    1056,
    10649,
    28,
    '45.60',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1057,
    10649,
    72,
    '34.80',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1071,
    10656,
    14,
    '23.25',
    3,
    '0.10',
    );

    $this->addOrderDetail(
    1072,
    10656,
    44,
    '19.45',
    28,
    '0.10',
    );

    $this->addOrderDetail(
    1073,
    10656,
    47,
    '9.50',
    6,
    '0.10',
    );

    $this->addOrderDetail(
    1074,
    10657,
    15,
    '15.50',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    1075,
    10657,
    41,
    '9.65',
    24,
    '0.00',
    );

    $this->addOrderDetail(
    1076,
    10657,
    46,
    '12.00',
    45,
    '0.00',
    );

    $this->addOrderDetail(
    1077,
    10657,
    47,
    '9.50',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1078,
    10657,
    56,
    '38.00',
    45,
    '0.00',
    );

    $this->addOrderDetail(
    1079,
    10657,
    60,
    '34.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1087,
    10660,
    20,
    '81.00',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    1090,
    10662,
    68,
    '12.50',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1094,
    10664,
    10,
    '31.00',
    24,
    '0.15',
    );

    $this->addOrderDetail(
    1095,
    10664,
    56,
    '38.00',
    12,
    '0.15',
    );

    $this->addOrderDetail(
    1096,
    10664,
    65,
    '21.05',
    15,
    '0.15',
    );

    $this->addOrderDetail(
    1097,
    10665,
    51,
    '53.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1098,
    10665,
    59,
    '55.00',
    1,
    '0.00',
    );

    $this->addOrderDetail(
    1099,
    10665,
    76,
    '18.00',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1100,
    10666,
    29,
    '123.79',
    36,
    '0.00',
    );

    $this->addOrderDetail(
    1101,
    10666,
    65,
    '21.05',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1102,
    10667,
    69,
    '36.00',
    45,
    '0.20',
    );

    $this->addOrderDetail(
    1103,
    10667,
    71,
    '21.50',
    14,
    '0.20',
    );

    $this->addOrderDetail(
    1113,
    10671,
    16,
    '17.45',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1114,
    10671,
    62,
    '49.30',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1115,
    10671,
    65,
    '21.05',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    1121,
    10674,
    23,
    '9.00',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    1130,
    10678,
    12,
    '38.00',
    100,
    '0.00',
    );

    $this->addOrderDetail(
    1131,
    10678,
    33,
    '2.50',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1132,
    10678,
    41,
    '9.65',
    120,
    '0.00',
    );

    $this->addOrderDetail(
    1133,
    10678,
    54,
    '7.45',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1134,
    10679,
    59,
    '55.00',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    1135,
    10680,
    16,
    '17.45',
    50,
    '0.25',
    );

    $this->addOrderDetail(
    1136,
    10680,
    31,
    '12.50',
    20,
    '0.25',
    );

    $this->addOrderDetail(
    1137,
    10680,
    42,
    '14.00',
    40,
    '0.25',
    );

    $this->addOrderDetail(
    1138,
    10681,
    19,
    '9.20',
    30,
    '0.10',
    );

    $this->addOrderDetail(
    1139,
    10681,
    21,
    '10.00',
    12,
    '0.10',
    );

    $this->addOrderDetail(
    1140,
    10681,
    64,
    '33.25',
    28,
    '0.00',
    );

    $this->addOrderDetail(
    1144,
    10683,
    52,
    '7.00',
    9,
    '0.00',
    );

    $this->addOrderDetail(
    1151,
    10686,
    17,
    '39.00',
    30,
    '0.20',
    );

    $this->addOrderDetail(
    1152,
    10686,
    26,
    '31.23',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1168,
    10693,
    9,
    '97.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1169,
    10693,
    54,
    '7.45',
    60,
    '0.15',
    );

    $this->addOrderDetail(
    1170,
    10693,
    69,
    '36.00',
    30,
    '0.15',
    );

    $this->addOrderDetail(
    1171,
    10693,
    73,
    '15.00',
    15,
    '0.15',
    );

    $this->addOrderDetail(
    1178,
    10696,
    17,
    '39.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1179,
    10696,
    46,
    '12.00',
    18,
    '0.00',
    );

    $this->addOrderDetail(
    1180,
    10697,
    19,
    '9.20',
    7,
    '0.25',
    );

    $this->addOrderDetail(
    1181,
    10697,
    35,
    '18.00',
    9,
    '0.25',
    );

    $this->addOrderDetail(
    1182,
    10697,
    58,
    '13.25',
    30,
    '0.25',
    );

    $this->addOrderDetail(
    1183,
    10697,
    70,
    '15.00',
    30,
    '0.25',
    );

    $this->addOrderDetail(
    1184,
    10698,
    11,
    '21.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1185,
    10698,
    17,
    '39.00',
    8,
    '0.05',
    );

    $this->addOrderDetail(
    1186,
    10698,
    29,
    '123.79',
    12,
    '0.05',
    );

    $this->addOrderDetail(
    1187,
    10698,
    65,
    '21.05',
    65,
    '0.05',
    );

    $this->addOrderDetail(
    1188,
    10698,
    70,
    '15.00',
    8,
    '0.05',
    );

    $this->addOrderDetail(
    1190,
    10700,
    1,
    '18.00',
    5,
    '0.20',
    );

    $this->addOrderDetail(
    1191,
    10700,
    34,
    '14.00',
    12,
    '0.20',
    );

    $this->addOrderDetail(
    1192,
    10700,
    68,
    '12.50',
    40,
    '0.20',
    );

    $this->addOrderDetail(
    1193,
    10700,
    71,
    '21.50',
    60,
    '0.20',
    );

    $this->addOrderDetail(
    1205,
    10705,
    31,
    '12.50',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1206,
    10705,
    32,
    '32.00',
    4,
    '0.00',
    );

    $this->addOrderDetail(
    1207,
    10706,
    16,
    '17.45',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1208,
    10706,
    43,
    '46.00',
    24,
    '0.00',
    );

    $this->addOrderDetail(
    1209,
    10706,
    59,
    '55.00',
    8,
    '0.00',
    );

    $this->addOrderDetail(
    1210,
    10707,
    55,
    '24.00',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    1211,
    10707,
    57,
    '19.50',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    1212,
    10707,
    70,
    '15.00',
    28,
    '0.15',
    );

    $this->addOrderDetail(
    1213,
    10708,
    5,
    '21.35',
    4,
    '0.00',
    );

    $this->addOrderDetail(
    1214,
    10708,
    36,
    '19.00',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    1220,
    10711,
    19,
    '9.20',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    1221,
    10711,
    41,
    '9.65',
    42,
    '0.00',
    );

    $this->addOrderDetail(
    1222,
    10711,
    53,
    '32.80',
    120,
    '0.00',
    );

    $this->addOrderDetail(
    1225,
    10713,
    10,
    '31.00',
    18,
    '0.00',
    );

    $this->addOrderDetail(
    1226,
    10713,
    26,
    '31.23',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1227,
    10713,
    45,
    '9.50',
    110,
    '0.00',
    );

    $this->addOrderDetail(
    1228,
    10713,
    46,
    '12.00',
    24,
    '0.00',
    );

    $this->addOrderDetail(
    1229,
    10714,
    2,
    '19.00',
    30,
    '0.25',
    );

    $this->addOrderDetail(
    1230,
    10714,
    17,
    '39.00',
    27,
    '0.25',
    );

    $this->addOrderDetail(
    1231,
    10714,
    47,
    '9.50',
    50,
    '0.25',
    );

    $this->addOrderDetail(
    1232,
    10714,
    56,
    '38.00',
    18,
    '0.25',
    );

    $this->addOrderDetail(
    1233,
    10714,
    58,
    '13.25',
    12,
    '0.25',
    );

    $this->addOrderDetail(
    1234,
    10715,
    10,
    '31.00',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    1235,
    10715,
    71,
    '21.50',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1246,
    10719,
    18,
    '62.50',
    12,
    '0.25',
    );

    $this->addOrderDetail(
    1247,
    10719,
    30,
    '25.89',
    3,
    '0.25',
    );

    $this->addOrderDetail(
    1248,
    10719,
    54,
    '7.45',
    40,
    '0.25',
    );

    $this->addOrderDetail(
    1252,
    10722,
    2,
    '19.00',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    1253,
    10722,
    31,
    '12.50',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    1254,
    10722,
    68,
    '12.50',
    45,
    '0.00',
    );

    $this->addOrderDetail(
    1255,
    10722,
    75,
    '7.75',
    42,
    '0.00',
    );

    $this->addOrderDetail(
    1256,
    10723,
    26,
    '31.23',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1257,
    10724,
    10,
    '31.00',
    16,
    '0.00',
    );

    $this->addOrderDetail(
    1258,
    10724,
    61,
    '28.50',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    1262,
    10726,
    4,
    '22.00',
    25,
    '0.00',
    );

    $this->addOrderDetail(
    1263,
    10726,
    11,
    '21.00',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    1271,
    10729,
    1,
    '18.00',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    1272,
    10729,
    21,
    '10.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1273,
    10729,
    50,
    '16.25',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    1274,
    10730,
    16,
    '17.45',
    15,
    '0.05',
    );

    $this->addOrderDetail(
    1275,
    10730,
    31,
    '12.50',
    3,
    '0.05',
    );

    $this->addOrderDetail(
    1276,
    10730,
    65,
    '21.05',
    10,
    '0.05',
    );

    $this->addOrderDetail(
    1277,
    10731,
    21,
    '10.00',
    40,
    '0.05',
    );

    $this->addOrderDetail(
    1278,
    10731,
    51,
    '53.00',
    30,
    '0.05',
    );

    $this->addOrderDetail(
    1279,
    10732,
    76,
    '18.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1286,
    10735,
    61,
    '28.50',
    20,
    '0.10',
    );

    $this->addOrderDetail(
    1287,
    10735,
    77,
    '13.00',
    2,
    '0.10',
    );

    $this->addOrderDetail(
    1290,
    10737,
    13,
    '6.00',
    4,
    '0.00',
    );

    $this->addOrderDetail(
    1291,
    10737,
    41,
    '9.65',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    1292,
    10738,
    16,
    '17.45',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    1293,
    10739,
    36,
    '19.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1294,
    10739,
    52,
    '7.00',
    18,
    '0.00',
    );

    $this->addOrderDetail(
    1295,
    10740,
    28,
    '45.60',
    5,
    '0.20',
    );

    $this->addOrderDetail(
    1296,
    10740,
    35,
    '18.00',
    35,
    '0.20',
    );

    $this->addOrderDetail(
    1297,
    10740,
    45,
    '9.50',
    40,
    '0.20',
    );

    $this->addOrderDetail(
    1298,
    10740,
    56,
    '38.00',
    14,
    '0.20',
    );

    $this->addOrderDetail(
    1299,
    10741,
    2,
    '19.00',
    15,
    '0.20',
    );

    $this->addOrderDetail(
    1300,
    10742,
    3,
    '10.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1301,
    10742,
    60,
    '34.00',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    1302,
    10742,
    72,
    '34.80',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    1303,
    10743,
    46,
    '12.00',
    28,
    '0.05',
    );

    $this->addOrderDetail(
    1309,
    10746,
    13,
    '6.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1310,
    10746,
    42,
    '14.00',
    28,
    '0.00',
    );

    $this->addOrderDetail(
    1311,
    10746,
    62,
    '49.30',
    9,
    '0.00',
    );

    $this->addOrderDetail(
    1312,
    10746,
    69,
    '36.00',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    1313,
    10747,
    31,
    '12.50',
    8,
    '0.00',
    );

    $this->addOrderDetail(
    1314,
    10747,
    41,
    '9.65',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    1315,
    10747,
    63,
    '43.90',
    9,
    '0.00',
    );

    $this->addOrderDetail(
    1316,
    10747,
    69,
    '36.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1317,
    10748,
    23,
    '9.00',
    44,
    '0.00',
    );

    $this->addOrderDetail(
    1318,
    10748,
    40,
    '18.40',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    1319,
    10748,
    56,
    '38.00',
    28,
    '0.00',
    );

    $this->addOrderDetail(
    1320,
    10749,
    56,
    '38.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1321,
    10749,
    59,
    '55.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1322,
    10749,
    76,
    '18.00',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1326,
    10751,
    26,
    '31.23',
    12,
    '0.10',
    );

    $this->addOrderDetail(
    1327,
    10751,
    30,
    '25.89',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1328,
    10751,
    50,
    '16.25',
    20,
    '0.10',
    );

    $this->addOrderDetail(
    1329,
    10751,
    73,
    '15.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1330,
    10752,
    1,
    '18.00',
    8,
    '0.00',
    );

    $this->addOrderDetail(
    1331,
    10752,
    69,
    '36.00',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    1335,
    10755,
    47,
    '9.50',
    30,
    '0.25',
    );

    $this->addOrderDetail(
    1336,
    10755,
    56,
    '38.00',
    30,
    '0.25',
    );

    $this->addOrderDetail(
    1337,
    10755,
    57,
    '19.50',
    14,
    '0.25',
    );

    $this->addOrderDetail(
    1338,
    10755,
    69,
    '36.00',
    25,
    '0.25',
    );

    $this->addOrderDetail(
    1339,
    10756,
    18,
    '62.50',
    21,
    '0.20',
    );

    $this->addOrderDetail(
    1340,
    10756,
    36,
    '19.00',
    20,
    '0.20',
    );

    $this->addOrderDetail(
    1341,
    10756,
    68,
    '12.50',
    6,
    '0.20',
    );

    $this->addOrderDetail(
    1342,
    10756,
    69,
    '36.00',
    20,
    '0.20',
    );

    $this->addOrderDetail(
    1343,
    10757,
    34,
    '14.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1344,
    10757,
    59,
    '55.00',
    7,
    '0.00',
    );

    $this->addOrderDetail(
    1345,
    10757,
    62,
    '49.30',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1346,
    10757,
    64,
    '33.25',
    24,
    '0.00',
    );

    $this->addOrderDetail(
    1347,
    10758,
    26,
    '31.23',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1348,
    10758,
    52,
    '7.00',
    60,
    '0.00',
    );

    $this->addOrderDetail(
    1349,
    10758,
    70,
    '15.00',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    1351,
    10760,
    25,
    '14.00',
    12,
    '0.25',
    );

    $this->addOrderDetail(
    1352,
    10760,
    27,
    '43.90',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    1353,
    10760,
    43,
    '46.00',
    30,
    '0.25',
    );

    $this->addOrderDetail(
    1354,
    10761,
    25,
    '14.00',
    35,
    '0.25',
    );

    $this->addOrderDetail(
    1355,
    10761,
    75,
    '7.75',
    18,
    '0.00',
    );

    $this->addOrderDetail(
    1360,
    10763,
    21,
    '10.00',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    1361,
    10763,
    22,
    '21.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1362,
    10763,
    24,
    '4.50',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1363,
    10764,
    3,
    '10.00',
    20,
    '0.10',
    );

    $this->addOrderDetail(
    1364,
    10764,
    39,
    '18.00',
    130,
    '0.10',
    );

    $this->addOrderDetail(
    1369,
    10767,
    42,
    '14.00',
    2,
    '0.00',
    );

    $this->addOrderDetail(
    1370,
    10768,
    22,
    '21.00',
    4,
    '0.00',
    );

    $this->addOrderDetail(
    1371,
    10768,
    31,
    '12.50',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    1372,
    10768,
    60,
    '34.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1373,
    10768,
    71,
    '21.50',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    1379,
    10771,
    71,
    '21.50',
    16,
    '0.00',
    );

    $this->addOrderDetail(
    1382,
    10773,
    17,
    '39.00',
    33,
    '0.00',
    );

    $this->addOrderDetail(
    1383,
    10773,
    31,
    '12.50',
    70,
    '0.20',
    );

    $this->addOrderDetail(
    1384,
    10773,
    75,
    '7.75',
    7,
    '0.20',
    );

    $this->addOrderDetail(
    1387,
    10775,
    10,
    '31.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1388,
    10775,
    67,
    '14.00',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    1389,
    10776,
    31,
    '12.50',
    16,
    '0.05',
    );

    $this->addOrderDetail(
    1390,
    10776,
    42,
    '14.00',
    12,
    '0.05',
    );

    $this->addOrderDetail(
    1391,
    10776,
    45,
    '9.50',
    27,
    '0.05',
    );

    $this->addOrderDetail(
    1392,
    10776,
    51,
    '53.00',
    120,
    '0.05',
    );

    $this->addOrderDetail(
    1397,
    10780,
    70,
    '15.00',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    1398,
    10780,
    77,
    '13.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1408,
    10785,
    10,
    '31.00',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1409,
    10785,
    75,
    '7.75',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1413,
    10787,
    2,
    '19.00',
    15,
    '0.05',
    );

    $this->addOrderDetail(
    1414,
    10787,
    29,
    '123.79',
    20,
    '0.05',
    );

    $this->addOrderDetail(
    1417,
    10789,
    18,
    '62.50',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1418,
    10789,
    35,
    '18.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1419,
    10789,
    63,
    '43.90',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1420,
    10789,
    68,
    '12.50',
    18,
    '0.00',
    );

    $this->addOrderDetail(
    1428,
    10793,
    41,
    '9.65',
    14,
    '0.00',
    );

    $this->addOrderDetail(
    1429,
    10793,
    52,
    '7.00',
    8,
    '0.00',
    );

    $this->addOrderDetail(
    1432,
    10795,
    16,
    '17.45',
    65,
    '0.00',
    );

    $this->addOrderDetail(
    1433,
    10795,
    17,
    '39.00',
    35,
    '0.25',
    );

    $this->addOrderDetail(
    1434,
    10796,
    26,
    '31.23',
    21,
    '0.20',
    );

    $this->addOrderDetail(
    1435,
    10796,
    44,
    '19.45',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1436,
    10796,
    64,
    '33.25',
    35,
    '0.20',
    );

    $this->addOrderDetail(
    1437,
    10796,
    69,
    '36.00',
    24,
    '0.20',
    );

    $this->addOrderDetail(
    1439,
    10798,
    62,
    '49.30',
    2,
    '0.00',
    );

    $this->addOrderDetail(
    1440,
    10798,
    72,
    '34.80',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1444,
    10800,
    11,
    '21.00',
    50,
    '0.10',
    );

    $this->addOrderDetail(
    1445,
    10800,
    51,
    '53.00',
    10,
    '0.10',
    );

    $this->addOrderDetail(
    1446,
    10800,
    54,
    '7.45',
    7,
    '0.10',
    );

    $this->addOrderDetail(
    1456,
    10804,
    10,
    '31.00',
    36,
    '0.00',
    );

    $this->addOrderDetail(
    1457,
    10804,
    28,
    '45.60',
    24,
    '0.00',
    );

    $this->addOrderDetail(
    1458,
    10804,
    49,
    '20.00',
    4,
    '0.15',
    );

    $this->addOrderDetail(
    1459,
    10805,
    34,
    '14.00',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1460,
    10805,
    38,
    '263.50',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1461,
    10806,
    2,
    '19.00',
    20,
    '0.25',
    );

    $this->addOrderDetail(
    1462,
    10806,
    65,
    '21.05',
    2,
    '0.00',
    );

    $this->addOrderDetail(
    1463,
    10806,
    74,
    '10.00',
    15,
    '0.25',
    );

    $this->addOrderDetail(
    1465,
    10808,
    56,
    '38.00',
    20,
    '0.15',
    );

    $this->addOrderDetail(
    1466,
    10808,
    76,
    '18.00',
    50,
    '0.15',
    );

    $this->addOrderDetail(
    1468,
    10810,
    13,
    '6.00',
    7,
    '0.00',
    );

    $this->addOrderDetail(
    1469,
    10810,
    25,
    '14.00',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    1470,
    10810,
    70,
    '15.00',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    1471,
    10811,
    19,
    '9.20',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1472,
    10811,
    23,
    '9.00',
    18,
    '0.00',
    );

    $this->addOrderDetail(
    1473,
    10811,
    40,
    '18.40',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1479,
    10814,
    41,
    '9.65',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1480,
    10814,
    43,
    '46.00',
    20,
    '0.15',
    );

    $this->addOrderDetail(
    1481,
    10814,
    48,
    '12.75',
    8,
    '0.15',
    );

    $this->addOrderDetail(
    1482,
    10814,
    61,
    '28.50',
    30,
    '0.15',
    );

    $this->addOrderDetail(
    1483,
    10815,
    33,
    '2.50',
    16,
    '0.00',
    );

    $this->addOrderDetail(
    1484,
    10816,
    38,
    '263.50',
    30,
    '0.05',
    );

    $this->addOrderDetail(
    1485,
    10816,
    62,
    '49.30',
    20,
    '0.05',
    );

    $this->addOrderDetail(
    1494,
    10820,
    56,
    '38.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1495,
    10821,
    35,
    '18.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1496,
    10821,
    51,
    '53.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1497,
    10822,
    62,
    '49.30',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    1498,
    10822,
    70,
    '15.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1499,
    10823,
    11,
    '21.00',
    20,
    '0.10',
    );

    $this->addOrderDetail(
    1500,
    10823,
    57,
    '19.50',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1501,
    10823,
    59,
    '55.00',
    40,
    '0.10',
    );

    $this->addOrderDetail(
    1502,
    10823,
    77,
    '13.00',
    15,
    '0.10',
    );

    $this->addOrderDetail(
    1507,
    10826,
    31,
    '12.50',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    1508,
    10826,
    57,
    '19.50',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1509,
    10827,
    10,
    '31.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1510,
    10827,
    39,
    '18.00',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    1513,
    10829,
    2,
    '19.00',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1514,
    10829,
    8,
    '40.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1515,
    10829,
    13,
    '6.00',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1516,
    10829,
    60,
    '34.00',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    1525,
    10832,
    13,
    '6.00',
    3,
    '0.20',
    );

    $this->addOrderDetail(
    1526,
    10832,
    25,
    '14.00',
    10,
    '0.20',
    );

    $this->addOrderDetail(
    1527,
    10832,
    44,
    '19.45',
    16,
    '0.20',
    );

    $this->addOrderDetail(
    1528,
    10832,
    64,
    '33.25',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    1536,
    10836,
    22,
    '21.00',
    52,
    '0.00',
    );

    $this->addOrderDetail(
    1537,
    10836,
    35,
    '18.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1538,
    10836,
    57,
    '19.50',
    24,
    '0.00',
    );

    $this->addOrderDetail(
    1539,
    10836,
    60,
    '34.00',
    60,
    '0.00',
    );

    $this->addOrderDetail(
    1540,
    10836,
    64,
    '33.25',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1545,
    10838,
    1,
    '18.00',
    4,
    '0.25',
    );

    $this->addOrderDetail(
    1546,
    10838,
    18,
    '62.50',
    25,
    '0.25',
    );

    $this->addOrderDetail(
    1547,
    10838,
    36,
    '19.00',
    50,
    '0.25',
    );

    $this->addOrderDetail(
    1550,
    10840,
    25,
    '14.00',
    6,
    '0.20',
    );

    $this->addOrderDetail(
    1551,
    10840,
    39,
    '18.00',
    10,
    '0.20',
    );

    $this->addOrderDetail(
    1552,
    10841,
    10,
    '31.00',
    16,
    '0.00',
    );

    $this->addOrderDetail(
    1553,
    10841,
    56,
    '38.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1554,
    10841,
    59,
    '55.00',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    1555,
    10841,
    77,
    '13.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1560,
    10843,
    51,
    '53.00',
    4,
    '0.25',
    );

    $this->addOrderDetail(
    1561,
    10844,
    22,
    '21.00',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    1567,
    10846,
    4,
    '22.00',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    1568,
    10846,
    70,
    '15.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1569,
    10846,
    74,
    '10.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1570,
    10847,
    1,
    '18.00',
    80,
    '0.20',
    );

    $this->addOrderDetail(
    1571,
    10847,
    19,
    '9.20',
    12,
    '0.20',
    );

    $this->addOrderDetail(
    1572,
    10847,
    37,
    '26.00',
    60,
    '0.20',
    );

    $this->addOrderDetail(
    1573,
    10847,
    45,
    '9.50',
    36,
    '0.20',
    );

    $this->addOrderDetail(
    1574,
    10847,
    60,
    '34.00',
    45,
    '0.20',
    );

    $this->addOrderDetail(
    1575,
    10847,
    71,
    '21.50',
    55,
    '0.20',
    );

    $this->addOrderDetail(
    1576,
    10848,
    5,
    '21.35',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1577,
    10848,
    9,
    '97.00',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    1580,
    10850,
    25,
    '14.00',
    20,
    '0.15',
    );

    $this->addOrderDetail(
    1581,
    10850,
    33,
    '2.50',
    4,
    '0.15',
    );

    $this->addOrderDetail(
    1582,
    10850,
    70,
    '15.00',
    30,
    '0.15',
    );

    $this->addOrderDetail(
    1587,
    10852,
    2,
    '19.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1588,
    10852,
    17,
    '39.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1589,
    10852,
    62,
    '49.30',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    1591,
    10854,
    10,
    '31.00',
    100,
    '0.15',
    );

    $this->addOrderDetail(
    1592,
    10854,
    13,
    '6.00',
    65,
    '0.15',
    );

    $this->addOrderDetail(
    1593,
    10855,
    16,
    '17.45',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    1594,
    10855,
    31,
    '12.50',
    14,
    '0.00',
    );

    $this->addOrderDetail(
    1595,
    10855,
    56,
    '38.00',
    24,
    '0.00',
    );

    $this->addOrderDetail(
    1596,
    10855,
    65,
    '21.05',
    15,
    '0.15',
    );

    $this->addOrderDetail(
    1602,
    10858,
    7,
    '30.00',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    1603,
    10858,
    27,
    '43.90',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1604,
    10858,
    70,
    '15.00',
    4,
    '0.00',
    );

    $this->addOrderDetail(
    1608,
    10860,
    51,
    '53.00',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    1609,
    10860,
    76,
    '18.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1610,
    10861,
    17,
    '39.00',
    42,
    '0.00',
    );

    $this->addOrderDetail(
    1611,
    10861,
    18,
    '62.50',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1612,
    10861,
    21,
    '10.00',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    1613,
    10861,
    33,
    '2.50',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    1614,
    10861,
    62,
    '49.30',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    1617,
    10863,
    1,
    '18.00',
    20,
    '0.15',
    );

    $this->addOrderDetail(
    1618,
    10863,
    58,
    '13.25',
    12,
    '0.15',
    );

    $this->addOrderDetail(
    1619,
    10864,
    35,
    '18.00',
    4,
    '0.00',
    );

    $this->addOrderDetail(
    1620,
    10864,
    67,
    '14.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1626,
    10867,
    53,
    '32.80',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    1630,
    10869,
    1,
    '18.00',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    1631,
    10869,
    11,
    '21.00',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1632,
    10869,
    23,
    '9.00',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    1633,
    10869,
    68,
    '12.50',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1636,
    10871,
    6,
    '25.00',
    50,
    '0.05',
    );

    $this->addOrderDetail(
    1637,
    10871,
    16,
    '17.45',
    12,
    '0.05',
    );

    $this->addOrderDetail(
    1638,
    10871,
    17,
    '39.00',
    16,
    '0.05',
    );

    $this->addOrderDetail(
    1649,
    10876,
    46,
    '12.00',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    1650,
    10876,
    64,
    '33.25',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1661,
    10882,
    42,
    '14.00',
    25,
    '0.00',
    );

    $this->addOrderDetail(
    1662,
    10882,
    49,
    '20.00',
    20,
    '0.15',
    );

    $this->addOrderDetail(
    1663,
    10882,
    54,
    '7.45',
    32,
    '0.15',
    );

    $this->addOrderDetail(
    1664,
    10883,
    24,
    '4.50',
    8,
    '0.00',
    );

    $this->addOrderDetail(
    1665,
    10884,
    21,
    '10.00',
    40,
    '0.05',
    );

    $this->addOrderDetail(
    1666,
    10884,
    56,
    '38.00',
    21,
    '0.05',
    );

    $this->addOrderDetail(
    1667,
    10884,
    65,
    '21.05',
    12,
    '0.05',
    );

    $this->addOrderDetail(
    1668,
    10885,
    2,
    '19.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1669,
    10885,
    24,
    '4.50',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    1670,
    10885,
    70,
    '15.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1671,
    10885,
    77,
    '13.00',
    25,
    '0.00',
    );

    $this->addOrderDetail(
    1678,
    10889,
    11,
    '21.00',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    1679,
    10889,
    38,
    '263.50',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    1680,
    10890,
    17,
    '39.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1681,
    10890,
    34,
    '14.00',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1682,
    10890,
    41,
    '9.65',
    14,
    '0.00',
    );

    $this->addOrderDetail(
    1684,
    10892,
    59,
    '55.00',
    40,
    '0.05',
    );

    $this->addOrderDetail(
    1690,
    10894,
    13,
    '6.00',
    28,
    '0.05',
    );

    $this->addOrderDetail(
    1691,
    10894,
    69,
    '36.00',
    50,
    '0.05',
    );

    $this->addOrderDetail(
    1692,
    10894,
    75,
    '7.75',
    120,
    '0.05',
    );

    $this->addOrderDetail(
    1693,
    10895,
    24,
    '4.50',
    110,
    '0.00',
    );

    $this->addOrderDetail(
    1694,
    10895,
    39,
    '18.00',
    45,
    '0.00',
    );

    $this->addOrderDetail(
    1695,
    10895,
    40,
    '18.40',
    91,
    '0.00',
    );

    $this->addOrderDetail(
    1696,
    10895,
    60,
    '34.00',
    100,
    '0.00',
    );

    $this->addOrderDetail(
    1697,
    10896,
    45,
    '9.50',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1698,
    10896,
    56,
    '38.00',
    16,
    '0.00',
    );

    $this->addOrderDetail(
    1702,
    10899,
    39,
    '18.00',
    8,
    '0.15',
    );

    $this->addOrderDetail(
    1704,
    10901,
    41,
    '9.65',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1705,
    10901,
    71,
    '21.50',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1711,
    10904,
    58,
    '13.25',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1712,
    10904,
    62,
    '49.30',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    1715,
    10907,
    75,
    '7.75',
    14,
    '0.00',
    );

    $this->addOrderDetail(
    1741,
    10918,
    1,
    '18.00',
    60,
    '0.25',
    );

    $this->addOrderDetail(
    1742,
    10918,
    60,
    '34.00',
    25,
    '0.25',
    );

    $this->addOrderDetail(
    1743,
    10919,
    16,
    '17.45',
    24,
    '0.00',
    );

    $this->addOrderDetail(
    1744,
    10919,
    25,
    '14.00',
    24,
    '0.00',
    );

    $this->addOrderDetail(
    1745,
    10919,
    40,
    '18.40',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1746,
    10920,
    50,
    '16.25',
    24,
    '0.00',
    );

    $this->addOrderDetail(
    1751,
    10923,
    42,
    '14.00',
    10,
    '0.20',
    );

    $this->addOrderDetail(
    1752,
    10923,
    43,
    '46.00',
    10,
    '0.20',
    );

    $this->addOrderDetail(
    1753,
    10923,
    67,
    '14.00',
    24,
    '0.20',
    );

    $this->addOrderDetail(
    1763,
    10927,
    20,
    '81.00',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    1764,
    10927,
    52,
    '7.00',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    1765,
    10927,
    76,
    '18.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1771,
    10930,
    21,
    '10.00',
    36,
    '0.00',
    );

    $this->addOrderDetail(
    1772,
    10930,
    27,
    '43.90',
    25,
    '0.00',
    );

    $this->addOrderDetail(
    1773,
    10930,
    55,
    '24.00',
    25,
    '0.20',
    );

    $this->addOrderDetail(
    1774,
    10930,
    58,
    '13.25',
    30,
    '0.20',
    );

    $this->addOrderDetail(
    1775,
    10931,
    13,
    '6.00',
    42,
    '0.15',
    );

    $this->addOrderDetail(
    1776,
    10931,
    57,
    '19.50',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1777,
    10932,
    16,
    '17.45',
    30,
    '0.10',
    );

    $this->addOrderDetail(
    1778,
    10932,
    62,
    '49.30',
    14,
    '0.10',
    );

    $this->addOrderDetail(
    1779,
    10932,
    72,
    '34.80',
    16,
    '0.00',
    );

    $this->addOrderDetail(
    1780,
    10932,
    75,
    '7.75',
    20,
    '0.10',
    );

    $this->addOrderDetail(
    1781,
    10933,
    53,
    '32.80',
    2,
    '0.00',
    );

    $this->addOrderDetail(
    1782,
    10933,
    61,
    '28.50',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1787,
    10936,
    36,
    '19.00',
    30,
    '0.20',
    );

    $this->addOrderDetail(
    1796,
    10940,
    7,
    '30.00',
    8,
    '0.00',
    );

    $this->addOrderDetail(
    1797,
    10940,
    13,
    '6.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1798,
    10941,
    31,
    '12.50',
    44,
    '0.25',
    );

    $this->addOrderDetail(
    1799,
    10941,
    62,
    '49.30',
    30,
    '0.25',
    );

    $this->addOrderDetail(
    1800,
    10941,
    68,
    '12.50',
    80,
    '0.25',
    );

    $this->addOrderDetail(
    1801,
    10941,
    72,
    '34.80',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    1803,
    10943,
    13,
    '6.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1804,
    10943,
    22,
    '21.00',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    1805,
    10943,
    46,
    '12.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1806,
    10944,
    11,
    '21.00',
    5,
    '0.25',
    );

    $this->addOrderDetail(
    1807,
    10944,
    44,
    '19.45',
    18,
    '0.25',
    );

    $this->addOrderDetail(
    1808,
    10944,
    56,
    '38.00',
    18,
    '0.00',
    );

    $this->addOrderDetail(
    1814,
    10947,
    59,
    '55.00',
    4,
    '0.00',
    );

    $this->addOrderDetail(
    1818,
    10949,
    6,
    '25.00',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    1819,
    10949,
    10,
    '31.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1820,
    10949,
    17,
    '39.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1821,
    10949,
    62,
    '49.30',
    60,
    '0.00',
    );

    $this->addOrderDetail(
    1823,
    10951,
    33,
    '2.50',
    15,
    '0.05',
    );

    $this->addOrderDetail(
    1824,
    10951,
    41,
    '9.65',
    6,
    '0.05',
    );

    $this->addOrderDetail(
    1825,
    10951,
    75,
    '7.75',
    50,
    '0.05',
    );

    $this->addOrderDetail(
    1828,
    10953,
    20,
    '81.00',
    50,
    '0.05',
    );

    $this->addOrderDetail(
    1829,
    10953,
    31,
    '12.50',
    50,
    '0.05',
    );

    $this->addOrderDetail(
    1830,
    10954,
    16,
    '17.45',
    28,
    '0.15',
    );

    $this->addOrderDetail(
    1831,
    10954,
    31,
    '12.50',
    25,
    '0.15',
    );

    $this->addOrderDetail(
    1832,
    10954,
    45,
    '9.50',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1833,
    10954,
    60,
    '34.00',
    24,
    '0.15',
    );

    $this->addOrderDetail(
    1838,
    10957,
    30,
    '25.89',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1839,
    10957,
    35,
    '18.00',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    1840,
    10957,
    64,
    '33.25',
    8,
    '0.00',
    );

    $this->addOrderDetail(
    1845,
    10960,
    24,
    '4.50',
    10,
    '0.25',
    );

    $this->addOrderDetail(
    1846,
    10960,
    41,
    '9.65',
    24,
    '0.00',
    );

    $this->addOrderDetail(
    1854,
    10963,
    60,
    '34.00',
    2,
    '0.15',
    );

    $this->addOrderDetail(
    1855,
    10964,
    18,
    '62.50',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1856,
    10964,
    38,
    '263.50',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    1857,
    10964,
    69,
    '36.00',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1858,
    10965,
    51,
    '53.00',
    16,
    '0.00',
    );

    $this->addOrderDetail(
    1859,
    10966,
    37,
    '26.00',
    8,
    '0.00',
    );

    $this->addOrderDetail(
    1860,
    10966,
    56,
    '38.00',
    12,
    '0.15',
    );

    $this->addOrderDetail(
    1861,
    10966,
    62,
    '49.30',
    12,
    '0.15',
    );

    $this->addOrderDetail(
    1864,
    10968,
    12,
    '38.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1865,
    10968,
    24,
    '4.50',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1866,
    10968,
    64,
    '33.25',
    4,
    '0.00',
    );

    $this->addOrderDetail(
    1869,
    10971,
    29,
    '123.79',
    14,
    '0.00',
    );

    $this->addOrderDetail(
    1870,
    10972,
    17,
    '39.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1871,
    10972,
    33,
    '2.50',
    7,
    '0.00',
    );

    $this->addOrderDetail(
    1872,
    10973,
    26,
    '31.23',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    1873,
    10973,
    41,
    '9.65',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1874,
    10973,
    75,
    '7.75',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1875,
    10974,
    63,
    '43.90',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1876,
    10975,
    8,
    '40.00',
    16,
    '0.00',
    );

    $this->addOrderDetail(
    1877,
    10975,
    75,
    '7.75',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1878,
    10976,
    28,
    '45.60',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1883,
    10978,
    8,
    '40.00',
    20,
    '0.15',
    );

    $this->addOrderDetail(
    1884,
    10978,
    21,
    '10.00',
    40,
    '0.15',
    );

    $this->addOrderDetail(
    1885,
    10978,
    40,
    '18.40',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1886,
    10978,
    44,
    '19.45',
    6,
    '0.15',
    );

    $this->addOrderDetail(
    1887,
    10979,
    7,
    '30.00',
    18,
    '0.00',
    );

    $this->addOrderDetail(
    1888,
    10979,
    12,
    '38.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1889,
    10979,
    24,
    '4.50',
    80,
    '0.00',
    );

    $this->addOrderDetail(
    1890,
    10979,
    27,
    '43.90',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1891,
    10979,
    31,
    '12.50',
    24,
    '0.00',
    );

    $this->addOrderDetail(
    1892,
    10979,
    63,
    '43.90',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    1895,
    10982,
    7,
    '30.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1896,
    10982,
    43,
    '46.00',
    9,
    '0.00',
    );

    $this->addOrderDetail(
    1897,
    10983,
    13,
    '6.00',
    84,
    '0.15',
    );

    $this->addOrderDetail(
    1898,
    10983,
    57,
    '19.50',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1899,
    10984,
    16,
    '17.45',
    55,
    '0.00',
    );

    $this->addOrderDetail(
    1900,
    10984,
    24,
    '4.50',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1901,
    10984,
    36,
    '19.00',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    1909,
    10987,
    7,
    '30.00',
    60,
    '0.00',
    );

    $this->addOrderDetail(
    1910,
    10987,
    43,
    '46.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1911,
    10987,
    72,
    '34.80',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1912,
    10988,
    7,
    '30.00',
    60,
    '0.00',
    );

    $this->addOrderDetail(
    1913,
    10988,
    62,
    '49.30',
    40,
    '0.10',
    );

    $this->addOrderDetail(
    1917,
    10990,
    21,
    '10.00',
    65,
    '0.00',
    );

    $this->addOrderDetail(
    1918,
    10990,
    34,
    '14.00',
    60,
    '0.15',
    );

    $this->addOrderDetail(
    1919,
    10990,
    55,
    '24.00',
    65,
    '0.15',
    );

    $this->addOrderDetail(
    1920,
    10990,
    61,
    '28.50',
    66,
    '0.15',
    );

    $this->addOrderDetail(
    1924,
    10992,
    72,
    '34.80',
    2,
    '0.00',
    );

    $this->addOrderDetail(
    1931,
    10997,
    32,
    '32.00',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    1932,
    10997,
    46,
    '12.00',
    20,
    '0.25',
    );

    $this->addOrderDetail(
    1933,
    10997,
    52,
    '7.00',
    20,
    '0.25',
    );

    $this->addOrderDetail(
    1941,
    11000,
    4,
    '22.00',
    25,
    '0.25',
    );

    $this->addOrderDetail(
    1942,
    11000,
    24,
    '4.50',
    30,
    '0.25',
    );

    $this->addOrderDetail(
    1943,
    11000,
    77,
    '13.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1948,
    11002,
    13,
    '6.00',
    56,
    '0.00',
    );

    $this->addOrderDetail(
    1949,
    11002,
    35,
    '18.00',
    15,
    '0.15',
    );

    $this->addOrderDetail(
    1950,
    11002,
    42,
    '14.00',
    24,
    '0.15',
    );

    $this->addOrderDetail(
    1951,
    11002,
    55,
    '24.00',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    1952,
    11003,
    1,
    '18.00',
    4,
    '0.00',
    );

    $this->addOrderDetail(
    1953,
    11003,
    40,
    '18.40',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1954,
    11003,
    52,
    '7.00',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1955,
    11004,
    26,
    '31.23',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1956,
    11004,
    76,
    '18.00',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    1959,
    11006,
    1,
    '18.00',
    8,
    '0.00',
    );

    $this->addOrderDetail(
    1960,
    11006,
    29,
    '123.79',
    2,
    '0.25',
    );

    $this->addOrderDetail(
    1961,
    11007,
    8,
    '40.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1962,
    11007,
    29,
    '123.79',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1963,
    11007,
    42,
    '14.00',
    14,
    '0.00',
    );

    $this->addOrderDetail(
    1964,
    11008,
    28,
    '45.60',
    70,
    '0.05',
    );

    $this->addOrderDetail(
    1965,
    11008,
    34,
    '14.00',
    90,
    '0.05',
    );

    $this->addOrderDetail(
    1966,
    11008,
    71,
    '21.50',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    1981,
    11014,
    41,
    '9.65',
    28,
    '0.10',
    );

    $this->addOrderDetail(
    1984,
    11016,
    31,
    '12.50',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    1985,
    11016,
    36,
    '19.00',
    16,
    '0.00',
    );

    $this->addOrderDetail(
    1986,
    11017,
    3,
    '10.00',
    25,
    '0.00',
    );

    $this->addOrderDetail(
    1987,
    11017,
    59,
    '55.00',
    110,
    '0.00',
    );

    $this->addOrderDetail(
    1988,
    11017,
    70,
    '15.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    1989,
    11018,
    12,
    '38.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    1990,
    11018,
    18,
    '62.50',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    1991,
    11018,
    56,
    '38.00',
    5,
    '0.00',
    );

    $this->addOrderDetail(
    2002,
    11023,
    7,
    '30.00',
    4,
    '0.00',
    );

    $this->addOrderDetail(
    2003,
    11023,
    43,
    '46.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    2004,
    11024,
    26,
    '31.23',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    2005,
    11024,
    33,
    '2.50',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    2006,
    11024,
    65,
    '21.05',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    2007,
    11024,
    71,
    '21.50',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    2012,
    11027,
    24,
    '4.50',
    30,
    '0.25',
    );

    $this->addOrderDetail(
    2013,
    11027,
    62,
    '49.30',
    21,
    '0.25',
    );

    $this->addOrderDetail(
    2016,
    11029,
    56,
    '38.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    2017,
    11029,
    63,
    '43.90',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    2018,
    11030,
    2,
    '19.00',
    100,
    '0.25',
    );

    $this->addOrderDetail(
    2019,
    11030,
    5,
    '21.35',
    70,
    '0.00',
    );

    $this->addOrderDetail(
    2020,
    11030,
    29,
    '123.79',
    60,
    '0.25',
    );

    $this->addOrderDetail(
    2021,
    11030,
    59,
    '55.00',
    100,
    '0.25',
    );

    $this->addOrderDetail(
    2022,
    11031,
    1,
    '18.00',
    45,
    '0.00',
    );

    $this->addOrderDetail(
    2023,
    11031,
    13,
    '6.00',
    80,
    '0.00',
    );

    $this->addOrderDetail(
    2024,
    11031,
    24,
    '4.50',
    21,
    '0.00',
    );

    $this->addOrderDetail(
    2025,
    11031,
    64,
    '33.25',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    2026,
    11031,
    71,
    '21.50',
    16,
    '0.00',
    );

    $this->addOrderDetail(
    2027,
    11032,
    36,
    '19.00',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    2028,
    11032,
    38,
    '263.50',
    25,
    '0.00',
    );

    $this->addOrderDetail(
    2029,
    11032,
    59,
    '55.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    2030,
    11033,
    53,
    '32.80',
    70,
    '0.10',
    );

    $this->addOrderDetail(
    2031,
    11033,
    69,
    '36.00',
    36,
    '0.10',
    );

    $this->addOrderDetail(
    2032,
    11034,
    21,
    '10.00',
    15,
    '0.10',
    );

    $this->addOrderDetail(
    2033,
    11034,
    44,
    '19.45',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    2034,
    11034,
    61,
    '28.50',
    6,
    '0.00',
    );

    $this->addOrderDetail(
    2035,
    11035,
    1,
    '18.00',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    2036,
    11035,
    35,
    '18.00',
    60,
    '0.00',
    );

    $this->addOrderDetail(
    2037,
    11035,
    42,
    '14.00',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    2038,
    11035,
    54,
    '7.45',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    2042,
    11038,
    40,
    '18.40',
    5,
    '0.20',
    );

    $this->addOrderDetail(
    2043,
    11038,
    52,
    '7.00',
    2,
    '0.00',
    );

    $this->addOrderDetail(
    2044,
    11038,
    71,
    '21.50',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    2045,
    11039,
    28,
    '45.60',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    2046,
    11039,
    35,
    '18.00',
    24,
    '0.00',
    );

    $this->addOrderDetail(
    2047,
    11039,
    49,
    '20.00',
    60,
    '0.00',
    );

    $this->addOrderDetail(
    2048,
    11039,
    57,
    '19.50',
    28,
    '0.00',
    );

    $this->addOrderDetail(
    2049,
    11040,
    21,
    '10.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    2050,
    11041,
    2,
    '19.00',
    30,
    '0.20',
    );

    $this->addOrderDetail(
    2051,
    11041,
    63,
    '43.90',
    30,
    '0.00',
    );

    $this->addOrderDetail(
    2054,
    11043,
    11,
    '21.00',
    10,
    '0.00',
    );

    $this->addOrderDetail(
    2056,
    11045,
    33,
    '2.50',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    2057,
    11045,
    51,
    '53.00',
    24,
    '0.00',
    );

    $this->addOrderDetail(
    2061,
    11047,
    1,
    '18.00',
    25,
    '0.25',
    );

    $this->addOrderDetail(
    2062,
    11047,
    5,
    '21.35',
    30,
    '0.25',
    );

    $this->addOrderDetail(
    2063,
    11048,
    68,
    '12.50',
    42,
    '0.00',
    );

    $this->addOrderDetail(
    2067,
    11051,
    24,
    '4.50',
    10,
    '0.20',
    );

    $this->addOrderDetail(
    2070,
    11053,
    18,
    '62.50',
    35,
    '0.20',
    );

    $this->addOrderDetail(
    2071,
    11053,
    32,
    '32.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    2072,
    11053,
    64,
    '33.25',
    25,
    '0.20',
    );

    $this->addOrderDetail(
    2075,
    11055,
    24,
    '4.50',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    2076,
    11055,
    25,
    '14.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    2077,
    11055,
    51,
    '53.00',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    2078,
    11055,
    57,
    '19.50',
    20,
    '0.00',
    );

    $this->addOrderDetail(
    2079,
    11056,
    7,
    '30.00',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    2080,
    11056,
    55,
    '24.00',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    2081,
    11056,
    60,
    '34.00',
    50,
    '0.00',
    );

    $this->addOrderDetail(
    2082,
    11057,
    70,
    '15.00',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    2091,
    11061,
    60,
    '34.00',
    15,
    '0.00',
    );

    $this->addOrderDetail(
    2097,
    11064,
    17,
    '39.00',
    77,
    '0.10',
    );

    $this->addOrderDetail(
    2098,
    11064,
    41,
    '9.65',
    12,
    '0.00',
    );

    $this->addOrderDetail(
    2099,
    11064,
    53,
    '32.80',
    25,
    '0.10',
    );

    $this->addOrderDetail(
    2100,
    11064,
    55,
    '24.00',
    4,
    '0.10',
    );

    $this->addOrderDetail(
    2101,
    11064,
    68,
    '12.50',
    55,
    '0.00',
    );

    $this->addOrderDetail(
    2102,
    11065,
    30,
    '25.89',
    4,
    '0.25',
    );

    $this->addOrderDetail(
    2103,
    11065,
    54,
    '7.45',
    20,
    '0.25',
    );

    $this->addOrderDetail(
    2104,
    11066,
    16,
    '17.45',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    2105,
    11066,
    19,
    '9.20',
    42,
    '0.00',
    );

    $this->addOrderDetail(
    2106,
    11066,
    34,
    '14.00',
    35,
    '0.00',
    );

    $this->addOrderDetail(
    2116,
    11071,
    7,
    '30.00',
    15,
    '0.05',
    );

    $this->addOrderDetail(
    2117,
    11071,
    13,
    '6.00',
    10,
    '0.05',
    );

    $this->addOrderDetail(
    2118,
    11072,
    2,
    '19.00',
    8,
    '0.00',
    );

    $this->addOrderDetail(
    2119,
    11072,
    41,
    '9.65',
    40,
    '0.00',
    );

    $this->addOrderDetail(
    2120,
    11072,
    50,
    '16.25',
    22,
    '0.00',
    );

    $this->addOrderDetail(
    2121,
    11072,
    64,
    '33.25',
    130,
    '0.00',
    );

    $this->addOrderDetail(
    2125,
    11075,
    2,
    '19.00',
    10,
    '0.15',
    );

    $this->addOrderDetail(
    2126,
    11075,
    46,
    '12.00',
    30,
    '0.15',
    );

    $this->addOrderDetail(
    2127,
    11075,
    76,
    '18.00',
    2,
    '0.15',
    );

    $this->addOrderDetail(
    2128,
    11076,
    6,
    '25.00',
    20,
    '0.25',
    );

    $this->addOrderDetail(
    2129,
    11076,
    14,
    '23.25',
    20,
    '0.25',
    );

    $this->addOrderDetail(
    2130,
    11076,
    19,
    '9.20',
    10,
    '0.25',
    );

    $this->addOrderDetail(
    2131,
    11077,
    2,
    '19.00',
    24,
    '0.20',
    );

    $this->addOrderDetail(
    2132,
    11077,
    3,
    '10.00',
    4,
    '0.00',
    );

    $this->addOrderDetail(
    2133,
    11077,
    4,
    '22.00',
    1,
    '0.00',
    );

    $this->addOrderDetail(
    2134,
    11077,
    6,
    '25.00',
    1,
    '0.02',
    );

    $this->addOrderDetail(
    2135,
    11077,
    7,
    '30.00',
    1,
    '0.05',
    );

    $this->addOrderDetail(
    2136,
    11077,
    8,
    '40.00',
    2,
    '0.10',
    );

    $this->addOrderDetail(
    2137,
    11077,
    10,
    '31.00',
    1,
    '0.00',
    );

    $this->addOrderDetail(
    2138,
    11077,
    12,
    '38.00',
    2,
    '0.05',
    );

    $this->addOrderDetail(
    2139,
    11077,
    13,
    '6.00',
    4,
    '0.00',
    );

    $this->addOrderDetail(
    2140,
    11077,
    14,
    '23.25',
    1,
    '0.03',
    );

    $this->addOrderDetail(
    2141,
    11077,
    16,
    '17.45',
    2,
    '0.03',
    );

    $this->addOrderDetail(
    2142,
    11077,
    20,
    '81.00',
    1,
    '0.04',
    );

    $this->addOrderDetail(
    2143,
    11077,
    23,
    '9.00',
    2,
    '0.00',
    );

    $this->addOrderDetail(
    2144,
    11077,
    32,
    '32.00',
    1,
    '0.00',
    );

    $this->addOrderDetail(
    2145,
    11077,
    39,
    '18.00',
    2,
    '0.05',
    );

    $this->addOrderDetail(
    2146,
    11077,
    41,
    '9.65',
    3,
    '0.00',
    );

    $this->addOrderDetail(
    2147,
    11077,
    46,
    '12.00',
    3,
    '0.02',
    );

    $this->addOrderDetail(
    2148,
    11077,
    52,
    '7.00',
    2,
    '0.00',
    );

    $this->addOrderDetail(
    2149,
    11077,
    55,
    '24.00',
    2,
    '0.00',
    );

    $this->addOrderDetail(
    2150,
    11077,
    60,
    '34.00',
    2,
    '0.06',
    );

    $this->addOrderDetail(
    2151,
    11077,
    64,
    '33.25',
    2,
    '0.03',
    );

    $this->addOrderDetail(
    2152,
    11077,
    66,
    '17.00',
    1,
    '0.00',
    );

    $this->addOrderDetail(
    2153,
    11077,
    73,
    '15.00',
    2,
    '0.01',
    );

    $this->addOrderDetail(
    2154,
    11077,
    75,
    '7.75',
    4,
    '0.00',
    );

    $this->addOrderDetail(
    2155,
    11077,
    77,
    '13.00',
    2,
    '0.00',
    );
    }
     */

    private function addSalesOrder(
        $orderId,
        $custId,
        $productId,
        $employeeId,
        $orderDate,
        $requiredDate,
        $shippedDate,
        // $shipperid,
        $freight,
        $shipName,
        $shipAddress,
        $shipCity,
        $shipRegion,
        $shipPostalCode,
        $shipCountry
    ) {
        Capsule::table($this->salesOrder)->updateOrInsert(
            ["orderId" => $orderId],
            [
                "custId"         => $custId,
                "employeeId"     => $employeeId,
                "productId"      => $productId,
                "orderDate"      => $orderDate,
                "requiredDate"   => $requiredDate,
                "shippedDate"    => $shippedDate,
                // "shipperid" => $shipperid,
                "freight"        => $freight,
                "shipName"       => $shipName,
                "shipAddress"    => $shipAddress,
                "shipCity"       => $shipCity,
                "shipRegion"     => $shipRegion,
                "shipPostalCode" => $shipPostalCode,
                "shipCountry"    => $shipCountry
            ]
        );

        return Capsule::table($this->salesOrder)->where("orderId", $orderId)->first();

    }

    private function insertSalesOrders()
    {
        if(Capsule::table($this->salesOrder)->count() !== 0)
            return;

        $this->addSalesOrder(
            10252,
            76,
            1,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '51.30',
            'Ship to 76-B',
            'Boulevard Tirou, 9012',
            'Charleroi',
            null,
            '10318',
            'Belgium'
        );

        $this->addSalesOrder(
            10254,
            14,
            2,
            5,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '22.98',
            'Destination YUJRD',
            'Hauptstr. 1234',
            'Bern',
            null,
            '10139',
            'Switzerland'
        );

        $this->addSalesOrder(
            10255,
            68,
            3,
            9,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '148.33',
            'Ship to 68-A',
            'Starenweg 6789',
            'Genève',
            null,
            '10294',
            'Switzerland'
        );

        $this->addSalesOrder(
            10257,
            35,
            4,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '81.91',
            'Destination JYDLM',
            'Carrera1234 con Ave. Carlos Soublette #8-35',
            'San Cristóbal',
            'Táchira',
            '10199',
            'Venezuela'
        );

        $this->addSalesOrder(
            10258,
            20,
            5,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '140.51',
            'Destination RVDMF',
            'Kirchgasse 9012',
            'Graz',
            null,
            '10157',
            'Austria'
        );

        $this->addSalesOrder(
            10263,
            20,
            6,
            9,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '146.06',
            'Destination FFXKT',
            'Kirchgasse 0123',
            'Graz',
            null,
            '10158',
            'Austria'
        );

        $this->addSalesOrder(
            10268,
            33,
            7,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '66.29',
            'Destination QJVQH',
            '5ª Ave. Los Palos Grandes 5678',
            'Caracas',
            'DF',
            '10193',
            'Venezuela'
        );

        $this->addSalesOrder(
            10283,
            46,
            8,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '84.81',
            'Ship to 46-A',
            'Carrera 0123 con Ave. Bolívar #65-98 Llano Largo',
            'Barquisimeto',
            'Lara',
            '10227',
            'Venezuela'
        );

        $this->addSalesOrder(
            10289,
            11,
            9,
            7,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '22.77',
            'Destination DLEUN',
            'Fauntleroy Circus 4567',
            'London',
            null,
            '10132',
            'UK'
        );

        $this->addSalesOrder(
            10296,
            46,
            10,
            6,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '0.12',
            'Ship to 46-C',
            'Carrera 2345 con Ave. Bolívar #65-98 Llano Largo',
            'Barquisimeto',
            'Lara',
            '10229',
            'Venezuela'
        );

        $this->addSalesOrder(
            10302,
            76,
            11,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '6.27',
            'Ship to 76-B',
            'Boulevard Tirou, 9012',
            'Charleroi',
            null,
            '10318',
            'Belgium'
        );

        $this->addSalesOrder(
            10315,
            38,
            12,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '41.76',
            'Destination AXVHD',
            'Garden House Crowther Way 9012',
            'Cowes',
            'Isle of Wight',
            '10207',
            'UK'
        );

        $this->addSalesOrder(
            10318,
            38,
            13,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '4.73',
            'Destination AXVHD',
            'Garden House Crowther Way 9012',
            'Cowes',
            'Isle of Wight',
            '10207',
            'UK'
        );

        $this->addSalesOrder(
            10321,
            38,
            14,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '3.43',
            'Destination LMVGS',
            'Garden House Crowther Way 8901',
            'Cowes',
            'Isle of Wight',
            '10206',
            'UK'
        );

        $this->addSalesOrder(
            10328,
            28,
            15,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '87.03',
            'Destination CIRQO',
            'Jardim das rosas n. 8901',
            'Lisboa',
            null,
            '10176',
            'Portugal'
        );

        $this->addSalesOrder(
            10330,
            46,
            16,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '12.75',
            'Ship to 46-A',
            'Carrera 0123 con Ave. Bolívar #65-98 Llano Largo',
            'Barquisimeto',
            'Lara',
            '10227',
            'Venezuela'
        );

        $this->addSalesOrder(
            10332,
            51,
            17,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '52.84',
            'Ship to 51-B',
            '7890 rue St. Laurent',
            'Montréal',
            'Québec',
            '10245',
            'Canada'
        );

        $this->addSalesOrder(
            10336,
            60,
            18,
            7,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '15.51',
            'Ship to 60-B',
            'Estrada da saúde n. 3456',
            'Lisboa',
            null,
            '10271',
            'Portugal'
        );

        $this->addSalesOrder(
            10339,
            51,
            19,
            2,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '15.66',
            'Ship to 51-C',
            '8901 rue St. Laurent',
            'Montréal',
            'Québec',
            '10246',
            'Canada'
        );

        $this->addSalesOrder(
            10351,
            20,
            20,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '162.33',
            'Destination RVDMF',
            'Kirchgasse 9012',
            'Graz',
            null,
            '10157',
            'Austria'
        );

        $this->addSalesOrder(
            10352,
            28,
            21,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '1.30',
            'Destination OTSWR',
            'Jardim das rosas n. 9012',
            'Lisboa',
            null,
            '10177',
            'Portugal'
        );

        $this->addSalesOrder(
            10353,
            59,
            22,
            7,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '360.63',
            'Ship to 59-B',
            'Geislweg 7890',
            'Salzburg',
            null,
            '10265',
            'Austria'
        );

        $this->addSalesOrder(
            10355,
            4,
            23,
            6,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '41.95',
            'Ship to 4-A',
            'Brook Farm Stratford St. Mary 0123',
            'Colchester',
            'Essex',
            '10238',
            'UK'
        );

        $this->addSalesOrder(
            10357,
            46,
            23,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '34.88',
            'Ship to 46-B',
            'Carrera 1234 con Ave. Bolívar #65-98 Llano Largo',
            'Barquisimeto',
            'Lara',
            '10228',
            'Venezuela'
        );

        $this->addSalesOrder(
            10359,
            72,
            23,
            5,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '288.43',
            'Ship to 72-C',
            '1234 Wadhurst Rd.',
            'London',
            null,
            '10309',
            'UK'
        );

        $this->addSalesOrder(
            10364,
            19,
            24,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '71.97',
            'Destination QTKCU',
            '3456 King George',
            'London',
            null,
            '10151',
            'UK'
        );

        $this->addSalesOrder(
            10368,
            20,
            24,
            2,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '101.95',
            'Destination RVDMF',
            'Kirchgasse 9012',
            'Graz',
            null,
            '10157',
            'Austria'
        );

        $this->addSalesOrder(
            10370,
            14,
            24,
            6,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '1.17',
            'Destination YUJRD',
            'Hauptstr. 1234',
            'Bern',
            null,
            '10139',
            'Switzerland'
        );

        $this->addSalesOrder(
            10376,
            51,
            24,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '20.39',
            'Ship to 51-B',
            '7890 rue St. Laurent',
            'Montréal',
            'Québec',
            '10245',
            'Canada'
        );

        $this->addSalesOrder(
            10377,
            72,
            25,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '22.21',
            'Ship to 72-C',
            '1234 Wadhurst Rd.',
            'London',
            null,
            '10309',
            'UK'
        );

        $this->addSalesOrder(
            10381,
            46,
            25,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '7.99',
            'Ship to 46-C',
            'Carrera 2345 con Ave. Bolívar #65-98 Llano Largo',
            'Barquisimeto',
            'Lara',
            '10229',
            'Venezuela'
        );

        $this->addSalesOrder(
            10382,
            20,
            25,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '94.77',
            'Destination FFXKT',
            'Kirchgasse 0123',
            'Graz',
            null,
            '10158',
            'Austria'
        );

        $this->addSalesOrder(
            10383,
            4,
            25,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '34.24',
            'Ship to 4-B',
            'Brook Farm Stratford St. Mary 1234',
            'Colchester',
            'Essex',
            '10239',
            'UK'
        );

        $this->addSalesOrder(
            10388,
            72,
            26,
            2,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '34.86',
            'Ship to 72-C',
            '1234 Wadhurst Rd.',
            'London',
            null,
            '10309',
            'UK'
        );

        $this->addSalesOrder(
            10389,
            10,
            26,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '47.42',
            'Destination OLSSJ',
            '2345 Tsawassen Blvd.',
            'Tsawassen',
            'BC',
            '10130',
            'Canada'
        );

        $this->addSalesOrder(
            10390,
            20,
            26,
            6,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '126.38',
            'Destination RVDMF',
            'Kirchgasse 9012',
            'Graz',
            null,
            '10157',
            'Austria'
        );

        $this->addSalesOrder(
            10392,
            59,
            26,
            2,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '122.46',
            'Ship to 59-A',
            'Geislweg 6789',
            'Salzburg',
            null,
            '10264',
            'Austria'
        );

        $this->addSalesOrder(
            10395,
            35,
            26,
            6,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '184.41',
            'Destination JYDLM',
            'Carrera1234 con Ave. Carlos Soublette #8-35',
            'San Cristóbal',
            'Táchira',
            '10199',
            'Venezuela'
        );

        $this->addSalesOrder(
            10397,
            60,
            26,
            5,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '60.26',
            'Ship to 60-A',
            'Estrada da saúde n. 2345',
            'Lisboa',
            null,
            '10270',
            'Portugal'
        );

        $this->addSalesOrder(
            10400,
            19,
            27,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '83.93',
            'Destination BBMRT',
            '4567 King George',
            'London',
            null,
            '10152',
            'UK'
        );

        $this->addSalesOrder(
            10402,
            20,
            27,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '67.88',
            'Destination FFXKT',
            'Kirchgasse 0123',
            'Graz',
            null,
            '10158',
            'Austria'
        );

        $this->addSalesOrder(
            10403,
            20,
            27,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '73.79',
            'Destination RVDMF',
            'Kirchgasse 9012',
            'Graz',
            null,
            '10157',
            'Austria'
        );

        $this->addSalesOrder(
            10405,
            47,
            27,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '34.82',
            'Ship to 47-B',
            'Ave. 5 de Mayo Porlamar 4567',
            'I. de Margarita',
            'Nueva Esparta',
            '10231',
            'Venezuela'
        );

        $this->addSalesOrder(
            10410,
            10,
            27,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '2.40',
            'Destination OLSSJ',
            '2345 Tsawassen Blvd.',
            'Tsawassen',
            'BC',
            '10130',
            'Canada'
        );

        $this->addSalesOrder(
            10411,
            10,
            27,
            9,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '23.65',
            'Destination XJIBQ',
            '1234 Tsawassen Blvd.',
            'Tsawassen',
            'BC',
            '10129',
            'Canada'
        );

        $this->addSalesOrder(
            10419,
            68,
            28,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '137.35',
            'Ship to 68-A',
            'Starenweg 6789',
            'Genève',
            null,
            '10294',
            'Switzerland'
        );

        $this->addSalesOrder(
            10424,
            51,
            28,
            7,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '370.61',
            'Ship to 51-C',
            '8901 rue St. Laurent',
            'Montréal',
            'Québec',
            '10246',
            'Canada'
        );

        $this->addSalesOrder(
            10427,
            59,
            28,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '31.29',
            'Ship to 59-C',
            'Geislweg 8901',
            'Salzburg',
            null,
            '10266',
            'Austria'
        );

        $this->addSalesOrder(
            10430,
            20,
            28,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '458.78',
            'Destination CUVPF',
            'Kirchgasse 1234',
            'Graz',
            null,
            '10159',
            'Austria'
        );

        $this->addSalesOrder(
            10431,
            10,
            28,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '44.17',
            'Destination OLSSJ',
            '2345 Tsawassen Blvd.',
            'Tsawassen',
            'BC',
            '10130',
            'Canada'
        );

        $this->addSalesOrder(
            10433,
            60,
            28,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '73.83',
            'Ship to 60-A',
            'Estrada da saúde n. 2345',
            'Lisboa',
            null,
            '10270',
            'Portugal'
        );

        $this->addSalesOrder(
            10435,
            16,
            29,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '9.21',
            'Destination QKQNB',
            'Berkeley Gardens 5678  Brewery',
            'London',
            null,
            '10143',
            'UK'
        );

        $this->addSalesOrder(
            10439,
            51,
            29,
            6,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '4.07',
            'Ship to 51-C',
            '8901 rue St. Laurent',
            'Montréal',
            'Québec',
            '10246',
            'Canada'
        );

        $this->addSalesOrder(
            10442,
            20,
            29,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '47.94',
            'Destination RVDMF',
            'Kirchgasse 9012',
            'Graz',
            null,
            '10157',
            'Austria'
        );

        $this->addSalesOrder(
            10453,
            4,
            29,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '25.36',
            'Ship to 4-C',
            'Brook Farm Stratford St. Mary 2345',
            'Colchester',
            'Essex',
            '10240',
            'UK'
        );

        $this->addSalesOrder(
            10458,
            76,
            29,
            7,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '147.06',
            'Ship to 76-A',
            'Boulevard Tirou, 8901',
            'Charleroi',
            null,
            '10317',
            'Belgium'
        );

        $this->addSalesOrder(
            10461,
            46,
            30,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '148.61',
            'Ship to 46-A',
            'Carrera 0123 con Ave. Bolívar #65-98 Llano Largo',
            'Barquisimeto',
            'Lara',
            '10227',
            'Venezuela'
        );

        $this->addSalesOrder(
            10462,
            16,
            30,
            2,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '6.17',
            'Destination ARRMM',
            'Berkeley Gardens 6789  Brewery',
            'London',
            null,
            '10144',
            'UK'
        );

        $this->addSalesOrder(
            10463,
            76,
            30,
            5,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '14.78',
            'Ship to 76-B',
            'Boulevard Tirou, 9012',
            'Charleroi',
            null,
            '10318',
            'Belgium'
        );

        $this->addSalesOrder(
            10464,
            28,
            30,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '89.00',
            'Destination OTSWR',
            'Jardim das rosas n. 9012',
            'Lisboa',
            null,
            '10177',
            'Portugal'
        );

        $this->addSalesOrder(
            10471,
            11,
            30,
            2,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '45.59',
            'Destination NZASL',
            'Fauntleroy Circus 5678',
            'London',
            null,
            '10133',
            'UK'
        );

        $this->addSalesOrder(
            10472,
            72,
            31,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '4.20',
            'Ship to 72-A',
            '0123 Wadhurst Rd.',
            'London',
            null,
            '10308',
            'UK'
        );

        $this->addSalesOrder(
            10473,
            38,
            31,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '16.37',
            'Destination AXVHD',
            'Garden House Crowther Way 9012',
            'Cowes',
            'Isle of Wight',
            '10207',
            'UK'
        );

        $this->addSalesOrder(
            10475,
            76,
            31,
            9,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '68.52',
            'Ship to 76-C',
            'Boulevard Tirou, 0123',
            'Charleroi',
            null,
            '10319',
            'Belgium'
        );

        $this->addSalesOrder(
            10476,
            35,
            31,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '4.41',
            'Destination SXYQX',
            'Carrera 0123 con Ave. Carlos Soublette #8-35',
            'San Cristóbal',
            'Táchira',
            '10198',
            'Venezuela'
        );

        $this->addSalesOrder(
            10477,
            60,
            31,
            5,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '13.02',
            'Ship to 60-A',
            'Estrada da saúde n. 2345',
            'Lisboa',
            null,
            '10270',
            'Portugal'
        );

        $this->addSalesOrder(
            10484,
            11,
            31,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '6.88',
            'Destination DLEUN',
            'Fauntleroy Circus 4567',
            'London',
            null,
            '10132',
            'UK'
        );

        $this->addSalesOrder(
            10485,
            47,
            32,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '64.45',
            'Ship to 47-B',
            'Ave. 5 de Mayo Porlamar 4567',
            'I. de Margarita',
            'Nueva Esparta',
            '10231',
            'Venezuela'
        );

        $this->addSalesOrder(
            10486,
            35,
            32,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '30.53',
            'Destination UOUWK',
            'Carrera 9012 con Ave. Carlos Soublette #8-35',
            'San Cristóbal',
            'Táchira',
            '10197',
            'Venezuela'
        );

        $this->addSalesOrder(
            10489,
            59,
            32,
            6,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '5.29',
            'Ship to 59-C',
            'Geislweg 8901',
            'Salzburg',
            null,
            '10266',
            'Austria'
        );

        $this->addSalesOrder(
            10490,
            35,
            32,
            7,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '210.19',
            'Destination JYDLM',
            'Carrera1234 con Ave. Carlos Soublette #8-35',
            'San Cristóbal',
            'Táchira',
            '10199',
            'Venezuela'
        );

        $this->addSalesOrder(
            10491,
            28,
            32,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '16.96',
            'Destination OTSWR',
            'Jardim das rosas n. 9012',
            'Lisboa',
            null,
            '10177',
            'Portugal'
        );

        $this->addSalesOrder(
            10492,
            10,
            33,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '62.89',
            'Destination XJIBQ',
            '1234 Tsawassen Blvd.',
            'Tsawassen',
            'BC',
            '10129',
            'Canada'
        );

        $this->addSalesOrder(
            10495,
            42,
            33,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '4.65',
            'Ship to 42-C',
            '2345 Elm St.',
            'Vancouver',
            'BC',
            '10220',
            'Canada'
        );

        $this->addSalesOrder(
            10498,
            35,
            33,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '29.75',
            'Destination SXYQX',
            'Carrera 0123 con Ave. Carlos Soublette #8-35',
            'San Cristóbal',
            'Táchira',
            '10198',
            'Venezuela'
        );

        $this->addSalesOrder(
            10499,
            46,
            33,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '102.02',
            'Ship to 46-C',
            'Carrera 2345 con Ave. Bolívar #65-98 Llano Largo',
            'Barquisimeto',
            'Lara',
            '10229',
            'Venezuela'
        );

        $this->addSalesOrder(
            10505,
            51,
            33,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '7.13',
            'Ship to 51-B',
            '7890 rue St. Laurent',
            'Montréal',
            'Québec',
            '10245',
            'Canada'
        );

        $this->addSalesOrder(
            10514,
            20,
            33,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '789.95',
            'Destination CUVPF',
            'Kirchgasse 1234',
            'Graz',
            null,
            '10159',
            'Austria'
        );

        $this->addSalesOrder(
            10517,
            53,
            33,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '32.07',
            'Ship to 53-A',
            'South House 2345 Queensbridge',
            'London',
            null,
            '10250',
            'UK'
        );

        $this->addSalesOrder(
            10519,
            14,
            33,
            6,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '91.76',
            'Destination NRTZZ',
            'Hauptstr. 0123',
            'Bern',
            null,
            '10138',
            'Switzerland'
        );

        $this->addSalesOrder(
            10523,
            72,
            34,
            7,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '77.63',
            'Ship to 72-C',
            '1234 Wadhurst Rd.',
            'London',
            null,
            '10309',
            'UK'
        );

        $this->addSalesOrder(
            10529,
            50,
            34,
            5,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '66.69',
            'Ship to 50-B',
            'Rue Joseph-Bens 4567',
            'Bruxelles',
            null,
            '10242',
            'Belgium'
        );

        $this->addSalesOrder(
            10530,
            59,
            34,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '339.22',
            'Ship to 59-C',
            'Geislweg 8901',
            'Salzburg',
            null,
            '10266',
            'Austria'
        );

        $this->addSalesOrder(
            10532,
            19,
            34,
            7,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '74.46',
            'Destination QTKCU',
            '3456 King George',
            'London',
            null,
            '10151',
            'UK'
        );

        $this->addSalesOrder(
            10537,
            68,
            34,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '78.85',
            'Ship to 68-B',
            'Starenweg 7890',
            'Genève',
            null,
            '10295',
            'Switzerland'
        );

        $this->addSalesOrder(
            10538,
            11,
            34,
            9,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '4.87',
            'Destination DLEUN',
            'Fauntleroy Circus 4567',
            'London',
            null,
            '10132',
            'UK'
        );

        $this->addSalesOrder(
            10539,
            11,
            34,
            6,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '12.36',
            'Destination DLEUN',
            'Fauntleroy Circus 4567',
            'London',
            null,
            '10132',
            'UK'
        );

        $this->addSalesOrder(
            10543,
            46,
            36,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '48.17',
            'Ship to 46-B',
            'Carrera 1234 con Ave. Bolívar #65-98 Llano Largo',
            'Barquisimeto',
            'Lara',
            '10228',
            'Venezuela'
        );

        $this->addSalesOrder(
            10547,
            72,
            36,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '178.43',
            'Ship to 72-C',
            '1234 Wadhurst Rd.',
            'London',
            null,
            '10309',
            'UK'
        );

        $this->addSalesOrder(
            10551,
            28,
            36,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '72.95',
            'Destination OTSWR',
            'Jardim das rosas n. 9012',
            'Lisboa',
            null,
            '10177',
            'Portugal'
        );

        $this->addSalesOrder(
            10552,
            35,
            36,
            2,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '83.22',
            'Destination UOUWK',
            'Carrera 9012 con Ave. Carlos Soublette #8-35',
            'San Cristóbal',
            'Táchira',
            '10197',
            'Venezuela'
        );

        $this->addSalesOrder(
            10558,
            4,
            36,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '72.97',
            'Ship to 4-B',
            'Brook Farm Stratford St. Mary 1234',
            'Colchester',
            'Essex',
            '10239',
            'UK'
        );

        $this->addSalesOrder(
            10565,
            51,
            36,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '7.15',
            'Ship to 51-C',
            '8901 rue St. Laurent',
            'Montréal',
            'Québec',
            '10246',
            'Canada'
        );

        $this->addSalesOrder(
            10570,
            51,
            37,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '188.99',
            'Ship to 51-C',
            '8901 rue St. Laurent',
            'Montréal',
            'Québec',
            '10246',
            'Canada'
        );

        $this->addSalesOrder(
            10571,
            20,
            37,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '26.06',
            'Destination RVDMF',
            'Kirchgasse 9012',
            'Graz',
            null,
            '10157',
            'Austria'
        );

        $this->addSalesOrder(
            10578,
            11,
            37,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '29.60',
            'Destination NZASL',
            'Fauntleroy Circus 5678',
            'London',
            null,
            '10133',
            'UK'
        );

        $this->addSalesOrder(
            10590,
            51,
            37,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '44.77',
            'Ship to 51-B',
            '7890 rue St. Laurent',
            'Montréal',
            'Québec',
            '10245',
            'Canada'
        );

        $this->addSalesOrder(
            10595,
            20,
            37,
            2,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '96.78',
            'Destination CUVPF',
            'Kirchgasse 1234',
            'Graz',
            null,
            '10159',
            'Austria'
        );

        $this->addSalesOrder(
            10597,
            59,
            37,
            7,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '35.12',
            'Ship to 59-B',
            'Geislweg 7890',
            'Salzburg',
            null,
            '10265',
            'Austria'
        );

        $this->addSalesOrder(
            10599,
            11,
            37,
            6,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '29.98',
            'Destination DLEUN',
            'Fauntleroy Circus 4567',
            'London',
            null,
            '10132',
            'UK'
        );

        $this->addSalesOrder(
            10601,
            35,
            37,
            7,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '58.30',
            'Destination UOUWK',
            'Carrera 9012 con Ave. Carlos Soublette #8-35',
            'San Cristóbal',
            'Táchira',
            '10197',
            'Venezuela'
        );

        $this->addSalesOrder(
            10604,
            28,
            37,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '7.46',
            'Destination CIRQO',
            'Jardim das rosas n. 8901',
            'Lisboa',
            null,
            '10176',
            'Portugal'
        );

        $this->addSalesOrder(
            10605,
            51,
            37,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '379.13',
            'Ship to 51-B',
            '7890 rue St. Laurent',
            'Montréal',
            'Québec',
            '10245',
            'Canada'
        );

        $this->addSalesOrder(
            10607,
            71,
            37,
            5,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '200.24',
            'Ship to 71-C',
            '9012 Suffolk Ln.',
            'Boise',
            'Id',
            '10307',
            'USA'
        );

        $this->addSalesOrder(
            10612,
            71,
            38,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '544.08',
            'Ship to 71-A',
            '7890 Suffolk Ln.',
            'Boise',
            'Id',
            '10305',
            'USA'
        );

        $this->addSalesOrder(
            10613,
            35,
            38,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '8.11',
            'Destination JYDLM',
            'Carrera1234 con Ave. Carlos Soublette #8-35',
            'San Cristóbal',
            'Táchira',
            '10199',
            'Venezuela'
        );

        $this->addSalesOrder(
            10616,
            32,
            38,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '116.53',
            'Destination LLUXZ',
            '1234 Baker Blvd.',
            'Eugene',
            'OR',
            '10189',
            'USA'
        );

        $this->addSalesOrder(
            10617,
            32,
            38,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '18.53',
            'Destination AVQUS',
            '2345 Baker Blvd.',
            'Eugene',
            'OR',
            '10190',
            'USA'
        );

        $this->addSalesOrder(
            10618,
            51,
            38,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '154.68',
            'Ship to 51-C',
            '8901 rue St. Laurent',
            'Montréal',
            'Québec',
            '10246',
            'Canada'
        );

        $this->addSalesOrder(
            10619,
            51,
            38,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '91.05',
            'Ship to 51-B',
            '7890 rue St. Laurent',
            'Montréal',
            'Québec',
            '10245',
            'Canada'
        );

        $this->addSalesOrder(
            10620,
            42,
            39,
            2,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '0.94',
            'Ship to 42-A',
            '1234 Elm St.',
            'Vancouver',
            'BC',
            '10219',
            'Canada'
        );

        $this->addSalesOrder(
            10621,
            38,
            39,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '23.73',
            'Destination LMVGS',
            'Garden House Crowther Way 8901',
            'Cowes',
            'Isle of Wight',
            '10206',
            'UK'
        );

        $this->addSalesOrder(
            10624,
            78,
            39,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '94.80',
            'Ship to 78-C',
            '6789 Grizzly Peak Rd.',
            'Butte',
            'MT',
            '10325',
            'USA'
        );

        $this->addSalesOrder(
            10627,
            71,
            39,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '107.46',
            'Ship to 71-B',
            '8901 Suffolk Ln.',
            'Boise',
            'Id',
            '10306',
            'USA'
        );

        $this->addSalesOrder(
            10633,
            20,
            39,
            7,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '477.90',
            'Destination FFXKT',
            'Kirchgasse 0123',
            'Graz',
            null,
            '10158',
            'Austria'
        );

        $this->addSalesOrder(
            10638,
            47,
            39,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '158.44',
            'Ship to 47-B',
            'Ave. 5 de Mayo Porlamar 4567',
            'I. de Margarita',
            'Nueva Esparta',
            '10231',
            'Venezuela'
        );

        $this->addSalesOrder(
            10641,
            35,
            39,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '179.61',
            'Destination JYDLM',
            'Carrera1234 con Ave. Carlos Soublette #8-35',
            'San Cristóbal',
            'Táchira',
            '10199',
            'Venezuela'
        );

        $this->addSalesOrder(
            10649,
            50,
            39,
            5,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '6.20',
            'Ship to 50-B',
            'Rue Joseph-Bens 4567',
            'Bruxelles',
            null,
            '10242',
            'Belgium'
        );

        $this->addSalesOrder(
            10656,
            32,
            40,
            6,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '57.15',
            'Destination AVQUS',
            '2345 Baker Blvd.',
            'Eugene',
            'OR',
            '10190',
            'USA'
        );

        $this->addSalesOrder(
            10657,
            71,
            40,
            2,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '352.69',
            'Ship to 71-A',
            '7890 Suffolk Ln.',
            'Boise',
            'Id',
            '10305',
            'USA'
        );

        $this->addSalesOrder(
            10660,
            36,
            40,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '111.29',
            'Destination HOHCR',
            'City Center Plaza 3456 Main St.',
            'Elgin',
            'OR',
            '10201',
            'USA'
        );

        $this->addSalesOrder(
            10662,
            48,
            40,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '1.28',
            'Ship to 48-C',
            '7890 Chiaroscuro Rd.',
            'Portland',
            'OR',
            '10234',
            'USA'
        );

        $this->addSalesOrder(
            10664,
            28,
            40,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '1.27',
            'Destination OTSWR',
            'Jardim das rosas n. 9012',
            'Lisboa',
            null,
            '10177',
            'Portugal'
        );

        $this->addSalesOrder(
            10665,
            48,
            40,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '26.31',
            'Ship to 48-B',
            '6789 Chiaroscuro Rd.',
            'Portland',
            'OR',
            '10233',
            'USA'
        );

        $this->addSalesOrder(
            10666,
            68,
            41,
            7,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '232.42',
            'Ship to 68-A',
            'Starenweg 6789',
            'Genève',
            null,
            '10294',
            'Switzerland'
        );

        $this->addSalesOrder(
            10667,
            20,
            41,
            7,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '78.09',
            'Destination CUVPF',
            'Kirchgasse 1234',
            'Graz',
            null,
            '10159',
            'Austria'
        );

        $this->addSalesOrder(
            10671,
            26,
            41,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '30.34',
            'Destination OPXJT',
            '4567, rue Royale',
            'Nantes',
            null,
            '10172',
            'France'
        );

        $this->addSalesOrder(
            10674,
            38,
            41,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '0.90',
            'Destination QVTLW',
            'Garden House Crowther Way 7890',
            'Cowes',
            'Isle of Wight',
            '10205',
            'UK'
        );

        $this->addSalesOrder(
            10678,
            71,
            41,
            7,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '388.98',
            'Ship to 71-A',
            '7890 Suffolk Ln.',
            'Boise',
            'Id',
            '10305',
            'USA'
        );

        $this->addSalesOrder(
            10679,
            7,
            41,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '27.94',
            'Ship to 7-A',
            '0123, place Kléber',
            'Strasbourg',
            null,
            '10329',
            'France'
        );

        $this->addSalesOrder(
            10680,
            55,
            42,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '26.61',
            'Ship to 55-B',
            '8901 Bering St.',
            'Anchorage',
            'AK',
            '10256',
            'USA'
        );

        $this->addSalesOrder(
            10681,
            32,
            42,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '76.13',
            'Destination AVQUS',
            '2345 Baker Blvd.',
            'Eugene',
            'OR',
            '10190',
            'USA'
        );

        $this->addSalesOrder(
            10683,
            18,
            42,
            2,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '4.40',
            'Destination FVRGC',
            '2345, rue des Cinquante Otages',
            'Nantes',
            null,
            '10150',
            'France'
        );

        $this->addSalesOrder(
            10686,
            59,
            42,
            2,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '96.50',
            'Ship to 59-B',
            'Geislweg 7890',
            'Salzburg',
            null,
            '10265',
            'Austria'
        );

        $this->addSalesOrder(
            10693,
            89,
            42,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '139.34',
            'Ship to 89-C',
            '9012 - 12th Ave. S.',
            'Seattle',
            'WA',
            '10358',
            'USA'
        );

        $this->addSalesOrder(
            10696,
            89,
            42,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '102.55',
            'Ship to 89-A',
            '7890 - 12th Ave. S.',
            'Seattle',
            'WA',
            '10356',
            'USA'
        );

        $this->addSalesOrder(
            10697,
            47,
            43,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '45.52',
            'Ship to 47-B',
            'Ave. 5 de Mayo Porlamar 4567',
            'I. de Margarita',
            'Nueva Esparta',
            '10231',
            'Venezuela'
        );

        $this->addSalesOrder(
            10698,
            20,
            43,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '272.47',
            'Destination RVDMF',
            'Kirchgasse 9012',
            'Graz',
            null,
            '10157',
            'Austria'
        );

        $this->addSalesOrder(
            10700,
            71,
            43,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '65.10',
            'Ship to 71-C',
            '9012 Suffolk Ln.',
            'Boise',
            'Id',
            '10307',
            'USA'
        );

        $this->addSalesOrder(
            10705,
            35,
            43,
            9,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '3.52',
            'Destination JYDLM',
            'Carrera1234 con Ave. Carlos Soublette #8-35',
            'San Cristóbal',
            'Táchira',
            '10199',
            'Venezuela'
        );

        $this->addSalesOrder(
            10706,
            55,
            43,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '135.63',
            'Ship to 55-C',
            '9012 Bering St.',
            'Anchorage',
            'AK',
            '10257',
            'USA'
        );

        $this->addSalesOrder(
            10707,
            4,
            44,
            4,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '21.74',
            'Ship to 4-A',
            'Brook Farm Stratford St. Mary 0123',
            'Colchester',
            'Essex',
            '10238',
            'UK'
        );

        $this->addSalesOrder(
            10708,
            77,
            44,
            6,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '2.96',
            'Ship to 77-C',
            '3456 Jefferson Way Suite 2',
            'Portland',
            'OR',
            '10322',
            'USA'
        );

        $this->addSalesOrder(
            10711,
            71,
            44,
            5,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '52.41',
            'Ship to 71-A',
            '7890 Suffolk Ln.',
            'Boise',
            'Id',
            '10305',
            'USA'
        );

        $this->addSalesOrder(
            10713,
            71,
            44,
            1,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '167.05',
            'Ship to 71-C',
            '9012 Suffolk Ln.',
            'Boise',
            'Id',
            '10307',
            'USA'
        );

        $this->addSalesOrder(
            10714,
            71,
            44,
            5,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 3,
            '24.49',
            'Ship to 71-A',
            '7890 Suffolk Ln.',
            'Boise',
            'Id',
            '10305',
            'USA'
        );

        $this->addSalesOrder(
            10715,
            9,
            45,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '63.20',
            'Ship to 9-B',
            '9012, rue des Bouchers',
            'Marseille',
            null,
            '10368',
            'France'
        );

        $this->addSalesOrder(
            10719,
            45,
            45,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 2,
            '51.44',
            'Ship to 45-A',
            '8901 Polk St. Suite 5',
            'San Francisco',
            'CA',
            '10225',
            'USA'
        );

        $this->addSalesOrder(
            10722,
            71,
            45,
            8,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '74.58',
            'Ship to 71-A',
            '7890 Suffolk Ln.',
            'Boise',
            'Id',
            '10305',
            'USA'
        );

        $this->addSalesOrder(
            10723,
            89,
            45,
            3,
            $this->getRandomDate(),
            $this->getRandomDate(),
            $this->getRandomDate(),
            // 1,
            '21.72',
            'Ship to 89-C',
            '9012 - 12th Ave. S.',
            'Seattle',
            'WA',
            '10358',
            'USA'
        );
    }

    private function getRandomDate()
    {
        $currentDate  = new \DateTime();
        $currentYear  = $currentDate->format('Y');
        $previousYear = $currentYear - 1;
        $monthRanges  = [];

// Add ranges for the last 6 months of the current year
        for ($i = 0; $i < 6; $i++) {
            $start = clone $currentDate;
            $start->modify("-$i months");
            $start->modify('first day of this month');
            $end = clone $start;
            $end->modify('last day of this month');

// Ensure the end date is not after the current date
            if ($end > $currentDate) {
                $end = clone $currentDate;
            }

            $monthRanges[] = ["start" => $start->format('Y-m-d'), "end" => $end->format('Y-m-d')];
        }

// Add ranges for May, June, July of the previous year
        for ($month = 5; $month <= 7; $month++) {
            $start = \DateTime::createFromFormat('Y-m-d', "$previousYear-$month-01");
            $end   = clone $start;
            $end->modify('last day of this month');
            $monthRanges[] = ["start" => $start->format('Y-m-d'), "end" => $end->format('Y-m-d')];
        }

        // Select a random range from the list
        $selectedRange = $monthRanges[array_rand($monthRanges)];

        // Generate a random timestamp within the selected range
        $startTimestamp  = strtotime($selectedRange['start']);
        $endTimestamp    = strtotime($selectedRange['end']);
        $randomTimestamp = mt_rand($startTimestamp, $endTimestamp);

        // Convert the timestamp to a date string and return it
        return date('Y-m-d H:i:s', $randomTimestamp);
    }

}
