<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Capsule\Manager as Capsule;

class EnablePivotTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'modules';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {
        Capsule::table($this->table)->updateOrInsert(
            ['name' => 'Pivot tables'],
            [
                'id' => 7,
                'logo'        => '<i class="fa fa-table" aria-hidden="true"></i>',
                'is_active'   => true,
                'description' => 'Description',
                'parent_id'   => null
            ],
        );
    }


    public function rollback()
    {
        Capsule::table($this->table)->updateOrInsert(
            ['name' => 'Pivot tables'],
            [
                'id' => 7,
                'logo'        => '<i class="fa fa-table" aria-hidden="true"></i>',
                'is_active'   => false,
                'description' => 'Description',
                'parent_id'   => null
            ],
        );

    }
}
