<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateScheduledTasksTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'scheduled_tasks';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {
        $prefix = $this->prefix;

        Capsule::schema()->create($this->table, function (Blueprint $table) use ($prefix) {
            $table->id('id');
            $table->string('title', 255);
            $table->string('subject', 100);
            $table->text('body');
            $table->enum('frequency', ['hourly', 'daily', 'weekly','monthly'])->nullable();
            $table->date('begin_date');
            $table->date('end_date');
            $table->string('sending_time', 50)->nullable();
            $table->enum('sending_weekly_day', ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'])->nullable();
            $table->string('sending_monthly_day', 255)->nullable();
            $table->boolean('month_last_day')->nullable();
            $table->timestamp('last_sending_datetime')->nullable();
            $table->enum('last_status', ['active','stopped', 'ended', 'success', 'failed','incomplete', 'deleted'])->nullable();
            $table->timestamp('next_sending_date')->nullable();
            $table->boolean('send_to_admins');
            $table->integer('retry_count')->default(0);
            $table->text('recieved_users')->nullable();
            $table->boolean('worked_now')->default(0);
            $table->foreignId('created_by')->nullable()->references('user_ID')->on($prefix . 'Users')->onUpdate('cascade')->onDelete('set null');
            $table->foreignId('edited_by')->nullable()->references('user_ID')->on($prefix . 'Users')->onUpdate('cascade')->onDelete('set null');
            $table->foreignId('deleted_by')->nullable()->references('user_ID')->on($prefix . 'Users')->onUpdate('cascade')->onDelete('set null');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    public function rollback()
    {
        Capsule::schema()->dropIfExists($this->table);
    }
}
