<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateScheduledTaskHistoryTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'scheduled_task_history';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {
        Capsule::schema()->create($this->table, function (Blueprint $table) {
            $table->id('id');
            $table->foreignId('task_id')->references('id')->on($this->prefix . 'scheduled_tasks');
            $table->timestamp('start_sending_date')->nullable();
            $table->timestamp('end_sending_date')->nullable();
            $table->text('error_message')->nullable();
            $table->enum('status', ['active', 'stopped', 'ended', 'success', 'failed', 'incomplete', 'deleted'])->nullable();
            $table->integer('total_sent')->nullable();
            $table->integer('total_failed')->nullable();
            $table->timestamp('next_sending_date')->nullable();
            $table->string('info', 255)->nullable();

        });
    }

    public function rollback()
    {
        Capsule::schema()->dropIfExists($this->table);
    }
}
