<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateNorthWindTables
{
    public $prefix;

    public function __construct()
    {
        $this->prefix = 'test_';
    }

    public function run()
    {
        $this->createCategoryTable();
        $this->createEmployeeTable();
        $this->createCustomerTable();
        $this->createSupplierTable();
        $this->createProductTable();
        $this->createSalesOrderTable();
    }

    public function getTableName()
    {
        return 'CreateNorthWindTables';
    }

    public function createCategoryTable()
    {
        $tableName = $this->prefix . 'Category';

        if (!Capsule::schema()->hasTable($tableName)) {

            Capsule::schema()->create($tableName, function (Blueprint $table) {
                $table->id('categoryId');
                $table->string('categoryName', 15);
                $table->text('description')->nullable();
                $table->text('picture')->nullable();
                $table->timestamp('created_at')->useCurrent();
                $table->timestamp('updated_at')->nullable();

            });
        }

    }

    public function createEmployeeTable()
    {
        $tableName = $this->prefix . 'Employee';

        if (!Capsule::schema()->hasTable($tableName)) {

            Capsule::schema()->create($tableName, function (Blueprint $table) {
                $table->id('employeeId');
                $table->string('lastname', 20);
                $table->string('firstname', 10);
                $table->string('title', 30)->nullable();
                $table->string('titleOfCourtesy', 25)->nullable();
                $table->dateTime('birthDate')->nullable();
                $table->dateTime('hireDate')->nullable();
                $table->string('address', 60)->nullable();
                $table->string('city', 15)->nullable();
                $table->string('region', 15)->nullable();
                $table->string('postalCode', 10)->nullable();
                $table->string('country', 15)->nullable();
                $table->string('phone', 24)->nullable();
                $table->string('extension', 4)->nullable();
                $table->string('mobile', 24)->nullable();
                $table->string('email', 225)->nullable();
                $table->binary('photo')->nullable();
                $table->binary('notes')->nullable();
                $table->integer('mgrId')->nullable();
                $table->string('photoPath')->nullable();
                $table->timestamp('created_at')->useCurrent();
                $table->timestamp('updated_at')->nullable();

            });
        }

    }

    public function createCustomerTable()
    {
        $tableName = $this->prefix . 'Customer';

        if (!Capsule::schema()->hasTable($tableName)) {

            Capsule::schema()->create($tableName, function (Blueprint $table) {
                $table->id('custId');
                $table->string('companyName', 40);
                $table->string('contactName', 30)->nullable();
                $table->string('contactTitle', 30)->nullable();
                $table->string('address', 60)->nullable();
                $table->string('city', 15)->nullable();
                $table->string('region', 15)->nullable();
                $table->string('postalCode', 10)->nullable();
                $table->string('country', 15)->nullable();
                $table->string('phone', 24)->nullable();
                $table->string('mobile', 24)->nullable();
                $table->string('email', 225)->nullable();
                $table->string('fax', 24)->nullable();
                $table->timestamp('created_at')->useCurrent();
                $table->timestamp('updated_at')->nullable();

            });
        }

    }

    public function createProductTable()
    {
        $tableName = $this->prefix . 'Product';

        if (!Capsule::schema()->hasTable($tableName)) {

            Capsule::schema()->create($tableName, function (Blueprint $table) {
                $table->id('productId');
                $table->string('productName', 40);
                $table->foreignId('supplierId')->nullable()->references('supplierId')
                    ->on($this->prefix . 'Supplier')
                    ->onUpdate('cascade')
                    ->onDelete('set null');

                $table->foreignId('categoryId')->nullable()
                    ->references('categoryId')
                    ->on($this->prefix . 'Category')
                    ->onUpdate('cascade')
                    ->onDelete('set null');

                $table->string('quantityPerUnit', 20)->nullable();
                $table->decimal('unitPrice', 10)->nullable();
                $table->smallInteger('unitsInStock')->nullable();
                $table->smallInteger('unitsOnOrder')->nullable();
                $table->smallInteger('reorderLevel')->nullable();
                $table->char('discontinued', 1);
                $table->string('made_in');
                $table->integer('paid');

                $table->timestamp('created_at')->useCurrent();
                $table->timestamp('updated_at')->nullable();

            });
        }

    }

    public function createSupplierTable()
    {
        $tableName = $this->prefix . 'Supplier';

        if (!Capsule::schema()->hasTable($tableName)) {

            Capsule::schema()->create($tableName, function (Blueprint $table) {
                $table->id('supplierId');
                $table->string('companyName', 40);
                $table->string('contactName', 30)->nullable();
                $table->string('contactTitle', 30)->nullable();
                $table->string('address', 60)->nullable();
                $table->string('city', 15)->nullable();
                $table->string('region', 15)->nullable();
                $table->string('postalCode', 10)->nullable();
                $table->string('country', 15)->nullable();
                $table->string('phone', 24)->nullable();
                $table->string('email', 225)->nullable();
                $table->string('fax', 24)->nullable();
                $table->text('HomePage')->nullable();
                $table->timestamp('created_at')->useCurrent();
                $table->timestamp('updated_at')->nullable();
            });
        }

    }

    public function createSalesOrderTable()
    {
        $tableName = $this->prefix . 'SalesOrder';

        $prefix = $this->prefix;

        if (!Capsule::schema()->hasTable($tableName)) {

            Capsule::schema()->create($tableName, function (Blueprint $table) {

                $table->id('orderId');
                $table->foreignId('custId')->nullable()->references('custId')->on($this->prefix . 'Customer')->onUpdate('cascade')->onDelete('set null');
                $table->foreignId('employeeId')->nullable()->references('employeeId')->on($this->prefix . 'Employee')->onUpdate('cascade')->onDelete('set null');
                $table->foreignId('productId')->nullable()->references('productId')->on($this->prefix . 'Product')->onUpdate('cascade')->onDelete('set null');

                $table->dateTime('orderDate')->nullable();
                $table->dateTime('requiredDate')->nullable();
                $table->dateTime('shippedDate')->nullable();
                $table->decimal('freight', 10)->nullable();
                $table->string('shipName', 40)->nullable();
                $table->string('shipAddress', 60)->nullable();
                $table->string('shipCity', 15)->nullable();
                $table->string('shipRegion', 15)->nullable();
                $table->string('shipPostalCode', 10)->nullable();
                $table->string('shipCountry', 15)->nullable();

            });
        }

    }

    public function rollback()
    {
        Capsule::statement('SET FOREIGN_KEY_CHECKS=0;');

        $tables = array_map(function ($table) {
            return $this->prefix . $table;
        }, [
            'Product',
            'SalesOrder',
            'Employee',
            'Customer',
            'Supplier',
            'Category'
        ]);

        foreach ($tables as $table) {

            Capsule::schema()->drop($table);
        }

        Capsule::statement('SET FOREIGN_KEY_CHECKS=1;');

    }

}
