<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateEmbeddingPreferenceTable
{
    public $table;
    public $prefix;
    public function __construct()
    {
        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'embedding_preferences';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {

        $prefix = $this->prefix;

        Capsule::schema()->create($this->table, function (Blueprint $table) use ($prefix) {
            $table->id('id');
            $table->string('key', 255);
            $table->text('value')->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function rollback()
    {
        Capsule::schema()->dropIfExists($this->table);
    }
}