<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateEmbedTokensTable
{
    public $table;
    public $prefix;
    public function __construct()
    {
        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'embed_tokens';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {

        $prefix = $this->prefix;

        Capsule::schema()->create($this->table, function (Blueprint $table) use ($prefix) {
            $table->id('id');
            $table->foreignId('access_key_id')->nullable()->references('id')->on($prefix . 'access_keys')->onUpdate('cascade')->onDelete('set null');
            $table->text('token');
            $table->string('allowed_resource_url');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
            $table->timestamp('expire_at')->nullable();
        });
    }

    public function rollback()
    {
        Capsule::schema()->dropIfExists($this->table);
    }
}
