<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateDataConnectionsTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'dataconnections';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {
        Capsule::schema()->create($this->table, function (Blueprint $table) {
            $table->id('id');
            $table->string('connection_name', 255);
            $table->enum('db_type', ['MYSQL', 'PostgreSQL', 'MongoDB', 'MSSQL']);
            $table->string('server', 255);
            $table->string('db', 255);
            $table->text('connection_string');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    public function rollback()
    {
        Capsule::schema()->dropIfExists($this->table);
    }
}
