<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateBarcodesUsageTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'barcode_usage';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {

        Capsule::schema()->create($this->table, function (Blueprint $table) {
            $table->id('id');
            $table->foreignId('barcode_definition_id')->nullable()->references('id')->on($this->prefix . 'barcode_definitions')->onUpdate('cascade')->onDelete('set null');
            $table->foreignId('resource_id')->nullable()->references('id')->on($this->prefix . 'analytics_resources')->onUpdate('cascade')->onDelete('set null');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function rollback()
    {
        Capsule::schema()->dropIfExists($this->table);
    }
}
