<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateBarcodesDefinitionsTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'barcode_definitions';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {

        Capsule::schema()->create($this->table, function (Blueprint $table) {
            $table->id('id');
            $table->string('label', 100);
            $table->string('type', 50);
            $table->boolean('display_value')->default(true);
            $table->integer('font_size')->default(12);
            $table->integer('width')->default(2);
            $table->integer('height')->default(60);
            $table->enum('text_align',['left','center','right'])->default('center');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function rollback()
    {
        Capsule::schema()->dropIfExists($this->table);
    }
}
