<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateAccessKeysTable
{
    public $table;
    public $prefix;
    public function __construct()
    {
        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'access_keys';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {

        $prefix = $this->prefix;

        Capsule::schema()->create($this->table, function (Blueprint $table) use ($prefix) {
            $table->id('id');
            $table->string('label', 50)->unique();
            $table->text('access_key')->nullable();
            $table->enum('type', ['limited','full']);
            $table->foreignId('group_id')->nullable()->references('group_ID')->on($prefix . 'Group')->onUpdate('cascade')->onDelete('set null');
            $table->text('allowed_origins')->nullable();
            $table->enum('origin_type', ['any-origin','same-origin','approved-origins'])->nullable();
            $table->integer('uses_count')->default(0);
            $table->timestamp('deleted_at')->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function rollback()
    {
        Capsule::schema()->dropIfExists($this->table);
    }
}
